/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.compiler.JRubyCompilerSettings;
import org.jetbrains.plugins.ruby.ruby.compiler.JRubyCompilerUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc.JRubyCompileBeforeRunTask;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc.JRubyCompilerSettingsDialog;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyCommandLineExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubyCompileBeforeRunTaskProvider
extends BeforeRunTaskProvider<JRubyCompileBeforeRunTask> {
    public static final Key<JRubyCompileBeforeRunTask> ID = Key.create((String)"JRubyCompiler");
    @NonNls
    private static final String JRUBY_COMPILER_NOTIFICATION_GROUP_ID = "JRuby Compiler";

    public Key<JRubyCompileBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return JRubyCompileBeforeRunTaskProvider.getNameText();
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Actions.Compile;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public JRubyCompileBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        return new JRubyCompileBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull JRubyCompileBeforeRunTask task) {
        if (runConfiguration == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (task == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        Project project = runConfiguration.getProject();
        if (!(runConfiguration instanceof RubyRunConfiguration)) {
            JRubyCompileBeforeRunTaskProvider.showAddingTaskErrorMessage(project, RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.error2"));
            return false;
        }
        if (!JRubySdkUtil.isJRubySDK(((RubyRunConfiguration)runConfiguration).getSdk())) {
            JRubyCompileBeforeRunTaskProvider.showAddingTaskErrorMessage(project, RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.error"));
            return false;
        }
        JRubyCompilerSettings settings = JRubyCompilerSettingsDialog.showDialog(project, task);
        if (settings == null) {
            return false;
        }
        task.setTargetPath(settings.getTargetPath());
        task.setOptions(settings.getAdditionalOptions());
        task.setHeapSize(settings.getHeapSize());
        task.setClearTarget(settings.clearTargetDirectory());
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull JRubyCompileBeforeRunTask task) {
        if (configuration == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        String path = task.getTargetPath();
        File targetPath = new File(path);
        if (!(configuration instanceof RubyRunConfiguration && (StringUtil.isEmpty((String)path) || targetPath.exists() && targetPath.isDirectory()))) {
            return false;
        }
        Sdk sdk = ((RubyRunConfiguration)configuration).getSdk();
        Module module = JRubyCompileBeforeRunTaskProvider.getModule(configuration);
        return JRubySdkUtil.isJRubySDK(sdk) && module != null;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull JRubyCompileBeforeRunTask task) {
        if (context == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (env == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        Runnable runnable = () -> FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.nonModal());
        RubyRunConfiguration rConfig = (RubyRunConfiguration)configuration;
        final Project project = rConfig.getProject();
        Sdk sdk = rConfig.getSdk();
        Module module = JRubyCompileBeforeRunTaskProvider.getModule((RunConfiguration)rConfig);
        assert (sdk != null) : "Sdk cannot be null here";
        assert (module != null) : "Module cannot be null here";
        if (!JRubySdkUtil.isJRubySDK(sdk)) {
            Notifications.Bus.notify((Notification)new Notification(JRUBY_COMPILER_NOTIFICATION_GROUP_ID, RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.error.title"), RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.error"), NotificationType.ERROR));
            return false;
        }
        final RubyRunner runner = RunnerUtil.getRunner(sdk, module);
        final RubyCommandLine commandLine = JRubyCompilerUtil.createJRubyCompilerCommandLine(runner, rConfig, task);
        final ArrayList exceptions = new ArrayList();
        final Semaphore targetDone = new Semaphore();
        try {
            if (task.clearTargetDirectory()) {
                JRubyCompileBeforeRunTaskProvider.clearDirectory(task.getTargetPath());
            }
            SwingUtilities.invokeAndWait(() -> {
                targetDone.down();
                Task.Backgroundable t = new Task.Backgroundable(this, project, RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.title"), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            String title = RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.title");
                            String title2 = RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.title2");
                            ProcessOutput output2 = runner.execute(RubyCommandLineExecutionContext.create(commandLine, project, (ExecutionMode)new ExecutionModes.SameThreadMode(false, title, -1)));
                            assert (output2 != null);
                            if (JRubyCompileBeforeRunTaskProvider.checkErrors(output2)) {
                                ExecutionHelper.showOutput((Project)project, (ProcessOutput)output2, (String)title2, null, (boolean)true);
                            }
                        }
                        catch (ExecutionException e) {
                            exceptions.add(e);
                        }
                        targetDone.up();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/run/configuration/beforeRun/jrubyc/JRubyCompileBeforeRunTaskProvider$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)t);
            });
        }
        catch (Exception e) {
            return false;
        }
        targetDone.waitFor();
        if (!exceptions.isEmpty()) {
            ExecutionHelper.showExceptions((Project)project, exceptions, new ArrayList(), (String)RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.error.title"), null);
        }
        return true;
    }

    private static void showAddingTaskErrorMessage(Project project, @NlsContexts.DialogMessage String message) {
        Messages.showErrorDialog((Project)project, (String)message, (String)RBundle.message((String)"run.configuration.before.run.jruby.compiler.execute.error.title2"));
    }

    @Nullable
    private static Module getModule(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            JRubyCompileBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        RunConfigurationModule runConfigurationModule = runConfiguration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule() : null;
        return runConfigurationModule != null ? runConfigurationModule.getModule() : null;
    }

    private static boolean checkErrors(ProcessOutput output2) {
        return !output2.getStderr().isEmpty() || output2.getStdout().contains("Compilation FAILED");
    }

    private static void clearDirectory(String path) {
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        boolean success = true;
        for (File f : files) {
            success &= FileUtil.delete((File)f);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public static String getNameText() {
        return RBundle.message((String)"run.configuration.before.run.jruby.compiler.description");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/beforeRun/jrubyc/JRubyCompileBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

