/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.GemRunnerBasedParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.support.ConfigurationUIUtil;

public final class RunConfigurationUIUtil {
    public static final String FILENAMES_SEPARATOR = "||";
    public static final String FILENAMES_SEPARATOR_REGEX = "\\|\\|";

    private RunConfigurationUIUtil() {
    }

    public static LabeledComponent<RawCommandLineEditor> createRawEditorComponent(Ref<? super RawCommandLineEditor> rawEditorWrapper, @NlsContexts.Label String labelTextWithMnemonic) {
        RawCommandLineEditor rawEditor = new RawCommandLineEditor();
        rawEditorWrapper.set((Object)rawEditor);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)rawEditor);
        myComponent.setText(labelTextWithMnemonic);
        return myComponent;
    }

    public static LabeledComponent createTextFieldLabeledComponent(Ref<? super JTextField> textFieldRef, @NlsContexts.Label String text) {
        return RunConfigurationUIUtil.createTextFieldLabeledComponent(textFieldRef, text, null);
    }

    public static LabeledComponent createTextFieldLabeledComponent(Ref<? super JTextField> textFieldRef, @NlsContexts.Label String text, @Nullable @Nls String toolTipText) {
        JTextField testFileMaskTextField = new JTextField();
        textFieldRef.set((Object)testFileMaskTextField);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)testFileMaskTextField);
        myComponent.setText(text);
        if (toolTipText != null) {
            myComponent.setToolTipText(toolTipText);
        }
        return myComponent;
    }

    public static LabeledComponent<TextFieldWithBrowseButton> createScriptPathComponent(Ref<? super TextFieldWithBrowseButton> testScriptTextFieldWrapper, @NlsContexts.Label String text) {
        TextFieldWithBrowseButton testScriptTextField = new TextFieldWithBrowseButton();
        testScriptTextFieldWrapper.set((Object)testScriptTextField);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)testScriptTextField);
        myComponent.setText(text);
        return myComponent;
    }

    public static LabeledComponent createTestFolderComponent(Ref<? super TextFieldWithBrowseButton> testsFolderTextFieldWrapper) {
        TextFieldWithBrowseButton testsFolderTextField = new TextFieldWithBrowseButton();
        testsFolderTextFieldWrapper.set((Object)testsFolderTextField);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)testsFolderTextField);
        myComponent.setText(RBundle.message((String)"run.configuration.messages.folder.path"));
        return myComponent;
    }

    public static FileChooserDescriptor addFolderChooser(@NlsContexts.DialogTitle @NotNull String title, @NotNull TextFieldWithBrowseButton textField, Project project) {
        if (title == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(0);
        }
        if (textField == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor folderChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title);
        textField.addBrowseFolderListener(project, folderChooserDescriptor);
        return folderChooserDescriptor;
    }

    public static FileChooserDescriptor addFileChooser(@NlsContexts.DialogTitle String title, TextFieldWithBrowseButton textField, Project project) {
        return ConfigurationUIUtil.addFileChooser(title, textField, project);
    }

    public static LabeledComponent createRunnerOptionsComponent(Ref<? super RawCommandLineEditor> runnerOptionsEditorRef) {
        RawCommandLineEditor runnerOptionsEditor = new RawCommandLineEditor();
        runnerOptionsEditorRef.set((Object)runnerOptionsEditor);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)runnerOptionsEditor);
        myComponent.setText(RBundle.message((String)"run.configuration.messages.runner.options"));
        return myComponent;
    }

    public static LabeledComponent createRSpecExamplesComponent(@NotNull Ref<? super ExpandableTextField> runnerOptionsEditorRef) {
        if (runnerOptionsEditorRef == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(2);
        }
        ExpandableTextField examplesEditor = new ExpandableTextField(text -> Arrays.asList(text.split(FILENAMES_SEPARATOR_REGEX)), strings -> StringUtil.join((Collection)strings, (String)FILENAMES_SEPARATOR));
        runnerOptionsEditorRef.set((Object)examplesEditor);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)examplesEditor);
        myComponent.setText(RBundle.message((String)"rspec.run.configuration.tests.dialog.components.example.name"));
        return myComponent;
    }

    public static LabeledComponent<ExpandableTextField> createRSpecLineNumberExampleIDsComponent(@NotNull Ref<? super ExpandableTextField> lineNumberOrExampleIDsEditorRef) {
        if (lineNumberOrExampleIDsEditorRef == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(3);
        }
        ExpandableTextField fieldEditor = new ExpandableTextField();
        lineNumberOrExampleIDsEditorRef.set((Object)fieldEditor);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)fieldEditor);
        myComponent.setText(RBundle.message((String)"rspec.run.configuration.tests.dialog.components.line.number.example.id"));
        myComponent.setToolTipText(RBundle.message((String)"rspec.run.configuration.tests.dialog.components.line.number.example.id.tooltip"));
        return myComponent;
    }

    @NotNull
    public static LabeledComponent<TextFieldWithBrowseButton> createMultiFileChooserTextField(@NotNull Ref<? super TextFieldWithBrowseButton> textFieldWrapper, @NlsContexts.Label @NotNull String text, final @Nullable Project project, final @NotNull FileType fileType, final @Nullable Condition<? super VirtualFile> filter) {
        if (textFieldWrapper == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(6);
        }
        final TextFieldWithBrowseButton testScriptTextField = new TextFieldWithBrowseButton((JTextField)new ExpandableTextField(fieldText -> Arrays.asList(fieldText.split(FILENAMES_SEPARATOR_REGEX)), strings -> StringUtil.join((Collection)strings, (String)FILENAMES_SEPARATOR)));
        testScriptTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true).withFileFilter(filter).withExtensionFilter(fileType);
                FileChooserDialogImpl dialog = new FileChooserDialogImpl(descriptor, project);
                VirtualFile[] selectedFiles = (VirtualFile[])Arrays.stream(testScriptTextField.getText().split(RunConfigurationUIUtil.FILENAMES_SEPARATOR_REGEX)).map(path -> VfsUtil.findFile((Path)Path.of(path, new String[0]), (boolean)false)).toArray(VirtualFile[]::new);
                VirtualFile[] chosenFiles = dialog.choose(project, selectedFiles);
                ArrayList<String> unwrappedFilesNames = new ArrayList<String>();
                for (VirtualFile fileOrDir : chosenFiles) {
                    if (fileOrDir.isDirectory()) {
                        for (VirtualFile file : VfsUtil.collectChildrenRecursively((VirtualFile)fileOrDir)) {
                            if (!FileTypeRegistry.getInstance().isFileOfType(file, fileType)) continue;
                            unwrappedFilesNames.add(FileUtil.toSystemDependentName((String)file.getPath()));
                        }
                        continue;
                    }
                    unwrappedFilesNames.add(FileUtil.toSystemDependentName((String)fileOrDir.getPath()));
                }
                testScriptTextField.setText(String.join((CharSequence)RunConfigurationUIUtil.FILENAMES_SEPARATOR, unwrappedFilesNames));
            }
        });
        textFieldWrapper.set((Object)testScriptTextField);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)testScriptTextField);
        myComponent.setText(text);
        LabeledComponent labeledComponent = myComponent;
        if (labeledComponent == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(7);
        }
        return labeledComponent;
    }

    @NotNull
    public static List<String> splitFilenames(@NotNull String text) {
        if (text == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.map((Object[])text.split(FILENAMES_SEPARATOR_REGEX), String::trim);
        if (list == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static String joinFilenames(@NotNull List<String> filenames) {
        if (filenames == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(10);
        }
        String string = StringUtil.join(filenames, String::trim, (String)FILENAMES_SEPARATOR);
        if (string == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static GemRunnerBasedParamsEditor createGemRunnerBasedParamsEditor(@NotNull JPanel panel2, @NotNull List<String> gemNameList, @Nullable Map<String, GemRunnerBasedParamsEditor.Filter> gems2FilterTable, @NotNull RubyCommonRunParamsEditor commonEditor) {
        if (panel2 == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(12);
        }
        if (gemNameList == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(13);
        }
        if (commonEditor == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(14);
        }
        GemRunnerBasedParamsEditor paramsEditor = new GemRunnerBasedParamsEditor(gemNameList, gems2FilterTable, commonEditor);
        panel2.add((Component)paramsEditor.getMainPanel(), "Center");
        return paramsEditor;
    }

    public static RubyCommonRunParamsEditor createRubyCommonRunParamsEditor(@NotNull AbstractRubyRunConfiguration configuration, @NotNull String gemName, @NotNull JPanel commonOptionsPanel) {
        if (configuration == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(15);
        }
        if (gemName == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(16);
        }
        if (commonOptionsPanel == null) {
            RunConfigurationUIUtil.$$$reportNull$$$0(17);
        }
        RubyCommonRunParamsEditor commonEditor = new RubyCommonRunParamsEditor(configuration);
        commonEditor.setUseAlternativeSdkLabel(gemName);
        commonOptionsPanel.add((Component)commonEditor.getMainPanel(), "Center");
        return commonEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerOptionsEditorRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineNumberOrExampleIDsEditorRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWrapper";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUIUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemNameList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonEditor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUIUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiFileChooserTextField";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "splitFilenames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "joinFilenames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFolderChooser";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRSpecExamplesComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRSpecLineNumberExampleIDsComponent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMultiFileChooserTextField";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "splitFilenames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinFilenames";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createGemRunnerBasedParamsEditor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRubyCommonRunParamsEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

