/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;

public class RubyProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NonNls
    public static final String RUBY_RUNNER_ID = "RubyProgramRunner";
    @NonNls
    protected static final String RUBY_COVERAGE_RUNNER_ID = "RubyCover";

    @NotNull
    protected final Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            RubyProgramRunner.$$$reportNull$$$0(0);
        }
        if (state == null) {
            RubyProgramRunner.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AsyncPromise result = new AsyncPromise();
        AppJavaExecutorUtil.executeOnPooledIoThread((Runnable)ClientId.decorateRunnable(() -> {
            try {
                this.doExecute(state, environment, (AsyncPromise<RunContentDescriptor>)result);
            }
            catch (ExecutionException e) {
                result.setError((Throwable)e);
            }
        }));
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            RubyProgramRunner.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    protected void doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment, @NotNull AsyncPromise<RunContentDescriptor> result) throws ExecutionException {
        ExecutionResult executionResult;
        if (state == null) {
            RubyProgramRunner.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            RubyProgramRunner.$$$reportNull$$$0(4);
        }
        if (result == null) {
            RubyProgramRunner.$$$reportNull$$$0(5);
        }
        if ((executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this)) == null) {
            result.setResult(null);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> result.setResult((Object)new RunContentBuilder(executionResult, environment).showRunContent(environment.getContentToReuse())), ModalityState.any());
        }
    }

    @NotNull
    public String getRunnerId() {
        return RUBY_RUNNER_ID;
    }

    public boolean preloaderAllowed() {
        return true;
    }

    public boolean isExplicitSpringAllowed() {
        return true;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RubyProgramRunner.$$$reportNull$$$0(6);
        }
        if (profile == null) {
            RubyProgramRunner.$$$reportNull$$$0(7);
        }
        return executorId.equals("Run") && profile instanceof AbstractRubyRunConfiguration;
    }

    public static <Result> Result computeOnEdtWithExecutionException(ThrowableComputable<Result, ? extends ExecutionException> computable) throws ExecutionException {
        Ref resultRef = Ref.create();
        Ref errorRef = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                resultRef.set(computable.compute());
            }
            catch (ExecutionException e) {
                errorRef.set((Object)e);
            }
        }, ModalityState.any());
        if (!errorRef.isNull()) {
            throw (ExecutionException)((Object)errorRef.get());
        }
        return (Result)resultRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyProgramRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyProgramRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

