/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathMappingSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.rails.run.filters.RailsControllerActionFilter;
import org.jetbrains.plugins.ruby.rails.run.filters.RailsUrlFilter;
import org.jetbrains.plugins.ruby.rails.run.filters.RailsViewsFileFilter;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugRunner;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyRemoteDebugRunner;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.LocalPositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RemotePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.BundlerMissingGemsProcessAdapter;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleFilterProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandlerEx;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunEnvironmentProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyProgramRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugHelperFactory;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugIdeGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public abstract class RubyAbstractCommandLineState
extends CommandLineState {
    protected static final Logger LOG = Logger.getInstance(RubyAbstractCommandLineState.class);
    @NotNull
    @NonNls
    public static final String DEBUGGER_PARAMS_GROUP_ID = "ruby.debugger";
    @NonNls
    private static final String RDEBUG_COMMAND_DELIMITER = "--";
    @NonNls
    private static final String PORT = "--port";
    @NonNls
    private static final String HOST = "--host";
    @NonNls
    private static final String FEATURE_ID_PREFIX = "ruby.command.line.state.";
    private final AbstractRubyRunConfiguration<?> myConfig;
    private final boolean myAllocatePty;
    @NonNls
    private static final String RUBY_EXECUTION_WITHOUT_PARENT_ENV_NOTIFICATION_GROUP_ID = "Ruby execution without parent environment";
    private static final AtomicBoolean VALIDATE_CONFIGURATION = new AtomicBoolean(true);

    protected RubyAbstractCommandLineState(AbstractRubyRunConfiguration<?> config, @Nullable ExecutionEnvironment environment, boolean allocatePty) {
        super(environment);
        this.myConfig = config;
        this.myAllocatePty = allocatePty;
        this.getConsoleBuilder().filters(this.createConsoleMessageFilters());
    }

    @TestOnly
    protected RubyAbstractCommandLineState(AbstractRubyRunConfiguration<?> config) {
        this(config, null, false);
    }

    public AbstractRubyRunConfiguration<?> getConfig() {
        return this.myConfig;
    }

    protected String getRunnerId() {
        return this.getEnvironment().getRunner().getRunnerId();
    }

    public List<Filter> createConsoleMessageFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)new UrlFilter());
        Module module = this.getConfig().getModule();
        if (module != null) {
            Project project = module.getProject();
            filters.add(new RStackTraceFilter(module));
            filters.add(new RailsControllerActionFilter(project, module));
            filters.add(new RailsUrlFilter(project));
            filters.add(new RailsViewsFileFilter(project, module));
        }
        return filters;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        super.setConsoleBuilder(consoleBuilder);
        this.getConsoleBuilder().filters(this.createConsoleMessageFilters());
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = (ProcessHandler)this.createCommandLineAndProcessHandler().getSecond();
        if (processHandler == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(0);
        }
        return processHandler;
    }

    @NotNull
    public DefaultExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(3);
        }
        ConsoleView console = this.createAndAttachConsole(this.getConfig().getProject(), processHandler, executor);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler, executor));
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(4);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(5);
        }
        ProcessHandler processHandler = this.startProcess();
        ExecutionResult executionResult = (ExecutionResult)RubyProgramRunner.computeOnEdtWithExecutionException(() -> this.execute(executor, runner, processHandler));
        if (executionResult == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(6);
        }
        return executionResult;
    }

    protected boolean allocatePty() {
        return this.myAllocatePty || Registry.is((String)"ruby.run.configurations.with.pty");
    }

    public Pair<RubyCommandLineData, ProcessHandler> createCommandLineAndProcessHandler() throws ExecutionException {
        Collection portForwardings;
        Module module;
        if (!this.getConfig().isPassParentEnvs()) {
            this.notifyMissingEnv();
        }
        RubyCommandLineData data = this.createRunCommandLine();
        RubyCommandLine cmdLine = data.getCommandLine();
        RubyRunner runner = (RubyRunner)data.getUserData(RubyCommandLineData.RUNNER_KEY);
        assert (runner != null);
        RunConfigurationUtil.includeUserDefinedLoadPathRoots(cmdLine, this.getConfig().getModule());
        FeatureUsageTracker.getInstance().triggerFeatureUsed(FEATURE_ID_PREFIX + ((Object)((Object)this)).getClass().getSimpleName());
        RunnerSettings runnerSettings = this.getRunnerSettings();
        RubyRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)this.getConfig(), runnerSettings, cmdLine, this.getRunnerId(), this.getEnvironment().getExecutor());
        ProcessHandler processHandler = this.createOSProcessHandler(runner, cmdLine.withPty(this.allocatePty()));
        if (runner instanceof RubyLocalRunner && (module = ((RubyLocalRunner)runner).getModule()) != null) {
            BundlerMissingGemsProcessAdapter.Companion.attach(processHandler, module);
        }
        if ((portForwardings = (Collection)data.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)) != null && processHandler instanceof RubyProcessHandlerEx) {
            for (PortForwarding forwarding : portForwardings) {
                try {
                    ((RubyProcessHandlerEx)processHandler).addTunnel(forwarding);
                }
                catch (ExecutionException e) {
                    LOG.warn("Unable to add tunnel", (Throwable)e);
                }
            }
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        RubyRunConfigurationExtensionsManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler, this.getRunnerSettings());
        return Pair.create((Object)((Object)data), (Object)processHandler);
    }

    protected abstract RubyCommandLineData createRunCommandLine() throws ExecutionException;

    @NotNull
    public ConsoleView createAndAttachConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        if (project == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(7);
        }
        if (processHandler == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(9);
        }
        ConsoleView consoleView = this.getConsoleBuilder().getConsole();
        consoleView.attachToProcess(processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(10);
        }
        return consoleView2;
    }

    @NotNull
    protected ProcessHandler createOSProcessHandler(@NotNull RubyRunner runner, @NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (runner == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(12);
        }
        ProcessHandler processHandler = runner.createProcessHandler(commandLine, this.getRunnerId());
        if (processHandler == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(13);
        }
        return processHandler;
    }

    public final ParamsGroup addExecutionScriptGroup(@NotNull String scriptTypeId, @NotNull RubyCommandLineData data, @NotNull GeneralCommandLine commandLine, @NotNull String executionScriptPath) {
        AbstractRubyRunConfiguration<?> config;
        Sdk sdk;
        if (scriptTypeId == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(14);
        }
        if (data == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(15);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(16);
        }
        if (executionScriptPath == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(17);
        }
        LOG.assertTrue((sdk = (config = this.getConfig()).getSdk()) != null);
        RubyRunner runner = (RubyRunner)data.getUserData(RubyCommandLineData.RUNNER_KEY);
        LOG.assertTrue(runner != null);
        return RubyAbstractCommandLineState.addExecutionScriptGroup(scriptTypeId, data, commandLine, executionScriptPath, sdk, config.getModule());
    }

    public boolean preLoaderAllowed() {
        return RubyAbstractCommandLineState.preLoaderAllowed(this.getRunnerId());
    }

    protected boolean isInRubyDebugMode() {
        return RubyAbstractCommandLineState.isInRubyDebugMode(this.getRunnerId());
    }

    private void notifyMissingEnv() {
        final Notification notification = new Notification(RUBY_EXECUTION_WITHOUT_PARENT_ENV_NOTIFICATION_GROUP_ID, RBundle.message((String)"run.without.parent.environment.title"), RBundle.message((String)"run.without.parent.environment.text"), NotificationType.WARNING);
        notification.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"run.without.parent.environment.action.enable")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyAbstractCommandLineState.this.getConfig().setPassParentEnvs(true);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState$1", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)notification);
    }

    @NotNull
    public static RubyCommandLineData createDefaultCommandLine(@NotNull AbstractRubyRunConfiguration<?> config, @Nullable String runnerId) throws ExecutionException {
        if (config == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(18);
        }
        try {
            if (VALIDATE_CONFIGURATION.get()) {
                config.checkConfiguration();
            }
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        Sdk sdk = config.getSdk();
        assert (sdk != null) : "Sdk cannot be null here";
        HashMap<String, String> environment = new HashMap<String, String>(config.getEnvs());
        RunEnvironmentProvider.processRunConfig(sdk, config.getModule(), environment);
        RubyRunner runner = RunnerUtil.getRunner(sdk, config.getModule());
        RubyCommandLineData data = RubyAbstractCommandLineState.isInRubyDebugMode(runnerId) ? RubyAbstractCommandLineState.createDefaultDebugCommandLine(config, environment, runner, sdk) : RubyAbstractCommandLineState.createDefaultRunCommandLine(config, environment, runner, sdk);
        data.putUserData(RubyCommandLineData.RUNNER_KEY, runner);
        RubyCommandLineData rubyCommandLineData = data;
        if (rubyCommandLineData == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(19);
        }
        return rubyCommandLineData;
    }

    protected static RubyCommandLineData createDefaultRunCommandLine(@NotNull AbstractRubyRunConfiguration<?> config, @NotNull Map<String, String> environment, @NotNull RubyRunner runner, @NotNull Sdk sdk) {
        if (config == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(20);
        }
        if (environment == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(21);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(22);
        }
        if (sdk == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(23);
        }
        String workingDir = RubyAbstractCommandLineState.getWorkingDir(config);
        Module module = config.getModule();
        SpringUtil.customizeSpring(module, environment);
        PathMappingSettings mappingSettings = runner.addDefaultMappings(config.getMappingSettings());
        String interpreterPath = RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(RubySdkAdditionalData.getInterpreterPathFor(sdk));
        RubyCommandLine commandLine = runner.createCommandLine((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(interpreterPath, config.getRubyArgs()).withWorkingDirPath(workingDir == null ? null : RubySdkUtil.convertToRemote(sdk, module, workingDir))).withAdditionalEnvs(environment)).withParentEnv(config.isPassParentEnvs())).withSdk(sdk)).withPathMappings(mappingSettings));
        RubyCommandLineData data = new RubyCommandLineData();
        data.setCommandLine(commandLine);
        return data;
    }

    @NotNull
    private static RubyCommandLineData createDefaultDebugCommandLine(@NotNull AbstractRubyRunConfiguration<?> config, @NotNull Map<String, String> environment, @NotNull RubyRunner runner, @NotNull Sdk sdk) throws ExecutionException {
        if (config == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(24);
        }
        if (environment == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(25);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(26);
        }
        if (sdk == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(27);
        }
        RubyCommandLineData rubyCommandLineData = ((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)new RubyDebugCommandLineDataBuilderBase(config, environment, runner, sdk, RubyDebugMode.NORMAL_MODE).setDebugConsoleAllowed(true)).setRubyDebugIdeExecutable()).setRdebugOptions()).setCommandDelimiter()).build();
        if (rubyCommandLineData == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(28);
        }
        return rubyCommandLineData;
    }

    @Nullable
    private static String getWorkingDir(@NotNull AbstractRubyRunConfiguration<?> config) {
        String workingDirectory;
        if (config == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(29);
        }
        if (!(workingDirectory = config.getWorkingDirectory()).trim().isEmpty()) {
            return workingDirectory.trim();
        }
        Module module = config.getModule();
        if (module != null) {
            return PathMacroUtil.getModuleDir((String)module.getModuleFilePath());
        }
        return config.getProject().getBasePath();
    }

    @NotNull
    public static DebugGemHelper selectDebugGemHelper(@NotNull Sdk sdk, @Nullable Module module, @NotNull RubyDebugMode mode) throws ExecutionException {
        if (sdk == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(30);
        }
        if (mode == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(31);
        }
        for (RubyDebugHelperFactory factory : (RubyDebugHelperFactory[])RubyDebugHelperFactory.EP_NAME.getExtensions()) {
            DebugGemHelper candidate = factory.getDebugGemHelper(module, sdk, mode);
            if (candidate == null) continue;
            DebugGemHelper debugGemHelper = candidate;
            if (debugGemHelper == null) {
                RubyAbstractCommandLineState.$$$reportNull$$$0(32);
            }
            return debugGemHelper;
        }
        throw new ExecutionException(RBundle.message((String)"dialog.message.debug.configuration.not.supported"));
    }

    private static void addDebuggerPorts(@NotNull RubyRunner runner, @NotNull List<? super String> args, @NotNull RubyCommandLineData data, boolean useMultiProcess) throws ExecutionException {
        if (runner == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(33);
        }
        if (args == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(34);
        }
        if (data == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(35);
        }
        Pair<PortForwarding, PortForwarding> pair = runner.getDebuggerForwardings();
        PortForwarding debuggerForwarding = (PortForwarding)pair.getFirst();
        PortForwarding dispatcherForwarding = (PortForwarding)pair.getSecond();
        data.putUserData(RubyCommandLineData.DEBUG_PORT_KEY, debuggerForwarding.getLocalPort());
        RunConfigurationUtil.addPortForwarding(data, debuggerForwarding);
        args.add(PORT);
        args.add(String.valueOf(debuggerForwarding.getRemotePort()));
        args.add(HOST);
        args.add(debuggerForwarding.getRemoteHostName());
        if (useMultiProcess) {
            data.putCopyableUserData(RubyCommandLineData.DISPATCHER_KEY, dispatcherForwarding.getLocalPort());
            args.add("--dispatcher-port");
            args.add(String.valueOf(dispatcherForwarding.getRemotePort()));
            RunConfigurationUtil.addPortForwarding(data, dispatcherForwarding);
            data.putCopyableUserData(RubyCommandLineData.DISPATCHER_HOST_KEY, dispatcherForwarding.getLocalHostName());
        }
    }

    public static void addParams(@NotNull ParamsGroup paramsGroup, @NotNull String argsString) {
        if (paramsGroup == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(36);
        }
        if (argsString == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(37);
        }
        paramsGroup.addParameters(MergingCommandLineArgumentsProvider.stringToArguments(argsString));
    }

    public static void addParams(@NotNull List<? super String> args, @NotNull String argsString) {
        if (args == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(38);
        }
        if (argsString == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(39);
        }
        Collections.addAll(args, MergingCommandLineArgumentsProvider.stringToArguments(argsString));
    }

    public static ParamsGroup addExecutionScriptGroup(@NotNull String scriptTypeId, @NotNull RubyCommandLineData data, @NotNull GeneralCommandLine commandLine, @NotNull String executionScriptPath, @NotNull Sdk sdk, @Nullable Module module) {
        if (scriptTypeId == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(40);
        }
        if (data == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(41);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(42);
        }
        if (executionScriptPath == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(43);
        }
        if (sdk == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(44);
        }
        ParamsGroup group = commandLine.getParametersList().addParamsGroup(scriptTypeId);
        String remoteScriptPath = RubySdkUtil.convertToRemote(sdk, module, executionScriptPath);
        group.addParameter(remoteScriptPath);
        RubySdkSystemAccessor systemAccessor = RubySdkSystemAccessor.from(sdk);
        data.putUserData(RubyCommandLineData.DEBUGED_SCRIPT_KEY, systemAccessor.toSystemDependentName(remoteScriptPath));
        return group;
    }

    public static boolean isInRubyDebugMode(@Nullable String runnerId) {
        ProgramRunner<?> programRunner = RubyAbstractCommandLineState.getRunner(runnerId);
        return programRunner instanceof RubyDebugRunner || programRunner instanceof RubyRemoteDebugRunner;
    }

    @Nullable
    protected static ProgramRunner<?> getRunner(@Nullable String runnerId) {
        return runnerId == null ? null : ProgramRunner.findRunnerById((String)runnerId);
    }

    public static boolean preLoaderAllowed(@Nullable String runnerId) {
        RubyProgramRunner rubyProgramRunner;
        ProgramRunner<?> programRunner = RubyAbstractCommandLineState.getRunner(runnerId);
        return !(programRunner instanceof RubyProgramRunner) || (rubyProgramRunner = (RubyProgramRunner)programRunner).preloaderAllowed();
    }

    @TestOnly
    public static void disableConfigurationValidation(@NotNull Disposable disposable) {
        if (disposable == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(45);
        }
        VALIDATE_CONFIGURATION.set(false);
        Disposer.register((Disposable)disposable, () -> VALIDATE_CONFIGURATION.set(true));
    }

    protected static void addConsoleFilters(@NotNull List<? super Filter> filters, @NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir) {
        if (filters == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(46);
        }
        if (project == null) {
            RubyAbstractCommandLineState.$$$reportNull$$$0(47);
        }
        for (RubyConsoleFilterProvider consoleFilterProvider : (RubyConsoleFilterProvider[])RubyConsoleFilterProvider.EP_NAME.getExtensions()) {
            Filter filter = consoleFilterProvider.createFilter(project, workingDir, sdk);
            if (filter == null) continue;
            filters.add((Filter)filter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 9, 11, 12, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 22: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptTypeId";
                break;
            }
            case 15: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionScriptPath";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 23: 
            case 27: 
            case 30: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsString";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultCommandLine";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultDebugCommandLine";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "selectDebugGemHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addExecutionScriptGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultCommandLine";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultRunCommandLine";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDebugCommandLine";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "selectDebugGemHelper";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addDebuggerPorts";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addParams";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "disableConfigurationValidation";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addConsoleFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 11, 12, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 -> new IllegalArgumentException(string);
        };
    }

    protected static class RubyDebugCommandLineDataBuilderBase<T extends RubyDebugCommandLineDataBuilderBase<T>> {
        @NotNull
        protected final List<String> myArgs;
        @NotNull
        protected final RubyCommandLineData myData;
        @NotNull
        protected final Sdk mySdk;
        @NotNull
        protected final DebugGemHelper myDebugGemHelper;
        @NotNull
        protected final AbstractRubyRunConfiguration<?> myConfig;
        @NotNull
        private final Map<String, String> myEnvironment;
        @NotNull
        private final RubyRunner myRunner;
        @NotNull
        private final RubyDebuggerSettings.RubyDebuggerSettingsState myState;
        @NotNull
        private final PathMappingSettings myMappingSettings;
        @NotNull
        private final RubySdkSystemAccessor myAccessor;
        @NotNull
        @NonNls
        private final String myExecPath;
        protected boolean myAskForSudo;
        private boolean wasExecutableSet;
        private boolean myAddBundleExec;

        public RubyDebugCommandLineDataBuilderBase(@NotNull AbstractRubyRunConfiguration<?> config, @NotNull Map<String, String> environment, @NotNull RubyRunner runner, @NotNull Sdk sdk, @NotNull RubyDebugMode mode) throws ExecutionException {
            if (config == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(1);
            }
            if (runner == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(2);
            }
            if (sdk == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(3);
            }
            if (mode == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(4);
            }
            this.myAskForSudo = false;
            this.wasExecutableSet = false;
            this.myAddBundleExec = true;
            this.myConfig = config;
            this.myEnvironment = environment;
            this.myRunner = runner;
            this.mySdk = sdk;
            this.myData = new RubyCommandLineData();
            this.myArgs = new ArrayList<String>();
            this.myDebugGemHelper = RubyAbstractCommandLineState.selectDebugGemHelper(this.mySdk, this.myConfig.getModule(), mode);
            this.myState = RubyDebuggerSettings.getInstance().getState();
            this.myExecPath = RubyVersionManagerHandler.notNullFrom(this.mySdk).getAdjustedGemScriptPathForExecution(RubySdkAdditionalData.getInterpreterPathFor(this.mySdk));
            if (!this.myDebugGemHelper.isUsable()) {
                throw new ExecutionException(RBundle.message((String)"ruby.debugger.cannot.start.debug", (Object[])new Object[]{this.myDebugGemHelper.getErrorMsg()}));
            }
            this.myData.putUserData(RubyCommandLineData.DEBUG_GEM_HELPER_KEY, this.myDebugGemHelper);
            if (JRubySdkUtil.isJRubySDK(sdk)) {
                RubyDebugCommandLineDataBuilderBase.adjustForJRuby(this.myArgs);
            }
            this.myMappingSettings = runner.addDefaultMappings(config.getMappingSettings());
            this.myAccessor = RubySdkAdditionalData.notNullFrom(sdk).getSdkSystemAccessor();
            this.myDebugGemHelper.configureEnvironment(this.myEnvironment, this.myAccessor, this.myMappingSettings);
        }

        private static void adjustForJRuby(@NotNull List<? super String> args) {
            if (args == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(5);
            }
            args.add("-X+O");
            args.add("-J-Djruby.compile.mode=OFF");
            args.add("-J-Djruby.debug.fullTrace=true");
        }

        @NotNull
        public T setDebugConsoleAllowed(boolean isAllowed) {
            this.myData.putUserData(RubyCommandLineData.DEBUG_CONSOLE_ALLOWED_KEY, isAllowed);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(6);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setAskForSudo(boolean askForSudo) {
            this.myAskForSudo = askForSudo;
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(7);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setAddBundleExec(boolean addBundleExec) {
            this.myAddBundleExec = addBundleExec;
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(8);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public ParametersList getRubyArgsFromConfig() {
            ParametersList rubyArgs = this.myConfig.getRubyArgs().clone();
            if (!this.myAccessor.isWindows()) {
                for (int i = 0; i < rubyArgs.getParametersCount() - 1; ++i) {
                    if (!rubyArgs.get(i).equals("-e")) continue;
                    rubyArgs.set(i + 1, "at_exit{sleep(1)};" + rubyArgs.get(i + 1));
                }
            }
            ParametersList parametersList = rubyArgs;
            if (parametersList == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(9);
            }
            return parametersList;
        }

        @NotNull
        public T setRubyDebugIdeExecutable() {
            this.myArgs.add(this.myMappingSettings.convertToRemote(this.myDebugGemHelper.getRdebugScriptPath()));
            this.wasExecutableSet = true;
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(10);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setRdebugOptions() throws ExecutionException {
            this.myDebugGemHelper.enableVerboseMode(this.myArgs, this.myState.isVerboseOutput());
            if (ApplicationManager.getApplication().isUnitTestMode() && RubyDebugIdeGemHelper.BackendDebugGemType.getBaseType(this.mySdk, false) == RubyDebugIdeGemHelper.BackendDebugGemType.DEBASE_JB) {
                this.myArgs.add("--verbose_tests");
            }
            this.myDebugGemHelper.enableKeyValuePresentation(this.myArgs, this.myState.isKeyValueHashPresentation());
            this.myDebugGemHelper.enableSteppingOverIntoBlocks(this.myArgs, this.myState.shouldStepOverGoIntoBlocks());
            this.myDebugGemHelper.disableIntHandler(this.myArgs, RubyVMOptions.isDisableDebuggerIntHandler());
            this.myDebugGemHelper.setEvaluationTimeout(this.myArgs, this.myState.getTimeout());
            this.myDebugGemHelper.enableEvaluationControl(this.myArgs, this.myState.isEvaluationControl());
            if (this.myState.isEvaluationControl()) {
                this.myDebugGemHelper.setEvaluationTimeLimit(this.myArgs, this.myState.getTimeLimit());
                this.myDebugGemHelper.setEvaluationMemoryLimit(this.myArgs, this.myState.getMemoryLimit());
            }
            if (RubyDebugIdeGemHelper.isDebase23Enabled(this.mySdk) || RubyDebugIdeGemHelper.isDebase30Enabled(this.mySdk)) {
                this.myDebugGemHelper.setFullValueEvaluationTimeLimit(this.myArgs, Registry.intValue((String)"ruby.debugger.fullValue.timelimit"));
                this.myDebugGemHelper.setFulValueEvaluationMemoryLimit(this.myArgs, Registry.intValue((String)"ruby.debugger.fullValue.memorylimit"));
            }
            this.myDebugGemHelper.addGemSpecificArgs(this.myArgs);
            RubyAbstractCommandLineState.addDebuggerPorts(this.myRunner, this.myArgs, this.myData, this.myState.isMultiprocess() && this.myDebugGemHelper.isMultiProcessDebugSupported());
            if (this.myState.isMultiprocess()) {
                this.myRunner.configureExtraPortsForMultiProcess(this.myData, this.myEnvironment);
            }
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(11);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setCommandDelimiter() {
            this.myArgs.add(RubyAbstractCommandLineState.RDEBUG_COMMAND_DELIMITER);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(12);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T putRunner() {
            this.myData.putUserData(RubyCommandLineData.RUNNER_KEY, this.myRunner);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(13);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        protected SourcePositionConverter getDefaultSourcePositionConverter() {
            return RubyRemoteInterpreterManager.isRemoteSdk(this.mySdk) ? new RemotePositionConverter(this.myConfig.getProject(), this.myMappingSettings) : new LocalPositionConverter(this.myConfig.getProject(), !RubySdkUtil.isRuby18(this.mySdk));
        }

        @NotNull
        private ParametersList getArguments() {
            ParametersList arguments = this.getRubyArgsFromConfig();
            arguments.addParamsGroup(RubyAbstractCommandLineState.DEBUGGER_PARAMS_GROUP_ID).addParameters(this.myArgs);
            ParametersList parametersList = arguments;
            if (parametersList == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(14);
            }
            return parametersList;
        }

        @NotNull
        public RubyCommandLineData build() {
            if (!this.wasExecutableSet) {
                throw new IllegalStateException("You should set ruby-debug-ide executable");
            }
            ApplicationManager.getApplication().invokeAndWait(() -> SpringUtil.configureSpringForDebug(this.myEnvironment, this.myConfig.getModule()));
            this.myData.setCommandLine(this.myRunner.createCommandLine((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(this.myExecPath, this.getArguments()).withWorkingDirPath(RubyAbstractCommandLineState.getWorkingDir(this.myConfig))).withAdditionalEnvs(this.myEnvironment)).withParentEnv(this.myConfig.isPassParentEnvs())).withSdk(this.mySdk)).withPathMappings(this.myConfig.getMappingSettings())).withAskForSudo(this.myAskForSudo)).withAddBundleExec(this.myAddBundleExec)));
            this.myData.putUserData(RubyCommandLineData.SOURCE_POSITION_CONVERTER_KEY, this.getDefaultSourcePositionConverter());
            RubyCommandLineData rubyCommandLineData = this.myData;
            if (rubyCommandLineData == null) {
                RubyDebugCommandLineDataBuilderBase.$$$reportNull$$$0(15);
            }
            return rubyCommandLineData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState$RubyDebugCommandLineDataBuilderBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState$RubyDebugCommandLineDataBuilderBase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDebugConsoleAllowed";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAskForSudo";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAddBundleExec";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubyArgsFromConfig";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebugIdeExecutable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRdebugOptions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommandDelimiter";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putRunner";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustForJRuby";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

