/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RGemRunnerBasedParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;

public class GemRunnerBasedParamsEditor
implements RGemRunnerBasedParams,
PanelWithAnchor {
    @NlsSafe
    public static final String DEFAULT_GEM_VERSION = "[default]";
    private LabeledComponent<JComboBox> myRunnerGemVersionComponent;
    private JComboBox myRunnerGemVersionCB;
    private JComponent myAnchor;
    private JPanel myContentPane;
    private final List<String> myGemNameList;
    @Nullable
    private final Map<String, Filter> myGems2FilterTable;
    private final String myGemName;

    public GemRunnerBasedParamsEditor(@NotNull List<String> gemNameList, @Nullable Map<String, Filter> gems2FilterTable, final RubyCommonRunParamsEditor commonEditor) {
        if (gemNameList == null) {
            GemRunnerBasedParamsEditor.$$$reportNull$$$0(0);
        }
        this.myGemNameList = gemNameList;
        this.myGems2FilterTable = gems2FilterTable;
        this.$$$setupUI$$$();
        commonEditor.addSDKChangedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GemRunnerBasedParamsEditor.this.refreshRunnerGemVersionCBModel(commonEditor.getSdk(), null, commonEditor.getModule());
            }
        });
        this.myGemName = !gemNameList.isEmpty() ? gemNameList.get(0) : "";
        this.myRunnerGemVersionComponent.setText(RBundle.message((String)"run.configuration.messages.runner.version", (Object[])new Object[]{this.myGemName}));
    }

    public JPanel getMainPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myRunnerGemVersionCB = new ComboBox(50);
        this.myRunnerGemVersionComponent = new LabeledComponent();
        this.myRunnerGemVersionComponent.setComponent((JComponent)this.myRunnerGemVersionCB);
    }

    @Override
    public String getRunnerGemVersion() {
        if (!(this.myRunnerGemVersionCB.getModel() instanceof CollectionComboBoxModel)) {
            return "";
        }
        String versionString = this.myRunnerGemVersionCB.getSelectedItem().toString();
        return DEFAULT_GEM_VERSION.equals(versionString) ? "" : versionString;
    }

    @Override
    public void setRunnerGemVersion(@Nullable @NlsSafe String versionRequirement) {
        String itemToSelect = StringUtil.isEmpty((String)versionRequirement) ? DEFAULT_GEM_VERSION : versionRequirement;
        this.myRunnerGemVersionCB.setSelectedItem(itemToSelect);
    }

    public void resetEditorFrom(RGemRunnerBasedParams config, @Nullable Sdk sdk, @Nullable Module module) {
        this.refreshRunnerGemVersionCBModel(sdk, config.getRunnerGemVersion(), module);
    }

    private void refreshRunnerGemVersionCBModel(@Nullable Sdk sdk, @Nullable @NlsSafe String preselectedVersion, @Nullable Module module) {
        GemManager gemManager = GemManager.getInstance();
        ArrayList<GemInfo> gems = new ArrayList<GemInfo>();
        for (String gemName : this.myGemNameList) {
            HashSet<GemInfo> gemsForName = new HashSet<GemInfo>(gemManager.getAllGems(sdk, gemName));
            if (module != null) {
                for (GemInfo gemInfo : RubyProjectGemSearchService.Companion.getAllGems(module)) {
                    if (!gemName.equals(gemInfo.getName())) continue;
                    gemsForName.add(gemInfo);
                }
            }
            for (GemInfo gemInfo : gemsForName) {
                Filter filter;
                if (this.myGems2FilterTable != null && (filter = this.myGems2FilterTable.get(gemName)) != null && !filter.accept(gemInfo)) continue;
                gems.add(gemInfo);
            }
        }
        Object model = !gems.isEmpty() ? GemUiUtil.buildGemVersionsModel(gems, DEFAULT_GEM_VERSION) : new DefaultComboBoxModel<String>(new String[]{RBundle.message((String)"run.configuration.messages.runner.version.no.gems", (Object[])new Object[]{this.myGemName})});
        this.myRunnerGemVersionCB.setModel(model);
        if (preselectedVersion != null) {
            this.myRunnerGemVersionCB.setSelectedItem(preselectedVersion);
        }
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myRunnerGemVersionComponent.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemNameList", "org/jetbrains/plugins/ruby/ruby/run/configuration/GemRunnerBasedParamsEditor", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<JComboBox> labeledComponent = this.myRunnerGemVersionComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", GemRunnerBasedParamsEditor.class).getString("run.configuration.messages.runner.version"));
        labeledComponent.setToolTipText("");
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static abstract class Filter {
        public abstract boolean accept(@NotNull GemInfo var1);
    }
}

