/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.statistics.FusCollectSettingChangesRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ExtendableSettingsEditor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;

public abstract class AbstractRubyRunConfiguration<T extends RunConfiguration>
extends AbstractRunConfiguration
implements AbstractRubyRunConfigurationParams,
RefactoringListenerProvider,
FusCollectSettingChangesRunConfiguration {
    private static final Logger LOG = Logger.getInstance(AbstractRubyRunConfiguration.class);
    protected boolean logRegistered = false;
    @NotNull
    private String myWorkingDirectory = "";
    @NotNull
    private ParametersList myRubyArgs = new ParametersList();
    private String mySdkName = "";
    @NotNull
    private PathMappingSettings myPathMappingSettings = new PathMappingSettings();
    private boolean myShouldUseAlternativeSdk;
    private String myLogId = null;

    protected AbstractRubyRunConfiguration(String name, RunConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(name, configurationModule, factory);
    }

    protected AbstractRubyRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    protected abstract String getSerializationId();

    protected abstract SettingsEditor<T> createConfigurationEditor();

    protected abstract void validateConfiguration() throws RuntimeConfigurationException;

    protected abstract RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment var1) throws ExecutionException;

    @NotNull
    public final SettingsEditor<T> getConfigurationEditor() {
        SettingsEditor<T> runConfigurationEditor = this.createConfigurationEditor();
        SettingsEditorGroup group = new SettingsEditorGroup();
        String mainEditorTitle = ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]);
        ExtendableSettingsEditor extendableSettingsEditor = new ExtendableSettingsEditor(runConfigurationEditor);
        group.addEditor(mainEditorTitle, (SettingsEditor)extendableSettingsEditor);
        RubyRunConfigurationExtensionsManager.getInstance().appendEditors((RunConfigurationBase)this, group, extendableSettingsEditor);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    @NotNull
    public List<Module> getValidModules() {
        List<Module> list = Arrays.asList(RModuleUtil.getInstance().getAllModulesWithRubySupport(this.getProject()));
        if (list == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public Module getModule() {
        Module module = this.getConfigurationModule().getModule();
        if (module != null || !PlatformUtils.isRubyMine() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return module;
        }
        return RModuleUtil.getInstance().getModuleWithRubySupport(this.getProject());
    }

    @NotNull
    public ParametersList getRubyArgs() {
        ParametersList parametersList = this.myRubyArgs;
        if (parametersList == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(2);
        }
        return parametersList;
    }

    public void setRubyArgs(@NotNull String rubyArgs) {
        if (rubyArgs == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(3);
        }
        this.myRubyArgs = new ParametersList();
        this.myRubyArgs.addParametersString(rubyArgs);
    }

    public void addRubyArgs(String ... rubyArgs) {
        if (rubyArgs == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(4);
        }
        this.myRubyArgs.addAll(rubyArgs);
    }

    @Nullable
    public Sdk getSdk() {
        if (this.shouldUseAlternativeSdk()) {
            return this.getAlternativeSdk();
        }
        return this.getModuleSdk();
    }

    @Nullable
    public Sdk getModuleSdk() {
        return (Sdk)ReadAction.compute(() -> RubySdkUtil.findRubySdk(this.getModule()));
    }

    @Override
    @NotNull
    public PathMappingSettings getMappingSettings() {
        PathMappingSettings pathMappingSettings = this.myPathMappingSettings;
        if (pathMappingSettings == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myPathMappingSettings = mappingSettings != null ? mappingSettings : new PathMappingSettings();
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void setWorkingDirectory(@Nullable String dir) {
        this.myWorkingDirectory = AbstractRubyRunConfiguration.asSysIndependentPath(dir);
    }

    public String getAlternativeSdkName() {
        return this.mySdkName;
    }

    public void setAlternativeSdkName(@Nullable String sdkName) {
        this.mySdkName = StringUtil.notNullize((String)sdkName);
    }

    @Override
    @Nullable
    public Sdk getAlternativeSdk() {
        if (this.mySdkName == null) {
            return null;
        }
        Sdk sdk = ProjectJdkTable.getInstance().findJdk(this.mySdkName);
        return RubySdkUtil.isSDKValid(sdk) ? sdk : null;
    }

    @Override
    public void setAlternativeSdk(@Nullable Sdk sdk) {
        this.setAlternativeSdkName(sdk != null ? sdk.getName() : null);
    }

    public final RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(7);
        }
        if (env == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(8);
        }
        return this.createCommandLineState(env);
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        try {
            RubyRunConfigurationExtensionsManager.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeConfigurationException(e.getMessage(), (Throwable)e);
        }
        this.validateConfiguration();
    }

    public boolean shouldUseAlternativeSdk() {
        return this.myShouldUseAlternativeSdk;
    }

    public void setShouldUseAlternativeSdk(boolean shouldUseAlternativeSdk) {
        this.myShouldUseAlternativeSdk = shouldUseAlternativeSdk;
    }

    public AbstractRubyRunConfiguration clone() {
        Element element = new Element("toClone");
        try {
            this.writeExternal(element);
            AbstractRubyRunConfiguration configuration = (AbstractRubyRunConfiguration)this.createInstance();
            configuration.readExternal(element);
            return configuration;
        }
        catch (InvalidDataException | WriteExternalException e) {
            LOG.error(e);
            return null;
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(9);
        }
        super.readExternal(element);
        AbstractRubyRunConfigurationExternalizer.readExternal(this, element, this.getSerializationId());
        if (this.logRegistered && this.getPredefinedLogFiles().isEmpty() && this.getLogFiles().isEmpty()) {
            this.addPredefinedLogFile(new PredefinedLogFile(this.myLogId, true));
        }
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element));
        RubyRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(10);
        }
        super.writeExternal(element);
        AbstractRubyRunConfigurationExternalizer.writeExternal(this, element, this.getSerializationId());
        RubyRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        PathMappingSettings.writeExternal((Element)element, (PathMappingSettings)this.getMappingSettings());
    }

    protected void registerLog(String logId) {
        this.logRegistered = true;
        this.myLogId = logId;
        this.addPredefinedLogFile(new PredefinedLogFile(this.myLogId, true));
    }

    @Nullable
    protected LogFileOptions getOptionsForPredefinedLogFile() {
        if (this.logRegistered) {
            throw new UnsupportedOperationException("Log is registered but method is not implemented!");
        }
        return null;
    }

    public final LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        if (this.logRegistered && this.myLogId != null && this.myLogId.equals(predefinedLogFile.getId())) {
            return this.getOptionsForPredefinedLogFile();
        }
        return super.getOptionsForPredefinedLogFile(predefinedLogFile);
    }

    public final void customizeLogConsole(LogConsole console) {
        if (this.logRegistered) {
            LogFilterModel model = console.getFilterModel();
            assert (model instanceof DefaultLogFilterModel);
            ((DefaultLogFilterModel)model).setCheckStandartFilters(false);
        }
    }

    public boolean isExcludeCompileBeforeLaunchOption() {
        Module module = this.getModule();
        return module == null || RModuleUtil.getInstance().isRubyModule(module);
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        VirtualFile fileOrDir = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileOrDir == null) {
            return null;
        }
        List<MyRefValue<String>> pathsToUpdate = this.getPathsToUpdate();
        String fileOrDirPath = new File(fileOrDir.getPath()).getAbsolutePath();
        ArrayList<RefactoringElementListener> listeners = new ArrayList<RefactoringElementListener>();
        this.handleRunConfigurationNameRename(fileOrDir, listeners);
        for (MyRefValue<String> pathRef : pathsToUpdate) {
            String pathToUpdate = pathRef.getValue();
            if (StringUtil.isEmpty((String)pathToUpdate)) continue;
            RefactoringElementAdapter renameListener = null;
            File pathToUpdateFile = new File(pathToUpdate);
            String pathToUpdateAbsolutePath = pathToUpdateFile.getAbsolutePath();
            if (fileOrDir.isDirectory()) {
                String suffix;
                if (pathToUpdateAbsolutePath.contains(fileOrDirPath) && (StringUtil.isEmpty((String)(suffix = pathToUpdateAbsolutePath.substring(fileOrDirPath.length()))) || FileUtil.toSystemIndependentName((String)suffix).startsWith("/"))) {
                    renameListener = AbstractRubyRunConfiguration.createRenameListener(pathRef, suffix);
                }
            } else if (Objects.equals(fileOrDirPath, pathToUpdateAbsolutePath)) {
                renameListener = AbstractRubyRunConfiguration.createRenameListener(pathRef, null);
            }
            if (renameListener == null) continue;
            listeners.add((RefactoringElementListener)renameListener);
        }
        if (listeners.isEmpty()) {
            return null;
        }
        if (listeners.size() == 1) {
            return (RefactoringElementListener)listeners.get(0);
        }
        RefactoringElementListenerComposite compositeListener = new RefactoringElementListenerComposite();
        for (RefactoringElementListener listener : listeners) {
            compositeListener.addListener(listener);
        }
        return compositeListener;
    }

    public void collectSettingChangesOnApply(@NotNull FusCollectSettingChangesRunConfiguration oldRunConfiguration) {
        if (oldRunConfiguration == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(11);
        }
        if (this.getClass() == oldRunConfiguration.getClass()) {
            boolean newShouldUseAlternativeSdkValue;
            AbstractRubyRunConfiguration oldAbstractRubyRunConfiguration = (AbstractRubyRunConfiguration)oldRunConfiguration;
            boolean oldShouldUseAlternativeSdkValue = oldAbstractRubyRunConfiguration.shouldUseAlternativeSdk();
            if (oldShouldUseAlternativeSdkValue != (newShouldUseAlternativeSdkValue = this.shouldUseAlternativeSdk())) {
                RubyRunConfigurationSettingChangesCollector.logRubySdkSourceTypeChange(this.getType(), oldShouldUseAlternativeSdkValue, newShouldUseAlternativeSdkValue);
            }
            RubyRunConfigurationExtensionsManager.getInstance().logExtensionsSettingChanges(oldAbstractRubyRunConfiguration, this);
        }
    }

    private void handleRunConfigurationNameRename(VirtualFile fileOrDir, List<RefactoringElementListener> listeners) {
        String oldFileOrDirName;
        final String runConfName = this.getName();
        if (runConfName.equals(oldFileOrDirName = fileOrDir.getNameWithoutExtension())) {
            listeners.add((RefactoringElementListener)new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    VirtualFile virtualFile;
                    if (newElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((virtualFile = ((PsiFileSystemItem)newElement).getVirtualFile()) == null) {
                        return;
                    }
                    String newFileOrDirName = virtualFile.getNameWithoutExtension();
                    AbstractRubyRunConfiguration.this.setName(AbstractRubyRunConfiguration.this.getName().replace(oldFileOrDirName, newFileOrDirName));
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    VirtualFile virtualFile;
                    if (newElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((virtualFile = ((PsiFileSystemItem)newElement).getVirtualFile()) == null) {
                        return;
                    }
                    AbstractRubyRunConfiguration.this.setName(runConfName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/AbstractRubyRunConfiguration$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    protected List<MyRefValue<String>> getPathsToUpdate() {
        ArrayList<MyRefValue<String>> pathsToUpdate = new ArrayList<MyRefValue<String>>();
        pathsToUpdate.add(new MyRefValue<String>(){

            @Override
            public String getValue() {
                return AbstractRubyRunConfiguration.this.myWorkingDirectory;
            }

            @Override
            public void setValue(String newValue) {
                AbstractRubyRunConfiguration.this.myWorkingDirectory = newValue;
            }
        });
        return pathsToUpdate;
    }

    public boolean isBundlerContextAllowed() {
        return true;
    }

    public boolean isModuleDirMacroSupported() {
        return PlatformUtils.isRubyMine();
    }

    private static RefactoringElementAdapter createRenameListener(final @NotNull MyRefValue<String> pathRef, final @Nullable String pathSuffix) {
        if (pathRef == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(12);
        }
        return new RefactoringElementAdapter(){

            public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                VirtualFile virtualFile;
                if (newElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((virtualFile = ((PsiFileSystemItem)newElement).getVirtualFile()) == null) {
                    return;
                }
                String newFileOrDirName = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                pathRef.setValue(StringUtil.isEmpty((String)pathSuffix) ? newFileOrDirName : newFileOrDirName + pathSuffix);
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (oldQualifiedName == null) {
                    3.$$$reportNull$$$0(2);
                }
                pathRef.setValue(StringUtil.isEmpty((String)pathSuffix) ? oldQualifiedName : oldQualifiedName + pathSuffix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldQualifiedName";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/AbstractRubyRunConfiguration$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementRenamedOrMoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "undoElementMovedOrRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static String asSysIndependentPath(@Nullable String dir) {
        if (StringUtil.isEmpty((String)dir)) {
            return "";
        }
        return FileUtil.toSystemIndependentName((String)dir);
    }

    public static boolean isScratchRunConfiguration(@NotNull AbstractRubyRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            AbstractRubyRunConfiguration.$$$reportNull$$$0(13);
        }
        if (!(runConfiguration instanceof RubyRunConfiguration)) {
            return false;
        }
        String scriptPath = ((RubyRunConfiguration)runConfiguration).getScriptPath();
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(scriptPath);
        return ScratchUtil.isScratch((VirtualFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/AbstractRubyRunConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyArgs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyArgs";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/AbstractRubyRunConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRubyArgs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRubyArgs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectSettingChangesOnApply";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRenameListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isScratchRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    protected static interface MyRefValue<T> {
        @Nullable
        public T getValue();

        public void setValue(@Nullable T var1);
    }
}

