/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.content.Content;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class RunContentDescriptorFactory {
    public static final RunContentDescriptorFactory DEFAULT = new DefaultFactory();

    public abstract RunContentDescriptor createDesc(ConsoleView var1, ProcessHandler var2, JComponent var3, @NlsContexts.TabTitle String var4, AtomicBoolean var5);

    private static class DefaultFactory
    extends RunContentDescriptorFactory {
        private DefaultFactory() {
        }

        @Override
        public RunContentDescriptor createDesc(ConsoleView consoleView, ProcessHandler processHandler, JComponent consolePanel, @NlsContexts.TabTitle String consoleTitle, final AtomicBoolean reuseProhibited) {
            return new RunContentDescriptor(this, (ExecutionConsole)consoleView, processHandler, consolePanel, consoleTitle){

                public boolean isContentReuseProhibited() {
                    return reuseProhibited.get();
                }
            };
        }
    }

    public static class PinTabsFactory
    extends RunContentDescriptorFactory {
        final List<Content> myContentList = new ArrayList<Content>();

        @Override
        public RunContentDescriptor createDesc(ConsoleView consoleView, ProcessHandler processHandler, JComponent consolePanel, String consoleTitle, AtomicBoolean reuseProhibited) {
            return new MyDescriptor((ExecutionConsole)consoleView, processHandler, consolePanel, consoleTitle, reuseProhibited);
        }

        public void unpinAll() {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                for (Content content : this.myContentList) {
                    content.setPinned(false);
                }
            }, ModalityState.defaultModalityState());
        }

        private class MyDescriptor
        extends RunContentDescriptor {
            private final AtomicBoolean myIsReuseProhibited;

            MyDescriptor(ExecutionConsole executionConsole, ProcessHandler processHandler, @NlsContexts.TabTitle JComponent component, String displayName, AtomicBoolean reuseProhibited) {
                super(executionConsole, processHandler, component, displayName);
                this.myIsReuseProhibited = reuseProhibited;
            }

            public boolean isContentReuseProhibited() {
                return this.myIsReuseProhibited.get();
            }

            public void setAttachedContent(@NotNull Content content) {
                if (content == null) {
                    MyDescriptor.$$$reportNull$$$0(0);
                }
                super.setAttachedContent(content);
                content.setPinned(true);
                PinTabsFactory.this.myContentList.add(content);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/ruby/ruby/run/RunContentDescriptorFactory$PinTabsFactory$MyDescriptor", "setAttachedContent"));
            }
        }
    }
}

