/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.io.BaseOutputReader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandlerEx;

public class RubyProcessHandler
extends KillableColoredProcessHandler
implements RubyProcessHandlerEx {
    private static final Logger LOG = Logger.getInstance(RubyProcessHandler.class);
    private final boolean myAllowKillProcess;
    private final boolean myIsDebug;
    private final boolean myWithBlockingRead;

    protected RubyProcessHandler(@NotNull Process process, @NotNull String commandLine, @NotNull Charset charset, @Nullable String runnerId, boolean withBlockingRead) {
        if (process == null) {
            RubyProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            RubyProcessHandler.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            RubyProcessHandler.$$$reportNull$$$0(2);
        }
        super(process, commandLine, charset);
        this.myAllowKillProcess = RubyVMOptions.isDisableDebuggerIntHandler() || !"RubyDebugRunner".equals(runnerId);
        this.myIsDebug = "RubyDebugRunner".equals(runnerId);
        this.myWithBlockingRead = withBlockingRead;
    }

    @NotNull
    public static RubyProcessHandler createProcessHandler(@NotNull Process process, @NotNull RubyCommandLine commandLine, @Nullable String runnerId) {
        if (process == null) {
            RubyProcessHandler.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            RubyProcessHandler.$$$reportNull$$$0(4);
        }
        return new RubyProcessHandler(process, commandLine.getCommandLineString(), RubyProcessHandler.getOutputEncoding(), runnerId, commandLine.isWithBlockingRead());
    }

    public boolean shouldKillProcessSoftly() {
        return this.myAllowKillProcess;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return true;
    }

    protected boolean destroyProcessGracefully() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Destroying process: " + String.valueOf(this), new Throwable());
        }
        if (SystemInfo.isUnix && this.myIsDebug) {
            return super.destroyProcessGracefully() && super.destroyProcessGracefully();
        }
        return super.destroyProcessGracefully();
    }

    @NotNull
    public static Charset getOutputEncoding() {
        Charset encoding = EncodingManager.getInstance().getDefaultCharset();
        String customEncodingName = RubyVMOptions.getConsoleCustomEncodingProperty();
        if (customEncodingName != null) {
            Charset customEncoding = CharsetToolkit.forName((String)customEncodingName);
            if (customEncoding != null) {
                encoding = customEncoding;
            } else {
                LOG.error("Java charset wasn't found for encoding: " + customEncodingName + ". IDE default encoding will be used.");
            }
        }
        Charset charset = encoding;
        if (charset == null) {
            RubyProcessHandler.$$$reportNull$$$0(5);
        }
        return charset;
    }

    @Override
    public void addTunnel(@NotNull PortForwarding portForwarding) {
        if (portForwarding == null) {
            RubyProcessHandler.$$$reportNull$$$0(6);
        }
    }

    @Override
    public int addTunnelForRemoteServer(int port) {
        return port;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = this.myWithBlockingRead ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
        if (options == null) {
            RubyProcessHandler.$$$reportNull$$$0(7);
        }
        return options;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyProcessHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portForwarding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputEncoding";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTunnel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

