/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathMappingSettings;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.console.RubyConsoleProcessHandler;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.run.BundlerMissingGemsProcessAdapter;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandler;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public class RubyLocalRunner
extends RubyAbstractRunner {
    private static final String ENFORCE_SHELL_PROPERTY_KEY = "rubymine.enforce.test.shell";
    private static final RubyLocalRunner ourInstance = new RubyLocalRunner(null);

    protected RubyLocalRunner(@Nullable Module module) {
        this(module, LocalRubySdkSystemAccessor.getInstance());
    }

    public RubyLocalRunner(@Nullable Module module, @NotNull RubySdkSystemAccessor systemAccessor) {
        if (systemAccessor == null) {
            RubyLocalRunner.$$$reportNull$$$0(0);
        }
        super(module, systemAccessor);
    }

    @Override
    @NotNull
    protected ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyLocalRunner.$$$reportNull$$$0(1);
        }
        RubyProcessHandler rubyProcessHandler = RubyProcessHandler.createProcessHandler(commandLine.createProcess(), commandLine, runnerId);
        if (rubyProcessHandler == null) {
            RubyLocalRunner.$$$reportNull$$$0(2);
        }
        return rubyProcessHandler;
    }

    @Override
    @NotNull
    protected ProcessHandler processProcessHandler(@NotNull ProcessHandler processHandler, @Nullable String executionID) {
        if (processHandler == null) {
            RubyLocalRunner.$$$reportNull$$$0(3);
        }
        if (this.myModule != null) {
            BundlerMissingGemsProcessAdapter.Companion.attach(processHandler, this.myModule, executionID);
        }
        ProcessHandler processHandler2 = super.processProcessHandler(processHandler, executionID);
        if (processHandler2 == null) {
            RubyLocalRunner.$$$reportNull$$$0(4);
        }
        return processHandler2;
    }

    @Override
    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext context) {
        if (context == null) {
            RubyLocalRunner.$$$reportNull$$$0(5);
        }
        RubyCommandLine commandLine = super.createCommandLine(context);
        SpringUtil.customizeSpring(this.myModule, commandLine.getEnvironment());
        if (SystemInfo.isMac) {
            this.addHomeBrewToPath(commandLine);
        }
        RubyCommandLine rubyCommandLine = commandLine;
        if (rubyCommandLine == null) {
            RubyLocalRunner.$$$reportNull$$$0(6);
        }
        return rubyCommandLine;
    }

    protected void addHomeBrewToPath(@NotNull RubyCommandLine commandLine) {
        if (commandLine == null) {
            RubyLocalRunner.$$$reportNull$$$0(7);
        }
        String PATH_KEY = OSUtil.getPathEnvVariableName();
        String path = (String)commandLine.getEnvironment().get(PATH_KEY);
        commandLine.getEnvironment().put(PATH_KEY, OSUtil.appendToPATHenvVariable(path, "/usr/local/bin"));
    }

    @Override
    @NotNull
    public Map<String, String> getParentEnv() {
        Map map = EnvironmentUtil.getEnvironmentMap();
        if (map == null) {
            RubyLocalRunner.$$$reportNull$$$0(8);
        }
        return map;
    }

    @Override
    protected void passParentEnv(boolean passParentEnvs, @NotNull GeneralCommandLine cmdLine) {
        if (cmdLine == null) {
            RubyLocalRunner.$$$reportNull$$$0(9);
        }
        cmdLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE);
        if (passParentEnvs) {
            cmdLine.getEnvironment().putAll(this.getParentEnv());
        }
    }

    @Override
    @NotNull
    public String toSystemDependentName(@NotNull String path, @NotNull PathMappingSettings pathMappings) {
        if (path == null) {
            RubyLocalRunner.$$$reportNull$$$0(10);
        }
        if (pathMappings == null) {
            RubyLocalRunner.$$$reportNull$$$0(11);
        }
        String string = FileUtil.toSystemDependentName((String)path);
        if (string == null) {
            RubyLocalRunner.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public PathMappingSettings addDefaultMappings(@Nullable PathMappingSettings pathMappings) {
        return new PathMappingSettings();
    }

    @Override
    protected int @NotNull [] findAvailableRemotePorts(int @NotNull [] localPorts) {
        if (localPorts == null) {
            RubyLocalRunner.$$$reportNull$$$0(13);
        }
        if (localPorts == null) {
            RubyLocalRunner.$$$reportNull$$$0(14);
        }
        return localPorts;
    }

    @Override
    @NotNull
    protected ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyLocalRunner.$$$reportNull$$$0(15);
        }
        return new RubyConsoleProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.isWithBlockingRead());
    }

    @NotNull
    public static RubyLocalRunner getRunner(@Nullable Module module) {
        return module == null ? ourInstance : new RubyLocalRunner(module);
    }

    @Override
    @NotNull
    protected String getLinuxShellCommand() {
        String enforcedShell = System.getProperty(ENFORCE_SHELL_PROPERTY_KEY);
        String string = enforcedShell != null ? enforcedShell : Objects.requireNonNullElse(System.getenv("SHELL"), "bash");
        if (string == null) {
            RubyLocalRunner.$$$reportNull$$$0(16);
        }
        return string;
    }

    @TestOnly
    public static <T> T computeWithEnforcedShell(@NotNull String shell, @NotNull Supplier<T> supplier) {
        if (shell == null) {
            RubyLocalRunner.$$$reportNull$$$0(17);
        }
        if (supplier == null) {
            RubyLocalRunner.$$$reportNull$$$0(18);
        }
        System.setProperty(ENFORCE_SHELL_PROPERTY_KEY, shell);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            System.clearProperty(ENFORCE_SHELL_PROPERTY_KEY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemAccessor";
                break;
            }
            case 1: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyLocalRunner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPorts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shell";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyLocalRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandlerInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processProcessHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnv";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableRemotePorts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinuxShellCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandlerInner";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addHomeBrewToPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "passParentEnv";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAvailableRemotePorts";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandlerInner";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeWithEnforcedShell";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

