/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class RubyCommandLine
extends GeneralCommandLine {
    public static final Key<RubyCommandLineData> COMMAND_LINE_DATA_KEY = new Key("COMMAND_LINE_DATA_KEY");
    private static final Set<String> SPECIAL_SHELL_OPERATORS = Set.of("&", "&&", "&>", ">", ">&", ">>", ">|", "<", "<>", "|", "||", ";");
    private static final Logger LOG = Logger.getInstance(RubyCommandLine.class);
    private static final NotNullLazyValue<Boolean> hasSh = NotNullLazyValue.lazy(() -> new File("/bin/sh").canExecute());
    @NotNull
    private final RubyRunner myRunner;
    private boolean myAskForSudo;
    private boolean myAllocatePty;
    private boolean myConsoleMode;
    private boolean myAddBundleExec;
    private boolean myWithBlockingRead;

    public RubyCommandLine(@NotNull RubyRunner runner, boolean askForSudo) {
        if (runner == null) {
            RubyCommandLine.$$$reportNull$$$0(0);
        }
        this.myConsoleMode = true;
        this.myAddBundleExec = true;
        this.myRunner = runner;
        this.myAskForSudo = askForSudo;
    }

    public static String[] patchWithSh(String ... command) {
        if (command.length > 0 && !"sh".equals(command[0]) && !"bash".equals(command[0])) {
            String joinedCommand = ParametersListUtil.join(List.of(command), arg -> RubyCommandLine.isQuotingNeeded(arg) ? CommandLineUtil.posixQuote((String)arg) : arg);
            return new String[]{"sh", "-c", joinedCommand};
        }
        return command;
    }

    private static boolean isQuotingNeeded(String arg) {
        return !SPECIAL_SHELL_OPERATORS.contains(arg);
    }

    public boolean isAskForSudo() {
        return this.myAskForSudo;
    }

    public void setAskForSudo(boolean askForSudo) {
        this.myAskForSudo = askForSudo;
    }

    public boolean isAllocatePty() {
        return this.myAllocatePty;
    }

    @NotNull
    public RubyCommandLine withPty(boolean allocatePty) {
        this.myAllocatePty = allocatePty;
        RubyCommandLine rubyCommandLine = this;
        if (rubyCommandLine == null) {
            RubyCommandLine.$$$reportNull$$$0(1);
        }
        return rubyCommandLine;
    }

    public boolean isWithBlockingRead() {
        return this.myWithBlockingRead;
    }

    @NotNull
    public RubyCommandLine withBlockingRead(boolean withBlockingRead) {
        this.myWithBlockingRead = withBlockingRead;
        RubyCommandLine rubyCommandLine = this;
        if (rubyCommandLine == null) {
            RubyCommandLine.$$$reportNull$$$0(2);
        }
        return rubyCommandLine;
    }

    @NotNull
    public RubyCommandLine withConsoleMode(boolean consoleMode) {
        this.myConsoleMode = consoleMode;
        RubyCommandLine rubyCommandLine = this;
        if (rubyCommandLine == null) {
            RubyCommandLine.$$$reportNull$$$0(3);
        }
        return rubyCommandLine;
    }

    public boolean isAddBundleExec() {
        return this.myAddBundleExec;
    }

    @NotNull
    public RubyCommandLine withAddBundleExec(boolean addBundleExec) {
        this.myAddBundleExec = addBundleExec;
        RubyCommandLine rubyCommandLine = this;
        if (rubyCommandLine == null) {
            RubyCommandLine.$$$reportNull$$$0(4);
        }
        return rubyCommandLine;
    }

    @NotNull
    public Process createProcess() throws ExecutionException {
        Process process;
        if (LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.debug("Executing: " + this.getCommandLineString());
            LOG.debug("       in: " + String.valueOf(this.getWorkingDirectory()));
            LOG.debug("      env: " + String.valueOf(this.getEnvironment()));
            LOG.debug("   params: sudo=", new Object[]{this.myAskForSudo, "; pty=", this.myAllocatePty});
        }
        if (!this.myAskForSudo) {
            Process process2 = this.myAllocatePty ? this.createPtyProcess(this) : super.createProcess();
            if (process2 == null) {
                RubyCommandLine.$$$reportNull$$$0(5);
            }
            return process2;
        }
        try {
            GeneralCommandLine sudoCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)new GeneralCommandLine(this.createCommandForSudo()), (String)"Please enter your password to make changes in system packages: ");
            process = this.myAllocatePty ? this.createPtyProcess(sudoCommandLine) : sudoCommandLine.createProcess();
        }
        catch (ExecutionException | IOException e) {
            throw new ProcessNotCreatedException(e.getMessage(), e, (GeneralCommandLine)this);
        }
        if (process == null) {
            RubyCommandLine.$$$reportNull$$$0(6);
        }
        return process;
    }

    @NotNull
    private Process createPtyProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyCommandLine.$$$reportNull$$$0(7);
        }
        PtyCommandLine ptyCommandLine = new PtyCommandLine(commandLine);
        if (!this.myRunner.getSystemAccessor().isWindows()) {
            Map environment = ptyCommandLine.getEnvironment();
            environment.putIfAbsent("PAGER", "cat");
        }
        Process process = ptyCommandLine.withConsoleMode(this.myConsoleMode).withInitialColumns(2500).createProcess();
        if (process == null) {
            RubyCommandLine.$$$reportNull$$$0(8);
        }
        return process;
    }

    @NotNull
    private List<String> createCommandForSudo() throws IOException, ExecutionException {
        ArrayList<String> command = new ArrayList<String>();
        String userHomePath = SystemProperties.getUserHome();
        if (((Boolean)hasSh.getValue()).booleanValue() && StringUtil.isNotEmpty((String)userHomePath)) {
            StringBuilder scriptText = new StringBuilder();
            scriptText.append("#!/bin/sh\n");
            if (this.getWorkingDirectory() != null) {
                scriptText.append("cd ").append(CommandLineUtil.posixQuote((String)this.getWorkingDirectory().toString())).append('\n');
            }
            scriptText.append("HOME=").append(CommandLineUtil.posixQuote((String)userHomePath)).append(' ').append(this.getCommandLineString());
            File exportHomeScript = ExecUtil.createTempExecutableScript((String)"homeDirectory", (String)".sh", (String)scriptText.toString());
            command.add("sh");
            command.add(exportHomeScript.getAbsolutePath());
        }
        ArrayList<String> arrayList = command;
        if (arrayList == null) {
            RubyCommandLine.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public RubyRunner getRunner() {
        RubyRunner rubyRunner = this.myRunner;
        if (rubyRunner == null) {
            RubyCommandLine.$$$reportNull$$$0(10);
        }
        return rubyRunner;
    }

    @Nullable
    public RubyCommandLineData getCommandLineData() {
        return (RubyCommandLineData)((Object)COMMAND_LINE_DATA_KEY.get((UserDataHolder)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyCommandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyCommandLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withPty";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withBlockingRead";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withConsoleMode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withAddBundleExec";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPtyProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandForSudo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPtyProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

