/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;

public class MergingCommandLineArgumentsProvider
extends RubyCommandLineArgumentsProvider {
    private final String[] myArgsBeforeProvider;
    private final String[] myArgsAfterProvider;
    private final RubyCommandLineArgumentsProvider myProvider;
    private final boolean myPassEnvs;
    private final Map<String, String> myAdditionalEnvs;

    public MergingCommandLineArgumentsProvider(String @Nullable [] argsBeforeProvider, @Nullable RubyCommandLineArgumentsProvider provider, String @Nullable [] argsAfterProvider, @Nullable Boolean passEnvs, @Nullable Map<String, String> additionalEnvs) {
        this.myArgsBeforeProvider = argsBeforeProvider;
        this.myArgsAfterProvider = argsAfterProvider;
        this.myProvider = provider;
        this.myPassEnvs = passEnvs == null ? provider != null && provider.passParentEnvs() : passEnvs;
        this.myAdditionalEnvs = additionalEnvs == null ? MergingCommandLineArgumentsProvider.mergeEnvs(provider, null) : MergingCommandLineArgumentsProvider.mergeEnvs(provider, additionalEnvs);
    }

    @Nullable
    private static Map<String, String> mergeEnvs(@Nullable RubyCommandLineArgumentsProvider provider, @Nullable Map<String, String> additionalEnvs) {
        if (provider == null) {
            return additionalEnvs;
        }
        Map<String, String> providerSettings = provider.getAdditionalEnvs();
        if (additionalEnvs != null) {
            for (Map.Entry<String, String> nameAndValue : additionalEnvs.entrySet()) {
                assert (providerSettings != null);
                providerSettings.put(nameAndValue.getKey(), nameAndValue.getValue());
            }
        }
        return providerSettings;
    }

    public MergingCommandLineArgumentsProvider(String @Nullable [] argsBeforeProvider, @Nullable RubyCommandLineArgumentsProvider provider, String @Nullable [] argsAfterProvider, @Nullable Map<String, String> additionalEnvs) {
        this(argsBeforeProvider, provider, argsAfterProvider, provider == null || provider.passParentEnvs(), MergingCommandLineArgumentsProvider.mergeEnvs(provider, additionalEnvs));
    }

    public static String[] stringToArguments(@NotNull String argsString) {
        if (argsString == null) {
            MergingCommandLineArgumentsProvider.$$$reportNull$$$0(0);
        }
        return ParametersList.parse((String)argsString);
    }

    @Override
    public boolean passParentEnvs() {
        return this.myPassEnvs;
    }

    @Override
    @Nullable
    public Map<String, String> getAdditionalEnvs() {
        return this.myAdditionalEnvs;
    }

    @NotNull
    public static List<String> collectArguments(@NotNull String argumentsString) {
        if (argumentsString == null) {
            MergingCommandLineArgumentsProvider.$$$reportNull$$$0(1);
        }
        return MergingCommandLineArgumentsProvider.collectArguments(argumentsString, new ArrayList<String>());
    }

    @NotNull
    public static List<String> collectArguments(@NotNull String argumentsString, @NotNull List<String> params) {
        if (argumentsString == null) {
            MergingCommandLineArgumentsProvider.$$$reportNull$$$0(2);
        }
        if (params == null) {
            MergingCommandLineArgumentsProvider.$$$reportNull$$$0(3);
        }
        Collections.addAll(params, MergingCommandLineArgumentsProvider.stringToArguments(argumentsString));
        List<String> list = params;
        if (list == null) {
            MergingCommandLineArgumentsProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public String @NotNull [] getArguments() {
        ArrayList<String> argsList = new ArrayList<String>();
        MergingCommandLineArgumentsProvider.appendToList(argsList, this.myArgsBeforeProvider);
        String[] pArgs = this.myProvider == null ? null : this.myProvider.getArguments();
        MergingCommandLineArgumentsProvider.appendToList(argsList, pArgs);
        MergingCommandLineArgumentsProvider.appendToList(argsList, this.myArgsAfterProvider);
        String[] stringArray = ArrayUtilRt.toStringArray(argsList);
        if (stringArray == null) {
            MergingCommandLineArgumentsProvider.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    private static void appendToList(ArrayList<String> argsList, String[] pArgs) {
        if (pArgs != null) {
            ContainerUtil.addAll(argsList, (Object[])pArgs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsString";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/MergingCommandLineArgumentsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/MergingCommandLineArgumentsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringToArguments";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectArguments";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

