/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.bundler.actions.AbstractBundlerAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/run/BundlerMissingGemsProcessAdapter;", "Lcom/intellij/execution/process/ProcessListener;", "module", "Lcom/intellij/openapi/module/Module;", "executionID", "", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "Companion", "intellij.ruby.backend"})
public final class BundlerMissingGemsProcessAdapter
implements ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @Nullable
    private final String executionID;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String BUNDLER_NOTIFICATION_GROUP = "Bundler";
    @NotNull
    private static final String BUNDLER_GEM_NOT_FOUND = "Bundler::GemNotFound";
    @NotNull
    private static final String BUNDLE_INSTALL = "`bundle install`";
    @NotNull
    private static final Key<Notification> BUNDLE_MISSING_GEMS;
    @NotNull
    private static Key<BundlerMissingGemsProcessAdapter> LISTENER_KEY;

    private BundlerMissingGemsProcessAdapter(Module module, String executionID) {
        this.module = module;
        this.executionID = executionID;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Object[] objectArray = new String[]{"GEMFILE_HAS_MISSING_GEMS", "GENERATORS_SILENT_UPDATE"};
        if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)this.executionID)) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            BundlerMissingGemsProcessAdapter.Companion.processBundlerMissingGems(this.module, string);
        }
    }

    public /* synthetic */ BundlerMissingGemsProcessAdapter(Module module, String executionID, DefaultConstructorMarker $constructor_marker) {
        this(module, executionID);
    }

    static {
        Logger logger = Logger.getInstance(BundlerMissingGemsProcessAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"BUNDLE_MISSING_GEMS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BUNDLE_MISSING_GEMS = key;
        Key key2 = Key.create((String)"BundlerMissingGemsProcessAdapter");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        LISTENER_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0007J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/run/BundlerMissingGemsProcessAdapter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BUNDLER_NOTIFICATION_GROUP", "", "BUNDLER_GEM_NOT_FOUND", "BUNDLE_INSTALL", "BUNDLE_MISSING_GEMS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notification/Notification;", "LISTENER_KEY", "Lorg/jetbrains/plugins/ruby/ruby/run/BundlerMissingGemsProcessAdapter;", "attach", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "module", "Lcom/intellij/openapi/module/Module;", "executionID", "processBundlerMissingGems", "output", "intellij.ruby.backend"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmOverloads
        public final void attach(@NotNull ProcessHandler processHandler, @NotNull Module module, @Nullable String executionID) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ProcessHandler processHandler2 = processHandler;
            synchronized (processHandler2) {
                boolean bl = false;
                if (processHandler.getUserData(LISTENER_KEY) != null) {
                    LOG.warn("Attempted to attach duplicate " + Reflection.getOrCreateKotlinClass(BundlerMissingGemsProcessAdapter.class).getSimpleName() + " listener: process=" + processHandler + ", module=" + module + ", execId=" + executionID);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Attaching duplicate listener stack trace:\n" + DebugUtil.currentStackTrace());
                    }
                    return;
                }
                BundlerMissingGemsProcessAdapter listener = new BundlerMissingGemsProcessAdapter(module, executionID, null);
                processHandler.addProcessListener((ProcessListener)listener);
                processHandler.putUserData(LISTENER_KEY, (Object)listener);
                Unit unit = Unit.INSTANCE;
            }
        }

        public static /* synthetic */ void attach$default(Companion companion, ProcessHandler processHandler, Module module, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = null;
            }
            companion.attach(processHandler, module, string);
        }

        private final void processBundlerMissingGems(Module module, String output2) {
            if (StringsKt.contains$default((CharSequence)output2, (CharSequence)BundlerMissingGemsProcessAdapter.BUNDLER_GEM_NOT_FOUND, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)output2, (CharSequence)BundlerMissingGemsProcessAdapter.BUNDLE_INSTALL, (boolean)false, (int)2, null)) {
                Notification notification = new Notification(BundlerMissingGemsProcessAdapter.BUNDLER_NOTIFICATION_GROUP, RBundle.message((String)"bundler.console.gem.not.found.title"), "", NotificationType.INFORMATION);
                String string = RBundle.message((String)"bundler.console.gem.not.found.action.bundle.install");
                notification.addAction((AnAction)new DumbAwareAction(module, notification, string){
                    final /* synthetic */ Module $module;
                    final /* synthetic */ Notification $notification;
                    {
                        this.$module = $module;
                        this.$notification = $notification;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        AbstractBundlerAction action;
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        AbstractBundlerAction abstractBundlerAction = action = (AbstractBundlerAction)ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction");
                        if (abstractBundlerAction != null) {
                            abstractBundlerAction.runBundlerAction(this.$module);
                        } else {
                            BundlerMissingGemsProcessAdapter.access$getLOG$cp().warn("Cannot find 'bundle install' action.");
                        }
                        this.$notification.expire();
                    }
                });
                Notification old_notification = (Notification)module.getUserData(BUNDLE_MISSING_GEMS);
                if (old_notification == null || old_notification.isExpired()) {
                    Notifications.Bus.notify((Notification)notification, (Project)module.getProject());
                    Alarm alarm = new Alarm();
                    alarm.addRequest(() -> Companion.processBundlerMissingGems$lambda$0(module, notification), 10000);
                    module.putUserData(BUNDLE_MISSING_GEMS, (Object)notification);
                }
            }
        }

        @JvmOverloads
        public final void attach(@NotNull ProcessHandler processHandler, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            org.jetbrains.plugins.ruby.ruby.run.BundlerMissingGemsProcessAdapter$Companion.attach$default(this, processHandler, module, null, 4, null);
        }

        private static final void processBundlerMissingGems$lambda$0(Module $module, Notification $notification) {
            if (!$module.isDisposed()) {
                Project project = $module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Balloon balloon = ToolWindowManager.Companion.getInstance(project).getToolWindowBalloon("Run");
                if (balloon != null) {
                    balloon.hide();
                }
                $notification.expire();
                $module.putUserData(BUNDLE_MISSING_GEMS, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

