/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

@ApiStatus.Internal
public abstract class AbstractConsoleRunner {
    private final Logger LOG;
    private static final String CONSOLE_RUNNER_ID = "RubyConsoleRunner";
    private static CompletableFuture<Void> ourTestProcessStartedFuture;
    private static Semaphore ourTestSemaphore;
    private static int ourLastExitCode;
    private final ConsoleRunnerOptions myOptions;
    private RubyCommandLineArgumentsProvider myArgumentsProvider;
    private ProcessHandler myProcessHandler;

    AbstractConsoleRunner(@NotNull ConsoleRunnerOptions options, @NotNull RubyCommandLineArgumentsProvider argumentsProvider) {
        if (options == null) {
            AbstractConsoleRunner.$$$reportNull$$$0(0);
        }
        if (argumentsProvider == null) {
            AbstractConsoleRunner.$$$reportNull$$$0(1);
        }
        this.LOG = Logger.getInstance(this.getClass());
        this.myOptions = options;
        this.myArgumentsProvider = argumentsProvider;
    }

    @NotNull
    protected ConsoleRunnerOptions getOptions() {
        ConsoleRunnerOptions consoleRunnerOptions = this.myOptions;
        if (consoleRunnerOptions == null) {
            AbstractConsoleRunner.$$$reportNull$$$0(2);
        }
        return consoleRunnerOptions;
    }

    @NotNull
    protected RubyCommandLineArgumentsProvider getArgumentsProvider() {
        RubyCommandLineArgumentsProvider rubyCommandLineArgumentsProvider = this.myArgumentsProvider;
        if (rubyCommandLineArgumentsProvider == null) {
            AbstractConsoleRunner.$$$reportNull$$$0(3);
        }
        return rubyCommandLineArgumentsProvider;
    }

    @NotNull
    protected abstract RubyRunner getRunner();

    @NotNull
    protected abstract RubyRunnerExecutionContext getExecutionContext();

    protected abstract void customizeConsoleView(@NotNull ConsoleView var1);

    private void init() throws com.intellij.execution.ExecutionException {
        RubyRunner runner = this.getRunner();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        RubyCommandLine commandLine = runner.createCommandLine((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)this.getExecutionContext().withParentEnv(this.myArgumentsProvider.passParentEnvs())).withAdditionalEnvs(this.myArgumentsProvider.getAdditionalEnvs())).withCommandLinePreprocessor(this.myOptions.cmdlinePreprocessor())).withAskForSudo(false)).withPty(Registry.is((String)"ruby.run.configurations.with.pty") && !isUnitTestMode)).withBlockingRead(this.myOptions.blockingRead()).withConsoleMode(this.myOptions.consoleMode());
        this.myProcessHandler = runner.createProcessHandler(commandLine, CONSOLE_RUNNER_ID);
        this.myOptions.processHandlerCustomizer().accept(this.myProcessHandler);
        if (isUnitTestMode) {
            this.LOG.debug("Running in console: " + String.valueOf((Object)commandLine));
            this.myProcessHandler.addProcessListener(new ProcessListener(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ourTestSemaphore.down();
                    ourTestProcessStartedFuture.complete(null);
                    AbstractConsoleRunner.this.LOG.debug("Process started: " + String.valueOf(event.getProcessHandler()));
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    AbstractConsoleRunner.this.LOG.debug("Process terminated: " + event.getExitCode() + " (" + String.valueOf(event.getProcessHandler()) + ")");
                    ourLastExitCode = event.getExitCode();
                    ourTestSemaphore.up();
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    AbstractConsoleRunner.this.LOG.debug(String.valueOf(outputType) + ": " + event.getText().trim());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (this.myOptions.processListener() != null) {
            this.myProcessHandler.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_REMOTE_CLIENTS, (Object)true);
            this.myProcessHandler.addProcessListener(this.myOptions.processListener());
        }
        ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
        if (!isUnitTestMode) {
            ApplicationManager.getApplication().invokeAndWait(() -> this.initUi());
        }
    }

    private void initUi() {
        Project project = this.myOptions.project();
        ConsoleView myConsoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        myConsoleView.setHelpId(AbstractConsoleRunner.getHelpID());
        this.customizeConsoleView(myConsoleView);
        for (Filter filter : this.myOptions.filters()) {
            myConsoleView.addMessageFilter(filter);
        }
        myConsoleView.attachToProcess(this.myProcessHandler);
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        String consoleTitle = this.myOptions.title();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(CONSOLE_RUNNER_ID, consoleTitle, consoleTitle, RubyPluginUtil.getUnloadAwareDisposable(project));
        ui.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        Content consoleContent = ui.createContent(CONSOLE_RUNNER_ID, myConsoleView.getComponent(), consoleTitle, null, myConsoleView.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        ui.getOptions().setLeftToolbar((ActionGroup)toolbarActions, "toolbar");
        RunContentDescriptorFactory descriptorFactory = this.myOptions.runContentDescriptorFactory();
        RunContentDescriptorFactory factory = descriptorFactory == null ? RunContentDescriptorFactory.DEFAULT : descriptorFactory;
        RunContentDescriptor myDescriptor = factory.createDesc(myConsoleView, this.myProcessHandler, ui.getComponent(), consoleTitle, this.myOptions.reuseProhibited());
        DefaultActionGroup consoleActionsGroup = new DefaultActionGroup();
        consoleActionsGroup.addAll(myConsoleView.createConsoleActions());
        consoleContent.setActions((ActionGroup)consoleActionsGroup, "unknown", myConsoleView.getComponent());
        RerunAction rerunAction = new RerunAction(myConsoleView, this, () -> {
            if (this.myOptions.processListener() != null) {
                this.myProcessHandler.removeProcessListener(this.myOptions.processListener());
            }
            this.startProcess();
        });
        toolbarActions.add((AnAction)rerunAction);
        toolbarActions.add(ActionManager.getInstance().getAction("Stop"));
        toolbarActions.add((AnAction)new ShowCmdLine());
        toolbarActions.addSeparator();
        if (!this.myOptions.userActions().isEmpty()) {
            for (AnAction userAction : this.myOptions.userActions()) {
                toolbarActions.add(userAction);
            }
            toolbarActions.addSeparator();
        }
        toolbarActions.add(PinToolwindowTabAction.getPinAction());
        toolbarActions.add((AnAction)new CloseAction(defaultExecutor, myDescriptor, project));
        toolbarActions.add((AnAction)new ContextHelpAction(AbstractConsoleRunner.getHelpID()));
        RunContentManager.getInstance((Project)project).showRunContent(defaultExecutor, myDescriptor);
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    protected void startProcess() {
        final Project project = this.myOptions.project();
        final String consoleTitle = this.myOptions.title();
        String taskTitle = RBundle.message((String)"progress.title.console.runner.modal.dialog.running", (Object[])new Object[]{consoleTitle});
        Task.Backgroundable task = new Task.Backgroundable(project, taskTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(RBundle.message((String)"progress.backgnd.indicator.title.please.wait", (Object[])new Object[]{this.getTitle()}));
                try {
                    AbstractConsoleRunner.this.init();
                    AbstractConsoleRunner.this.myProcessHandler.startNotify();
                    AbstractConsoleRunner.this.myProcessHandler.waitFor();
                }
                catch (com.intellij.execution.ExecutionException e) {
                    ExecutionHelper.showErrors((Project)project, Collections.singletonList(e), (String)consoleTitle, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @NotNull
    private static String getHelpID() {
        return "Run_Tool_Window.xml";
    }

    @TestOnly
    public static Pair<Boolean, Integer> waitAllExecutionsFinished() {
        return Pair.create((Object)ourTestSemaphore.waitFor(10L), (Object)ourLastExitCode);
    }

    @TestOnly
    public static void setUp() {
        ourTestProcessStartedFuture = new CompletableFuture();
        ourTestSemaphore = new Semaphore();
    }

    @TestOnly
    public static void waitForProcessStarted(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        ourTestProcessStartedFuture.get(timeout, unit);
    }

    static {
        ourLastExitCode = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    static class RerunAction
    extends AnAction {
        private final Runnable myRerunTask;
        private final AbstractConsoleRunner myRunner;

        RerunAction(ConsoleView consoleView, AbstractConsoleRunner runner, Runnable rerun) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), AllIcons.Actions.Rerun);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consoleView.getComponent());
            this.myRerunTask = rerun;
            this.myRunner = runner;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myRunner.getProcessHandler().isProcessTerminated());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(2);
            }
            this.perform();
        }

        void perform() {
            this.myRerunTask.run();
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner$RerunAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner$RerunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class ShowCmdLine
    extends AnAction {
        ShowCmdLine() {
            super(RBundle.messagePointer((String)"action.console.runner.edit.cmdline.text"), RBundle.messagePointer((String)"action.console.runner.edit.cmdline.description"), AllIcons.Actions.ShowViewer);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowCmdLine.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowCmdLine.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(AbstractConsoleRunner.this.getProcessHandler().isProcessTerminated());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String initialValue;
            String title;
            if (e == null) {
                ShowCmdLine.$$$reportNull$$$0(2);
            }
            String[] args = AbstractConsoleRunner.this.myArgumentsProvider.getArguments();
            StringBuilder buff = new StringBuilder();
            for (String arg : args) {
                buff.append(arg);
                buff.append(" ");
            }
            String msg = RBundle.message((String)"action.console.runner.edit.cmdline.dialog.text");
            String result = Messages.showInputDialog((String)msg, (String)(title = RBundle.message((String)"action.console.runner.edit.cmdline.dialog.title")), null, (String)(initialValue = buff.toString()), null);
            if (StringUtil.isEmpty((String)result)) {
                return;
            }
            ArrayList<String> userArgsList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(result);
            while (st.hasMoreTokens()) {
                userArgsList.add(st.nextToken());
            }
            String[] userArgs = ArrayUtilRt.toStringArray(userArgsList);
            AbstractConsoleRunner.this.myArgumentsProvider = new MergingCommandLineArgumentsProvider(userArgs, null, null, AbstractConsoleRunner.this.myArgumentsProvider.getAdditionalEnvs());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner$ShowCmdLine";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/AbstractConsoleRunner$ShowCmdLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

