/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.replacement;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementBase;

public class RubyReplacementElement
extends RubyReplacementBase {
    @NotNull
    private List<PsiElement> myOccurrences;

    public RubyReplacementElement(@NotNull PsiElement element, @NotNull RPsiElement expression, @Nullable RPsiElement context) {
        if (element == null) {
            RubyReplacementElement.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            RubyReplacementElement.$$$reportNull$$$0(1);
        }
        super(element, expression);
        if (this.getExpression().getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE) != null) {
            this.myOccurrences = Collections.emptyList();
            return;
        }
        this.myOccurrences = RubyRefactoringUtil.getOccurrences(expression, context);
        if (expression instanceof RVariable) {
            this.processVariableCase(expression);
        }
    }

    private void processVariableCase(@NotNull RPsiElement expression) {
        if (expression == null) {
            RubyReplacementElement.$$$reportNull$$$0(2);
        }
        this.myOccurrences.replaceAll(e -> {
            RAssignmentExpression assignment = RubyPsiUtil.getAnyAssignmentByLeftPart(e);
            return assignment == null ? e : assignment;
        });
        List<PsiElement> elements = ContainerUtil.filter(this.myOccurrences, e -> e instanceof RAssignmentExpression);
        if (elements.size() >= 2 || elements.size() == 1 && !(this.myOccurrences.get(0) instanceof RAssignmentExpression)) {
            RPsiElement place = RubyPsiUtilCore.getStatement((PsiElement)expression);
            if (place == null) {
                this.setExpression(null);
                return;
            }
            RAssignmentExpression assignment = RubyPsiUtil.getAnyAssignmentByLeftPart((PsiElement)expression);
            if (assignment != null) {
                expression = assignment;
                elements = this.myOccurrences;
                this.setExpression((RPsiElement)assignment);
            }
            this.findConflictOccurrences(expression, elements, place);
        } else if (!elements.isEmpty()) {
            this.setExpression((RPsiElement)elements.get(0));
        }
    }

    private void findConflictOccurrences(@NotNull RPsiElement expression, @NotNull List<PsiElement> elements, @NotNull RPsiElement place) {
        if (expression == null) {
            RubyReplacementElement.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            RubyReplacementElement.$$$reportNull$$$0(4);
        }
        if (place == null) {
            RubyReplacementElement.$$$reportNull$$$0(5);
        }
        for (PsiElement e : elements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)place, (PsiElement)e, (boolean)true) || this.myOccurrences.indexOf(expression) <= this.myOccurrences.indexOf(e)) continue;
            this.setExpression(null);
            return;
        }
        this.myOccurrences = Collections.singletonList(expression);
    }

    @Override
    @NotNull
    public List<PsiElement> getOccurrences() {
        List<PsiElement> list = this.myOccurrences;
        if (list == null) {
            RubyReplacementElement.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void replaceOccurrences(@NotNull Project project, @NotNull String replacement, boolean replaceAll) {
        if (project == null) {
            RubyReplacementElement.$$$reportNull$$$0(7);
        }
        if (replacement == null) {
            RubyReplacementElement.$$$reportNull$$$0(8);
        }
        List<PsiElement> replacements = this.myOccurrences;
        if (!replaceAll) {
            replacements = Collections.singletonList(this.getExpression());
        }
        for (PsiElement occurrence : replacements) {
            RefactoringPsiHelper.replaceExpressionWithText(project, occurrence, replacement);
        }
    }

    @Override
    public boolean isStatement() {
        return this.myOccurrences.size() == 1 && this.getExpression() == RubyPsiUtilCore.getStatement((PsiElement)this.getExpression());
    }

    @Override
    @NotNull
    public String getExtractedText(@NotNull String name, boolean isKeywordInitializer, boolean isListAllowed) {
        RCompoundStatement statement;
        String symbol;
        if (name == null) {
            RubyReplacementElement.$$$reportNull$$$0(9);
        }
        RPsiElement expression = this.getExpression();
        String string = symbol = isKeywordInitializer ? ": " : " = ";
        String extractedText = expression instanceof RExpressionSubstitution ? name + symbol + ((statement = ((RExpressionSubstitution)expression).getCompoundStatement()) != null ? statement.getText() : "") : (expression instanceof RAssoc || expression instanceof RListOfExpressions && ((RListOfExpressions)expression).getFirstElement() instanceof RAssoc ? name + symbol + "{" + expression.getText() + "}" : (expression instanceof RListOfExpressions && (!isListAllowed || expression.getParent() instanceof RCall) ? name + symbol + "[" + expression.getText() + "]" : (expression instanceof RModifierStatement ? name + symbol + "(" + expression.getText() + ")" : name + symbol + expression.getText())));
        String string2 = extractedText;
        if (string2 == null) {
            RubyReplacementElement.$$$reportNull$$$0(10);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/replacement/RubyReplacementElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/replacement/RubyReplacementElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processVariableCase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findConflictOccurrences";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceOccurrences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtractedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }
}

