/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pushDown;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.pushDown.RubyPushDownDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.pushDown.RubyPushDownProcessor;

public final class RubyPushDownHandler
extends RubyClassRefactoringHandlerBase {
    public void showDialog(Project project, PsiElement element, Editor editor, PsiFile file, DataContext dataContext) {
        RContainer clazz = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)element);
        assert (clazz != null);
        RubyMemberInfoStorage infoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos(clazz, element);
        HashSet classes = new HashSet();
        RubyOverrideImplementUtil.addDerivedClasses(clazz, classes);
        if (infoStorage.getClassMemberInfos((PsiElement)clazz).isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RBundle.message((String)"error.hint.no.members.to.push.down.found")), (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        if (classes.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.push.down.error.cannot.perform.refactoring.no.child.classes", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), (String)RefactoringBundle.message((String)"push.members.down.title"), (String)"members.push.down");
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        RubyPushDownDialog dialog = new RubyPushDownDialog(project, clazz, infoStorage, new RubyPushDownProcessor(clazz));
        dialog.show();
    }

    protected String getHelpId() {
        return "members.push.down";
    }

    protected String getTitle() {
        return RefactoringBundle.message((String)"push.members.down.title");
    }

    protected String getInvalidPositionMessage() {
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");
    }
}

