/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pullUp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassCellRenderer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.UpDirectedMembersMovingDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.pullUp.PullUpConflictsUtil;

public class RubyPullUpDialog
extends UpDirectedMembersMovingDialog {
    private JComboBox myClassCombo;
    private final Collection<RContainer> mySuperClasses;
    private final Collection<? extends RContainer> myInstanceSuper;
    private final Collection<? extends RContainer> myStaticSuper;
    private final RubyMemberInfoStorage myStorage;

    public RubyPullUpDialog(Project project, RContainer clazz, Collection<? extends RContainer> superClasses, Collection<? extends RContainer> staticModules, RubyMemberInfoStorage storage) {
        super(project, clazz);
        this.myStorage = storage;
        this.myInstanceSuper = superClasses;
        this.myStaticSuper = staticModules;
        this.mySuperClasses = new TreeSet<RContainer>((o1, o2) -> {
            String name1 = RubyClassCellRenderer.getClassText(o1);
            String name2 = RubyClassCellRenderer.getClassText(o2);
            return name1.compareTo(name2);
        });
        this.mySuperClasses.addAll(superClasses);
        this.mySuperClasses.addAll(staticModules);
        this.myMemberInfos = this.myStorage.getClassMemberInfos((PsiElement)this.myClass);
        this.setTitle(RefactoringBundle.message((String)"pull.members.up.title"));
        this.init();
    }

    @Override
    protected DependencyMemberInfoModel<RPsiElement, RubyMemberInfo> createMemberInfoModel() {
        return new MyMemberInfoModel(this.myClass);
    }

    protected String getHelpId() {
        return "refactoring.pullMembersUp";
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel2.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new JComboBox<Object>(this.mySuperClasses.toArray());
        this.myClassCombo.setRenderer(new RubyClassCellRenderer());
        String fqn = this.myClass instanceof RClass ? RubyClassResolveUtil.getQualifiedName((RClass)this.myClass) : ((RModule)this.myClass).getQualifiedName();
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{fqn}));
        classComboLabel.setLabelFor(this.myClassCombo);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RubyPullUpDialog.this.updateMembersInfo();
                    if (RubyPullUpDialog.this.myMemberSelectionPanel != null) {
                        ((MyMemberInfoModel)RubyPullUpDialog.this.myMemberInfoModel).setSuperClass((PsiElement)RubyPullUpDialog.this.getSuperClass());
                        RubyPullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(RubyPullUpDialog.this.myMemberInfos);
                        RubyPullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                }
            }
        });
        ++gbConstraints.gridy;
        panel2.add((Component)this.myClassCombo, gbConstraints);
        this.updateMembersInfo();
        return panel2;
    }

    private void updateMembersInfo() {
        RContainer targetClass = (RContainer)this.myClassCombo.getSelectedItem();
        this.myMemberInfos = this.myStorage.getIntermediateMemberInfosList((PsiElement)targetClass);
    }

    @Override
    public boolean checkConflicts() {
        Collection<RubyMemberInfo> infos = this.getSelectedMemberInfos();
        RContainer superClass = this.getSuperClass();
        if (!RubyPullUpDialog.checkWritable(superClass, infos)) {
            return false;
        }
        MultiMap<PsiElement, String> conflicts = PullUpConflictsUtil.checkConflicts(infos, this.myClass, superClass);
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myClass.getProject(), conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                this.close(1);
            }
            return ok;
        }
        return true;
    }

    @Nullable
    public RContainer getSuperClass() {
        return this.myClassCombo != null ? (RContainer)this.myClassCombo.getSelectedItem() : null;
    }

    public boolean isStatic() {
        RContainer superClass = this.getSuperClass();
        return this.myStaticSuper.contains(superClass) && !this.myInstanceSuper.contains(superClass);
    }

    @Override
    protected String getMembersBorderTitle() {
        return RefactoringBundle.message((String)"members.to.be.pulled.up");
    }

    private class MyMemberInfoModel
    extends AbstractUsesDependencyMemberInfoModel<RPsiElement, RContainer, RubyMemberInfo> {
        MyMemberInfoModel(RContainer clazz) {
            super((PsiElement)clazz, (PsiElement)RubyPullUpDialog.this.getSuperClass(), false);
        }

        public boolean isMemberEnabled(RubyMemberInfo member) {
            RContainer currentSuperClass = RubyPullUpDialog.this.getSuperClass();
            if (member.isStatic() && currentSuperClass instanceof RModule && !RubyPullUpDialog.this.myStaticSuper.contains(currentSuperClass)) {
                return false;
            }
            if (!member.isStatic() && currentSuperClass instanceof RModule && !RubyPullUpDialog.this.myInstanceSuper.contains(currentSuperClass)) {
                return false;
            }
            RPsiElement element = (RPsiElement)member.getMember();
            if (element instanceof RConstant) {
                for (PsiReference reference : element.getReferences()) {
                    if (reference.resolve() != currentSuperClass) continue;
                    return false;
                }
            }
            return currentSuperClass == null || !RubyPullUpDialog.this.myStorage.getDuplicatedMemberInfos((PsiElement)currentSuperClass).contains((Object)member);
        }

        public boolean isAbstractEnabled(RubyMemberInfo member) {
            return false;
        }

        public int checkForProblems(@NotNull RubyMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.$$$reportNull$$$0(0);
            }
            return member.isChecked() ? 0 : super.checkForProblems((MemberInfoBase)member);
        }

        protected int doCheck(@NotNull RubyMemberInfo memberInfo, int problem) {
            if (memberInfo == null) {
                MyMemberInfoModel.$$$reportNull$$$0(1);
            }
            if (problem == 2 && memberInfo.isStatic()) {
                return 1;
            }
            return problem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberInfo";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/pullUp/RubyPullUpDialog$MyMemberInfoModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

