/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pullUp;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;

public final class PullUpConflictsUtil {
    public static MultiMap<PsiElement, String> checkConflicts(Collection<? extends RubyMemberInfo> infos, RContainer baseClass, RContainer superClass) {
        MultiMap conflictsList = new MultiMap();
        for (RubyMemberInfo rubyMemberInfo : infos) {
            PsiElement member = rubyMemberInfo.getMember();
            boolean isConflict = false;
            if (member instanceof RMethod) {
                RMethod superClassMethod = RubyRefactoringUtil.findMethodBySignature(superClass, (RMethod)member, false);
                isConflict = superClassMethod != null;
            } else if (member instanceof RConstant) {
                RConstant constant = (RConstant)member;
                Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)baseClass);
                boolean global = RNameUtilCore.getPath((PsiElement)constant).isToplevel();
                Symbol target = SymbolUtil.lookupConstant((Symbol)(global ? SymbolUtil.getRootSymbol((RTopLevelContainer)RubyPsiUtil.getRFile((PsiElement)baseClass)) : symbol), (PsiElement)baseClass, RNameUtilCore.getPath((PsiElement)constant), Type.MODULE.asSet(), (PsiElement)constant);
                if (target == null || !target.getAllDeclarations((PsiElement)baseClass).contains(superClass)) continue;
                String message = "Including " + RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)false) + " in itself will result in cyclic include";
                conflictsList.putValue((Object)superClass, (Object)message);
                continue;
            }
            if (!isConflict) continue;
            String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflictsList.putValue((Object)superClass, (Object)message);
        }
        return conflictsList;
    }
}

