/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.moveInner;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PsiNavigateUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.moveInner.RubyMoveClassModuleDialog;

public final class RubyMoveClassModuleImpl {
    private static final Logger LOG = Logger.getInstance(RubyMoveClassModuleImpl.class);

    static boolean doMove(PsiElement element, Project project) {
        if (!(element instanceof RConstant)) {
            return false;
        }
        RContainer container = ((RConstant)element).getParentContainer();
        if (container instanceof RClass || container instanceof RModule) {
            new RubyMoveClassModuleDialog(project, container).showAndGet();
            return true;
        }
        return false;
    }

    @NotNull
    private static PsiElement doExtract(@NotNull RContainer container, @NotNull String newContainerName, @NotNull String fileName, @NotNull PsiDirectory directory) throws IOException {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(0);
        }
        if (newContainerName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(3);
        }
        List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)container);
        String containerFullText = RubyMoveClassModuleImpl.getContainerFullText(container, RubyMoveClassModuleImpl.getNewContainerFullName(container, newContainerName), comments);
        RFile file = RubyClassMembersPsiHelper.createTargetFile(container.getProject(), directory.getVirtualFile(), fileName, containerFullText);
        RubyClassMembersPsiHelper.insertRequireByAnchor(file, (PsiElement)(comments.isEmpty() ? container : (PsiElement)comments.get(0)));
        String newContainerFullName = RubyMoveClassModuleImpl.getNewContainerQualifiedName(container, newContainerName);
        RubyClassMembersPsiHelper.removeComments(comments);
        RubyClassMembersPsiHelper.removeContainer(container);
        PsiElement psiElement = RubyClassMembersPsiHelper.findPrepared(file, newContainerFullName);
        if (psiElement == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    static String getNewContainerFullName(@NotNull RContainer container, @NotNull String newContainerFullName) {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(5);
        }
        if (newContainerFullName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(6);
        }
        List fullPath = container.getFQN().asList();
        Object newPath = "";
        for (int i = 0; i < fullPath.size() - 1; ++i) {
            newPath = (String)newPath + (String)fullPath.get(i) + "::";
        }
        String string = (String)newPath + newContainerFullName;
        if (string == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    static String getNewContainerQualifiedName(@NotNull RContainer container, @NotNull String newContainerName) {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(8);
        }
        if (newContainerName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(9);
        }
        String newContainerFullName = RubyMoveClassModuleImpl.getNewContainerFullName(container, newContainerName);
        RContainer parentContainer = container.getParentContainer();
        if (parentContainer instanceof RClass || parentContainer instanceof RModule) {
            String qualifiedName = RubyMoveClassModuleImpl.getClassModuleQualifiedName(parentContainer);
            Object object = qualifiedName != null ? qualifiedName + "::" + newContainerFullName : newContainerFullName;
            if (object == null) {
                RubyMoveClassModuleImpl.$$$reportNull$$$0(10);
            }
            return object;
        }
        String string = newContainerFullName;
        if (string == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static String getClassModuleQualifiedName(@NotNull RContainer container) {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(12);
        }
        String qualifiedName = container.getFQN().getFullPath();
        if (container instanceof RClass) {
            qualifiedName = RubyClassResolveUtil.getQualifiedName((RClass)container);
        } else if (container instanceof RModule) {
            qualifiedName = ((RModule)container).getQualifiedName();
        }
        return qualifiedName;
    }

    @NotNull
    private static String getContainerFullText(@NotNull RContainer clazz, @NotNull String newContainerName, List<PsiComment> comments) {
        if (clazz == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(13);
        }
        if (newContainerName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(14);
        }
        boolean isInner = true;
        String extractedContainerText = "";
        RContainer container = clazz;
        while (container instanceof RClass || container instanceof RModule) {
            if (isInner) {
                extractedContainerText = RubyMoveClassModuleImpl.getContainerText(container, container.getCompoundStatement().getText(), newContainerName);
                isInner = false;
            } else {
                extractedContainerText = RubyMoveClassModuleImpl.getContainerText(container, extractedContainerText);
            }
            container = container.getParentContainer();
        }
        Object commentText = "";
        for (PsiComment comment : comments) {
            if (!((String)commentText).isEmpty()) {
                commentText = (String)commentText + "\n";
            }
            commentText = (String)commentText + comment.getText();
        }
        String string = (String)commentText + "\n\n" + extractedContainerText;
        if (string == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getContainerText(@NotNull RContainer container, @NotNull String body) {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(16);
        }
        if (body == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(17);
        }
        return RubyMoveClassModuleImpl.getContainerText(container, body, container.getName());
    }

    @NotNull
    private static String getContainerText(@NotNull RContainer container, @NotNull String body, @NotNull String newShortName) {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(18);
        }
        if (body == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(19);
        }
        if (newShortName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(20);
        }
        String type = container.getSymbolType().getPresentableName();
        Object extractedContainerText = "";
        if (container instanceof RClass) {
            RSuperClass superClass = ((RClass)container).getPsiSuperClass();
            String extendsClause = superClass != null ? "< " + superClass.getText() : "";
            extractedContainerText = type + " " + newShortName + " " + extendsClause + " \n" + body + "\nend";
        } else if (container instanceof RModule) {
            extractedContainerText = type + " " + newShortName + " \n" + body + "\nend";
        }
        String string = extractedContainerText;
        if (string == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static void navigate(PsiElement element) {
        PsiNavigateUtil.navigate((PsiElement)element);
    }

    public static boolean performRefactoring(@NotNull RContainer container, @NotNull String newContainerName, @NotNull String filePath, @NotNull PsiDirectory directory, UsageInfo @NotNull [] usages) {
        if (container == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(22);
        }
        if (newContainerName == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(23);
        }
        if (filePath == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(24);
        }
        if (directory == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(25);
        }
        if (usages == null) {
            RubyMoveClassModuleImpl.$$$reportNull$$$0(26);
        }
        Project project = container.getProject();
        Ref isSuccess = Ref.create((Object)false);
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> {
            try {
                RubyMoveClassModuleImpl.renameUsages(usages, newContainerName);
                PsiElement extractedContainer = RubyMoveClassModuleImpl.doExtract(container, newContainerName, filePath, directory);
                RubyMoveClassModuleImpl.navigate(extractedContainer);
                isSuccess.set((Object)true);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        })), RBundle.message((String)"refactoring.move.class.module.command", (Object[])new Object[]{container.getSymbolType().getPresentableName()}), null);
        return (Boolean)isSuccess.get();
    }

    private static void renameUsages(UsageInfo[] usages, String newName) {
        for (UsageInfo usage : usages) {
            RenameUtil.rename((UsageInfo)usage, (String)newName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 11, 15, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContainerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContainerFullName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newShortName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewContainerFullName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewContainerQualifiedName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFullText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doExtract";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewContainerFullName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNewContainerQualifiedName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassModuleQualifiedName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainerFullText";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainerText";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 11, 15, 21 -> new IllegalStateException(string);
        };
    }
}

