/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriding.RubyOverridingMethodsSearch;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class RubyIntroduceParameterProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final RMethod myMethod;
    @Nullable
    private Set<RMethod> myMethodsToChange;
    @NotNull
    private final Runnable myFixInsideMethodRunnable;
    @NotNull
    private final Function<? super ArgumentInfo.Type, ? extends RPsiElement> myArgumentToInsertCreator;
    @Nullable
    private String myArgumentName;
    @NotNull
    private ArgumentInfo.Type myType;
    @Nullable
    private Set<String> myAssocNames;

    public RubyIntroduceParameterProcessor(@NotNull Project project, @NotNull PsiElement element, @NotNull Runnable fixInsideMethodRunnable, @NotNull Function<? super ArgumentInfo.Type, ? extends RPsiElement> argumentToInsertCreator) {
        if (project == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(1);
        }
        if (fixInsideMethodRunnable == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(2);
        }
        if (argumentToInsertCreator == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(3);
        }
        super(project);
        this.myType = ArgumentInfo.Type.PREDEFINED;
        this.myFixInsideMethodRunnable = fixInsideMethodRunnable;
        this.myArgumentToInsertCreator = argumentToInsertCreator;
        this.myMethod = Objects.requireNonNull((RMethod)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class));
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(4);
        }
        return new UsageViewDescriptor(this){

            public PsiElement @NotNull [] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return RBundle.message((String)"refactoring.introduce.parameter.parameter.to.method");
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = RefactoringBundle.message((String)"references.to.be.changed", (Object[])new Object[]{""});
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> methodUsages = new ArrayList<UsageInfo>();
        for (RMethod method : this.getMethodsToChange()) {
            methodUsages.add(new RubyMethodUsageInfo(method));
        }
        methodUsages.addAll(RubyIntroduceParameterProcessor.findUsages(methodUsages, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), true));
        UsageInfo[] usageInfoArray = methodUsages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    public void setArgumentOfType(@NotNull ArgumentInfo.Type type, @NotNull String name) {
        if (type == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(6);
        }
        if (name == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(7);
        }
        this.myType = type;
        this.myArgumentName = new ArgumentInfo(name, type).getPresentableName();
    }

    public void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(8);
        }
        this.myFixInsideMethodRunnable.run();
        RubyCodeStyleSettings settings = RubyCodeStyleSettings.getInstance((PsiElement)this.myMethod);
        boolean generateParenthesesAroundArguments = settings.PARENTHESES_AROUND_METHOD_ARGUMENTS;
        ArrayList<UsageInfo> usagesToRefactor = new ArrayList<UsageInfo>(Arrays.asList(usages));
        Map<Boolean, List<UsageInfo>> methodDeclarationsOrCalls = usagesToRefactor.stream().collect(Collectors.partitioningBy(element -> element instanceof RubyMethodUsageInfo));
        Set<RMethod> methodsToChange = methodDeclarationsOrCalls.get(true).stream().map(element -> ((RubyMethodUsageInfo)((Object)element)).getMethod()).collect(Collectors.toSet());
        this.myMethodsToChange = methodsToChange;
        Map<RMethod, Integer> positionsAdded = this.processMethodDeclarations(methodsToChange, generateParenthesesAroundArguments);
        if (!this.myType.isOptional() && !this.myType.isBlock()) {
            this.insertInMethodCalls(methodDeclarationsOrCalls.get(false), positionsAdded, generateParenthesesAroundArguments);
        }
    }

    private void insertInMethodCalls(@NotNull List<UsageInfo> usages, @NotNull Map<RMethod, Integer> positionsAdded, boolean generateParenthesesAroundArguments) {
        if (usages == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(9);
        }
        if (positionsAdded == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(10);
        }
        RPsiElement value = this.myArgumentToInsertCreator.apply((ArgumentInfo.Type)this.myType);
        assert (value != null);
        for (UsageInfo usage : usages) {
            PsiReference reference = usage.getReference();
            if (reference == null) continue;
            int positionToInsert = usage instanceof UsageInfoWithMethodReference ? (Integer)ObjectUtils.notNull((Object)positionsAdded.get(((UsageInfoWithMethodReference)usage).getMethod()), (Object)Integer.MAX_VALUE) : Integer.MAX_VALUE;
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            RMethod containingMethod = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class);
            if (parent instanceof RCall) {
                if (this.getMethodsToChange().contains(containingMethod) && "super".equals(((RCall)parent).getCommand())) {
                    assert (this.myArgumentName != null);
                    RPsiElement elementToInsert = RubyElementFactoryCore.createElementFromText((PsiElement)this.myMethod, (String)this.myArgumentName);
                    RubyIntroduceParameterProcessor.addValueAtPosition((RCall)parent, elementToInsert, positionToInsert);
                    continue;
                }
                RubyIntroduceParameterProcessor.addValueAtPosition((RCall)parent, value, positionToInsert);
                continue;
            }
            if (element instanceof RPseudoConstant && "super".equals(((RPseudoConstant)element).getCommand())) {
                if (containingMethod == null || this.getMethodsToChange().contains(containingMethod)) continue;
                RArgumentList arguments = containingMethod.getArgumentList();
                RCall newCall = (RCall)RubyElementFactoryCore.createExpressionFromText((PsiElement)this.myMethod, (String)(element.getText() + RubyIntroduceParameterProcessor.wrapArg(arguments == null ? "" : arguments.getText(), generateParenthesesAroundArguments || RubyIntroduceParameterProcessor.parenthesesRequired(parent) || arguments == null)));
                RubyIntroduceParameterProcessor.addValueAtPosition(newCall, value, positionToInsert);
                element.replace((PsiElement)newCall);
                continue;
            }
            RExpression newCall = RubyElementFactoryCore.createExpressionFromText((PsiElement)this.myMethod, (String)(element.getText() + RubyIntroduceParameterProcessor.wrapArg(value.getText(), generateParenthesesAroundArguments || RubyIntroduceParameterProcessor.parenthesesRequired(parent))));
            element.replace((PsiElement)newCall);
        }
    }

    private static void addValueAtPosition(@NotNull RCall call, @NotNull RPsiElement value, int positionToInsert) {
        if (call == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(11);
        }
        if (value == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(12);
        }
        RListOfExpressions callArguments = call.getCallArguments();
        PsiElement anchor = RubyIntroduceParameterProcessor.getAnchor(callArguments, positionToInsert);
        RubyIntroduceParameterProcessor.addValueAfterAnchor(callArguments, value, anchor);
    }

    private static void addValueAfterAnchor(@NotNull RListOfExpressions arguments, @NotNull RPsiElement value, @Nullable PsiElement anchor) {
        if (arguments == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(13);
        }
        if (value == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(14);
        }
        if (value instanceof RListOfExpressions) {
            for (RPsiElement e : ((RListOfExpressions)value).getElements()) {
                anchor = arguments.addAfter((PsiElement)e, anchor);
            }
        } else {
            arguments.addAfter((PsiElement)value, anchor);
        }
    }

    @Nullable
    private static PsiElement getAnchor(@NotNull RListOfExpressions arguments, int pos) {
        if (arguments == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(15);
        }
        List elements = arguments.getElements();
        RPsiElement result = null;
        for (RPsiElement element : elements) {
            if (pos-- == 0) {
                return result;
            }
            result = element;
        }
        return result;
    }

    private Map<RMethod, Integer> processMethodDeclarations(@NotNull Set<RMethod> methodsToChange, boolean generateParenthesesAroundArguments) {
        String argumentToInsert;
        if (methodsToChange == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(16);
        }
        String string = argumentToInsert = this.myType.isOptional() ? this.myArgumentToInsertCreator.apply((ArgumentInfo.Type)this.myType).getText() : this.myArgumentName;
        assert (argumentToInsert != null);
        HashMap<RMethod, Integer> positionsAdded = new HashMap<RMethod, Integer>();
        for (RMethod method : methodsToChange) {
            int positionInThisMethod;
            this.processSuperCallsWithDefaultArguments(method, methodsToChange, generateParenthesesAroundArguments);
            RArgumentList argumentList = method.getArgumentList();
            if (argumentList != null) {
                positionInThisMethod = argumentList.addParameter(argumentToInsert, this.myType, generateParenthesesAroundArguments);
            } else {
                RMethod dummyMethod = (RMethod)RubyElementFactoryCore.createElementFromText((PsiElement)this.myMethod, (String)("def foo" + RubyIntroduceParameterProcessor.wrapArg(argumentToInsert, generateParenthesesAroundArguments) + ";end"));
                method.addAfter((PsiElement)dummyMethod.getArgumentList(), (PsiElement)method.getMethodName());
                positionInThisMethod = 0;
            }
            positionsAdded.put(method, positionInThisMethod);
        }
        return positionsAdded;
    }

    private void processSuperCallsWithDefaultArguments(@NotNull RMethod method, @NotNull Set<RMethod> methodsToChange, boolean generateParenthesesAroundArguments) {
        if (method == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(17);
        }
        if (methodsToChange == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(18);
        }
        List infos = method.getArgumentInfos();
        StringBuilder builder2 = new StringBuilder();
        for (ArgumentInfo info : infos) {
            if (!builder2.isEmpty()) {
                builder2.append(",");
            }
            if (info.getType() == ArgumentInfo.Type.PREDEFINED) {
                builder2.append(info.getName());
                continue;
            }
            ArgumentInfo.Type type = info.getType();
            if (type.isKeyword()) {
                builder2.append(info.getName()).append(": ").append(info.getName());
                continue;
            }
            builder2.append(info.getPresentableName());
        }
        String argumentsForSuperCalls = builder2.toString();
        Symbol superSymbol = (Symbol)RubySuperMethodsSearch.search(method, true).findFirst();
        if (superSymbol != null && !methodsToChange.contains(superSymbol.getPsiElement())) {
            PsiTreeUtil.findChildrenOfType((PsiElement)method.getCompoundStatement(), RPseudoConstant.class).forEach(superConstant -> {
                if ("super".equals(superConstant.getCommand()) && !(superConstant.getParent() instanceof RCall)) {
                    RCall newCall = (RCall)RubyElementFactoryCore.createExpressionFromText((PsiElement)this.myMethod, (String)(superConstant.getText() + RubyIntroduceParameterProcessor.wrapArg(argumentsForSuperCalls, generateParenthesesAroundArguments || RubyIntroduceParameterProcessor.parenthesesRequired(superConstant.getParent()) || infos.isEmpty())));
                    superConstant.replace((PsiElement)newCall);
                }
            });
        }
    }

    private static boolean parenthesesRequired(@Nullable PsiElement callParent) {
        return !(callParent instanceof RAssignmentExpression) && !(callParent instanceof RCompoundStatement);
    }

    @NotNull
    private static String wrapArg(@NotNull String name, boolean generateParenthesesAroundArguments) {
        if (name == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(19);
        }
        if (generateParenthesesAroundArguments) {
            String string = "(" + name + ")";
            if (string == null) {
                RubyIntroduceParameterProcessor.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = " " + name + " ";
        if (string == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    protected String getCommandName() {
        String string = RBundle.message((String)"refactoring.introduce.parameter.dialog.title");
        if (string == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public Set<RMethod> getMethodsToChange() {
        if (this.myMethodsToChange != null) {
            Set<RMethod> set = this.myMethodsToChange;
            if (set == null) {
                RubyIntroduceParameterProcessor.$$$reportNull$$$0(23);
            }
            return set;
        }
        this.myMethodsToChange = new LinkedHashSet<RMethod>();
        this.myMethodsToChange.add(this.myMethod);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        Processor processMethod = element -> {
            if (element != null && projectScope.contains(element.getContainingFile().getVirtualFile()) && RubyPsiUtil.isSignaturesSame(this.myMethod, (RMethod)element)) {
                this.myMethodsToChange.add((RMethod)element);
            }
            return true;
        };
        RubySuperMethodsSearch.search(this.myMethod).forEach(symbol -> symbol.getPsiElement() != null && processMethod.process((Object)symbol.getPsiElement()));
        RubyOverridingMethodsSearch.search(this.myMethod).forEach(processMethod);
        Set<RMethod> set = this.myMethodsToChange;
        if (set == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(24);
        }
        return set;
    }

    @NotNull
    public static Set<UsageInfo> findUsages(@NotNull List<? extends UsageInfo> methodUsages, @Nullable SearchScope searchScope, boolean findSuperCalls) {
        if (methodUsages == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(25);
        }
        return RubyIntroduceParameterProcessor.findUsagesImpl(methodUsages, searchScope, findSuperCalls);
    }

    @NotNull
    public static Set<UsageInfo> findUsages(@NotNull List<? extends UsageInfo> methodUsages, boolean findSuperCalls) {
        if (methodUsages == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(26);
        }
        return RubyIntroduceParameterProcessor.findUsagesImpl(methodUsages, null, findSuperCalls);
    }

    @NotNull
    private static Set<UsageInfo> findUsagesImpl(@NotNull List<? extends UsageInfo> methodUsages, @Nullable SearchScope searchScope, boolean findSuperCalls) {
        if (methodUsages == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(27);
        }
        Set<UsageInfo> usages = Collections.synchronizedSet(new HashSet());
        for (UsageInfo usageInfo : methodUsages) {
            assert (usageInfo instanceof RubyMethodUsageInfo);
            RubyMethodUsageInfo methodUsageInfo = (RubyMethodUsageInfo)usageInfo;
            RMethod method = methodUsageInfo.getMethod();
            Query query = searchScope == null ? (ApplicationManager.getApplication().isUnitTestMode() ? ReferencesSearch.search((PsiElement)method, (SearchScope)GlobalSearchScope.everythingScope((Project)method.getProject())) : ReferencesSearch.search((PsiElement)method)) : ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope);
            query.forEach(reference -> {
                PsiElement element = reference.getElement();
                if (!(element instanceof RSymbol) && !(element instanceof RAssocKey)) {
                    TextRange range = reference.getRangeInElement();
                    usages.add(new UsageInfoWithMethodReference(element, method, range.getStartOffset(), range.getEndOffset()));
                }
                return true;
            });
            if (!findSuperCalls) continue;
            RubyOverridingMethodsSearch.search(method, true).asIterable().forEach(element -> PsiTreeUtil.findChildrenOfType((PsiElement)((RMethod)element).getCompoundStatement(), RPseudoConstant.class).forEach(superConstant -> {
                if ("super".equals(superConstant.getCommand())) {
                    usages.add(new UsageInfoWithMethodReference((PsiElement)superConstant, method, -1, -1));
                }
            }));
        }
        Set<UsageInfo> set = usages;
        if (set == null) {
            RubyIntroduceParameterProcessor.$$$reportNull$$$0(28);
        }
        return set;
    }

    public static Set<UsageInfo> findUsages(List<? extends RMethod> methods) {
        ArrayList<RubyMethodUsageInfo> methodUsages = new ArrayList<RubyMethodUsageInfo>();
        for (RMethod rMethod : methods) {
            methodUsages.add(new RubyMethodUsageInfo(rMethod));
        }
        return RubyIntroduceParameterProcessor.findUsages(methodUsages, false);
    }

    public boolean hasArgumentWithName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (this.myAssocNames != null) {
            return this.myAssocNames.contains(name);
        }
        this.myAssocNames = new HashSet<String>();
        for (UsageInfo usage : this.findUsages()) {
            PsiElement element;
            PsiElement parent;
            PsiReference reference;
            if (!(usage instanceof UsageInfoWithMethodReference) || (reference = usage.getReference()) == null || !((parent = (element = reference.getElement()).getParent()) instanceof RCall)) continue;
            List arguments = ((RCall)parent).getCallArguments().getElements();
            for (RPsiElement argument : arguments) {
                if (!(argument instanceof RAssoc)) continue;
                this.myAssocNames.add(((RAssoc)argument).getKeyText());
            }
        }
        return this.myAssocNames.contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 20, 21, 22, 23, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixInsideMethodRunnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentToInsertCreator";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionsAdded";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsToChange";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapArg";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToChange";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsagesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 5: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setArgumentOfType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertInMethodCalls";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addValueAtPosition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addValueAfterAnchor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processMethodDeclarations";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processSuperCallsWithDefaultArguments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "wrapArg";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 20, 21, 22, 23, 24, 28 -> new IllegalStateException(string);
        };
    }

    public static final class RubyMethodUsageInfo
    extends UsageInfoWithMethodReference {
        private RubyMethodUsageInfo(@NotNull RMethod method) {
            if (method == null) {
                RubyMethodUsageInfo.$$$reportNull$$$0(0);
            }
            super((PsiElement)method, method, -1, -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterProcessor$RubyMethodUsageInfo", "<init>"));
        }
    }

    public static class UsageInfoWithMethodReference
    extends UsageInfo {
        @NotNull
        private final RMethod myMethod;

        private UsageInfoWithMethodReference(@NotNull PsiElement element, @NotNull RMethod method, int startOffset, int endOffset) {
            if (element == null) {
                UsageInfoWithMethodReference.$$$reportNull$$$0(0);
            }
            if (method == null) {
                UsageInfoWithMethodReference.$$$reportNull$$$0(1);
            }
            super(element, startOffset, endOffset);
            this.myMethod = method;
        }

        @NotNull
        public RMethod getMethod() {
            RMethod rMethod = this.myMethod;
            if (rMethod == null) {
                UsageInfoWithMethodReference.$$$reportNull$$$0(2);
            }
            return rMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterProcessor$UsageInfoWithMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterProcessor$UsageInfoWithMethodReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

