/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.RefactoringDialog;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterProcessor;

public class RubyIntroduceParameterDialog
extends RefactoringDialog {
    private final MyRubyIntroduceDialog myRubyIntroduceDialog;
    private final RubyIntroduceParameterProcessor myProcessor;
    private Map<String, ArgumentInfo.Type> myArgumentTypeOptions;

    public RubyIntroduceParameterDialog(Project project, PsiElement element, List<PsiElement> occurrences, IntroduceValidator validator, String[] suggestedNames, Runnable fixInsideMethodRunnable, Function<ArgumentInfo.Type, RPsiElement> argumentToInsertCreator, List<ArgumentInfo.Type> allowedTypes) {
        super(project, true);
        this.setTitle(RBundle.message((String)"refactoring.introduce.parameter.dialog.title"));
        this.myProcessor = new RubyIntroduceParameterProcessor(project, element, fixInsideMethodRunnable, argumentToInsertCreator);
        this.setArgumentTypeOptions(allowedTypes);
        this.myRubyIntroduceDialog = new MyRubyIntroduceDialog(project, occurrences, validator, suggestedNames);
        this.myRubyIntroduceDialog.setModal(false);
        this.setModal(true);
        this.init();
        this.validateButtons();
    }

    @NotNull
    public String getName() {
        String string = Objects.requireNonNull(this.myRubyIntroduceDialog.getName());
        if (string == null) {
            RubyIntroduceParameterDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public ArgumentInfo.Type getType() {
        if (this.myRubyIntroduceDialog == null) {
            return null;
        }
        Object type = this.myRubyIntroduceDialog.getType();
        if (type instanceof String) {
            return this.myArgumentTypeOptions.get((String)type);
        }
        return null;
    }

    public boolean doReplaceAllOccurrences() {
        return this.myRubyIntroduceDialog.doReplaceAllOccurrences();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRubyIntroduceDialog.getPreferredFocusedComponent();
    }

    protected String getHelpId() {
        return "refactoring.introduceParameter";
    }

    protected void doAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        this.myProcessor.setArgumentOfType(this.getType(), this.getName());
        this.invokeRefactoring(this.myProcessor);
    }

    protected JComponent createCenterPanel() {
        return this.myRubyIntroduceDialog.createCenterPanel();
    }

    protected boolean areButtonsValid() {
        return this.myRubyIntroduceDialog != null && this.myRubyIntroduceDialog.isOKActionEnabled();
    }

    private void setArgumentTypeOptions(@NotNull List<ArgumentInfo.Type> allowedTypes) {
        if (allowedTypes == null) {
            RubyIntroduceParameterDialog.$$$reportNull$$$0(1);
        }
        this.myArgumentTypeOptions = new LinkedHashMap<String, ArgumentInfo.Type>();
        for (ArgumentInfo.Type type : allowedTypes) {
            this.myArgumentTypeOptions.put(new ArgumentInfo("param", type).getPresentableName(), type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setArgumentTypeOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private final class MyRubyIntroduceDialog
    extends RubyIntroduceDialog {
        private MyRubyIntroduceDialog(Project project, List<PsiElement> occurrences, IntroduceValidator validator, String[] suggestedNames) {
            super(project, RubyIntroduceParameterDialog.this.getTitle(), RubyIntroduceParameterDialog.this.getHelpId(), occurrences.size(), validator, suggestedNames);
            this.setTypePanelVisible(true);
            this.setUpTypeComboBox(RubyIntroduceParameterDialog.this.myArgumentTypeOptions.keySet());
        }

        @Override
        protected void updateControls() {
            super.updateControls();
            this.checkTypeAvailable();
            RubyIntroduceParameterDialog.this.validateButtons();
        }

        @Override
        protected void checkTypeAvailable() {
            if (this.hasError() && !RBundle.message((String)"refactoring.introduce.named.parameter.error").equals(this.getError())) {
                return;
            }
            ArgumentInfo.Type type = RubyIntroduceParameterDialog.this.getType();
            boolean typeValid = true;
            String message = " ";
            if (type != null && type.isKeyword()) {
                boolean bl = typeValid = !RubyIntroduceParameterDialog.this.myProcessor.hasArgumentWithName(this.getName());
            }
            if (!typeValid) {
                message = RBundle.message((String)"refactoring.introduce.named.parameter.error");
            }
            this.setOKActionEnabled(typeValid);
            this.setError(message);
            RubyIntroduceParameterDialog.this.validateButtons();
        }

        @Override
        protected JComponent createCenterPanel() {
            return super.createCenterPanel();
        }
    }
}

