/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.field;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Processor;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementElement;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyIntroduceFieldHandler
extends RubyIntroduceHandlerBase {
    @NotNull
    public static final String HELP_ID = "refactoring.introduceField";

    @Override
    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getTitle() {
        return RefactoringBundle.message((String)"introduce.field.title");
    }

    @Override
    protected String getFeatureID() {
        return HELP_ID;
    }

    @Override
    protected IntroduceValidator createValidator(PsiElement element, List<PsiElement> occurrences) {
        return new MyValidator(element, occurrences);
    }

    @Override
    protected RPsiElement getSearchScope(PsiElement expression) {
        return RefactoringPsiHelper.getClassOrModuleOrFile(expression);
    }

    @Override
    protected List<String> getSuggestedNames(PsiElement expression, IntroduceValidator validator) {
        ArrayList<String> instanceResult = new ArrayList<String>();
        ArrayList<String> classResult = new ArrayList<String>();
        ArrayList<String> suggestedNames = new ArrayList<String>(Arrays.asList(NamesSuggestor.getSuggestedNames(expression)));
        if (suggestedNames.isEmpty()) {
            suggestedNames.add(this.getDefaultName());
        }
        String instancePrefix = "@";
        String classPrefix = "@@";
        for (String name : suggestedNames) {
            String iVarName = instancePrefix + name;
            String cVarName = classPrefix + name;
            if (validator.checkPossibleName(iVarName) == null) {
                instanceResult.add(iVarName);
            }
            if (validator.checkPossibleName(cVarName) != null) continue;
            classResult.add(cVarName);
        }
        RubyIntroduceFieldHandler.fillSuggestedNamesIfEmpty(validator, instanceResult, instancePrefix + (String)suggestedNames.get(0));
        RubyIntroduceFieldHandler.fillSuggestedNamesIfEmpty(validator, classResult, classPrefix + (String)suggestedNames.get(0));
        instanceResult.addAll(classResult);
        return instanceResult;
    }

    private static void fillSuggestedNamesIfEmpty(@NotNull IntroduceValidator validator, @NotNull List<String> result, @NotNull String name) {
        if (validator == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        if (!result.isEmpty()) {
            return;
        }
        int i = 0;
        Object possibleName = name;
        while (validator.checkPossibleName((String)possibleName) != null) {
            possibleName = name + ++i;
        }
        result.add((String)possibleName);
    }

    @Override
    protected PsiElement insertDeclaration(String name, PsiElement declaration, PsiElement expression, List<PsiElement> occurrences, boolean replaceAll) {
        PsiElement element;
        if (name.startsWith("@@")) {
            return RubyIntroduceFieldHandler.insertDeclaration(declaration, expression);
        }
        BiFunction<RCompoundStatement, RCompoundStatement, RCompoundStatement> bodyProducer = !replaceAll || occurrences.isEmpty() ? RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER : (!(PsiTreeUtil.getParentOfType((PsiElement)(element = occurrences.get(0)), RFieldHolder.class) instanceof RNamespace) || ContextImpl.getContext(element).getAccess() == Access.CLASS ? RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER : ConstructorSelector.INSTANCE);
        return RubyIntroduceVariableHandler.insertDeclaration(declaration, expression, occurrences, replaceAll, bodyProducer);
    }

    @Override
    public void performAction(Project project, Editor editor, PsiFile file, @Nullable String name, boolean replaceAll, int position) {
        RIdentifier identifier;
        PsiElement element1;
        PsiElement element2;
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            element1 = element2 = file.findElementAt(editor.getCaretModel().getOffset());
        } else {
            Pair<PsiElement, PsiElement> elements = RefactoringPsiHelper.getSelectedElements(editor, file);
            element1 = (PsiElement)elements.first;
            element2 = (PsiElement)elements.second;
        }
        if (element1 == null || element2 == null || !RubyPsiUtilCore.isBefore((PsiElement)element1, (PsiElement)element2) || element1.getParent() instanceof RInstanceVariable) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.selection.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        if (element1 == element2 && (identifier = (RIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element1, RIdentifier.class)) != null) {
            if (identifier.isMethodParameterDeclaration()) {
                this.performActionOnMethodParameter(project, editor, identifier, name, replaceAll);
                return;
            }
            if (identifier.getUseScope() instanceof LocalSearchScope) {
                LinkedHashSet<CallSite> nameSet = new LinkedHashSet<CallSite>();
                nameSet.add((CallSite)((Object)("@" + identifier.getName())));
                new VariableInplaceRenamer((PsiNamedElement)identifier, editor).performInplaceRefactoring(nameSet);
                return;
            }
        }
        super.performAction(project, editor, file, name, replaceAll, position);
    }

    private void performActionOnMethodParameter(@NotNull Project project, @NotNull Editor editor, @NotNull RIdentifier identifier, @Nullable String name, boolean replaceAll) {
        if (project == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(5);
        }
        RPsiElement scope = this.getSearchScope((PsiElement)identifier);
        List<PsiElement> occurrences = RubyRefactoringUtil.getOccurrences((RPsiElement)identifier, scope);
        this.getParametersAndPerformRefactoring(project, (PsiElement)identifier, occurrences, name, replaceAll, (TriConsumer<? super String, ? super Boolean, ? super LanguageLevel>)((TriConsumer)(newName, replaceChoice, languageLevel) -> {
            RubyReplacementElement replacement = new RubyReplacementElement((PsiElement)identifier, (RPsiElement)identifier, this.getSearchScope((PsiElement)identifier));
            if (replacement.getExpression() == null) {
                return;
            }
            RExpression declaration = this.createDeclaration(project, replacement, (String)newName, (LanguageLevel)languageLevel, this.isSplatAllowed());
            if (declaration == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.variable.changed.error"), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> RubyIntroduceFieldHandler.performReplaceParameterAndUsages(project, declaration, identifier, newName, occurrences, replaceChoice))), this.getTitle(), null);
        }));
    }

    private static void performReplaceParameterAndUsages(@NotNull Project project, @NotNull RExpression declaration, @NotNull RIdentifier identifier, @NotNull String name, @NotNull List<PsiElement> occurrences, boolean replaceAll) {
        if (project == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(6);
        }
        if (declaration == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(7);
        }
        if (identifier == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(8);
        }
        if (name == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(9);
        }
        if (occurrences == null) {
            RubyIntroduceFieldHandler.$$$reportNull$$$0(10);
        }
        RContainer container = identifier.getParentContainer();
        assert (container != null);
        List statements = container.getStatements();
        if (statements.isEmpty()) {
            container.getCompoundStatement().add((PsiElement)declaration);
        } else {
            RPsiElement first = (RPsiElement)statements.get(0);
            first.getParent().addBefore((PsiElement)declaration, (PsiElement)first);
        }
        if (replaceAll) {
            for (PsiElement occurrence : occurrences) {
                RefactoringPsiHelper.replaceExpressionWithText(project, occurrence, name);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/field/RubyIntroduceFieldHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillSuggestedNamesIfEmpty";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performActionOnMethodParameter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "performReplaceParameterAndUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyValidator
    extends IntroduceValidator {
        private final Symbol mySymbol;
        private Set<String> myProhibitedNames;

        MyValidator(PsiElement element, List<PsiElement> occurrences) {
            super(element, occurrences);
            RContainer container = RefactoringPsiHelper.getClassOrModuleOrFile(element);
            this.mySymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
            assert (this.mySymbol != null);
        }

        @Override
        @NlsContexts.Label
        public String check(RubyIntroduceSettings settings) {
            boolean instanceFound = false;
            boolean staticFound = false;
            if (settings.doReplaceAllOccurrences()) {
                for (PsiElement occurrence : this.myOccurrences) {
                    Access access = ContextImpl.getContext(occurrence).getAccess();
                    instanceFound |= access == Access.INSTANCE;
                    staticFound |= access == Access.CLASS;
                }
            } else {
                Access access = ContextImpl.getContext(this.myElement).getAccess();
                instanceFound = access == Access.INSTANCE;
                boolean bl = staticFound = access == Access.CLASS;
            }
            if (instanceFound && staticFound) {
                return RBundle.message((String)"refactoring.introduce.field.context.error");
            }
            String name = settings.getName();
            if (staticFound && name.startsWith("@@")) {
                return RBundle.message((String)"refactoring.introduce.field.class.context.error");
            }
            return this.checkPossibleName(name);
        }

        @Override
        public boolean isNameValid(String name) {
            return name != null && TextUtil.isField((String)name);
        }

        @Override
        @NlsContexts.Label
        public String checkPossibleName(String name) {
            if (this.myProhibitedNames == null) {
                this.myProhibitedNames = new HashSet<String>();
                SymbolUtil.processMembers(this.mySymbol, (Predicate<? super Symbol>)Symbol.Filter.byTypes((TypeSet)Types.FIELDS), this.myElement, (Processor<? super Symbol>)((Processor)member -> {
                    String fieldName = (member.getType() == Type.CLASS_FIELD ? "@@" : "@") + member.getName();
                    this.myProhibitedNames.add(fieldName);
                    return true;
                }));
            }
            return this.myProhibitedNames.contains(name) ? RBundle.message((String)"refactoring.introduce.field.scope.error") : null;
        }
    }

    private static class ConstructorSelector
    implements BiFunction<RCompoundStatement, RCompoundStatement, RCompoundStatement> {
        private static final ConstructorSelector INSTANCE = new ConstructorSelector();

        private ConstructorSelector() {
        }

        @Override
        public RCompoundStatement apply(RCompoundStatement body1, RCompoundStatement body2) {
            RMethod method1 = RubyPsiUtil.getContainingRMethod((PsiElement)body1);
            RMethod method2 = RubyPsiUtil.getContainingRMethod((PsiElement)body2);
            if (method1 == null || method2 == null || method1 == method2) {
                return RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER.apply(body1, body2);
            }
            if (method1.isConstructor()) {
                return method1.getCompoundStatement();
            }
            if (method2.isConstructor()) {
                return method2.getCompoundStatement();
            }
            RContainer classModule = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)method1);
            if (classModule instanceof RClass) {
                RPsiStructureElement constructor = (RPsiStructureElement)ContainerUtil.find((Iterable)classModule.getStructureElements(), element -> element instanceof RMethod && ((RMethod)element).isConstructor());
                if (constructor == null) {
                    constructor = ConstructorSelector.generateConstructor(classModule);
                }
                return ((RMethod)constructor).getCompoundStatement();
            }
            return RubyPsiUtilCore.isBefore((PsiElement)method1, (PsiElement)method2) ? method1.getCompoundStatement() : method2.getCompoundStatement();
        }

        @NotNull
        private static RMethod generateConstructor(RContainer clazz) {
            RMethod method = (RMethod)RubyElementFactoryCore.createElementFromText((PsiElement)clazz, (String)"def initialize\nend");
            Optional<RPsiStructureElement> firstMethod = clazz.getStructureElements().stream().filter(element -> element instanceof RMethod).min(Comparator.comparingInt(PsiElement::getTextOffset));
            assert (firstMethod.isPresent());
            RMethod rMethod = (RMethod)clazz.getCompoundStatement().addBefore((PsiElement)method, (PsiElement)firstMethod.get());
            if (rMethod == null) {
                ConstructorSelector.$$$reportNull$$$0(0);
            }
            return rMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/field/RubyIntroduceFieldHandler$ConstructorSelector", "generateConstructor"));
        }
    }
}

