/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.constant;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;

public class RubyIntroduceConstantHandler
extends RubyIntroduceHandlerBase {
    @NotNull
    public static final String HELP_ID = "refactoring.introduceConstant";

    @Override
    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    protected String getTitle() {
        return RefactoringBundle.message((String)"introduce.constant.title");
    }

    @Override
    protected String getFeatureID() {
        return HELP_ID;
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        return "CONST";
    }

    @Override
    protected IntroduceValidator createValidator(PsiElement element, List<PsiElement> occurrences) {
        return new MyValidator(element, occurrences);
    }

    @Override
    @Nullable
    protected RPsiElement getSearchScope(PsiElement expression) {
        return RefactoringPsiHelper.getClassOrModuleOrFile(expression);
    }

    @Override
    protected List<String> getSuggestedNames(PsiElement expression, IntroduceValidator validator) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : NamesSuggestor.getSuggestedNames(expression)) {
            String upcase = StringUtil.toUpperCase((String)name);
            if (validator.checkPossibleName(upcase) != null) continue;
            result.add(upcase);
        }
        return result;
    }

    @Override
    protected PsiElement insertDeclaration(String name, PsiElement declaration, PsiElement expression, List<PsiElement> occurrences, boolean replaceAll) {
        Pair<RCompoundStatement, RPsiElement> place = RubyIntroduceVariableHandler.getPlaceForDeclaration(expression, occurrences, replaceAll, RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER);
        PsiElement parent = (PsiElement)place.first;
        PsiElement anchor = (PsiElement)place.second;
        PsiElement nextAnchor = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{RMethod.class, RConditionalStatement.class});
        while (nextAnchor != null) {
            anchor = nextAnchor;
            parent = anchor.getParent();
            nextAnchor = PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{RMethod.class, RConditionalStatement.class, RCall.class});
        }
        assert (parent != null);
        return parent.addBefore(declaration, anchor);
    }

    private static class MyValidator
    extends IntroduceValidator {
        private Set<String> myProhibitedNames;
        @Nullable
        private final Symbol mySymbol;
        @Nullable
        private final RContainer myContainer;

        protected MyValidator(PsiElement element, List<PsiElement> occurrences) {
            super(element, occurrences);
            this.myContainer = RefactoringPsiHelper.getClassOrModuleOrFile(element);
            this.mySymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)this.myContainer);
        }

        @Override
        public String check(RubyIntroduceSettings settings) {
            return this.checkPossibleName(settings.getName());
        }

        @Override
        @NlsContexts.Label
        @Nullable
        public String checkPossibleName(String name) {
            if (this.myProhibitedNames == null) {
                this.myProhibitedNames = new HashSet<String>();
                Symbol symbol = this.mySymbol;
                if (symbol != null && this.myContainer != null) {
                    Symbol.Filter filter = Symbol.Filter.byTypes((TypeSet)Types.MODULE_OR_CLASS_OR_CONSTANT);
                    SymbolUtil.processMembersWithNesting(symbol, (RPsiElement)this.myContainer, (Predicate<? super Symbol>)filter, this.myElement, (Processor<? super Symbol>)((Processor)member -> {
                        this.myProhibitedNames.add(member.getName());
                        return true;
                    }));
                    while (symbol != null) {
                        this.myProhibitedNames.add(symbol.getName());
                        symbol = symbol.getParentSymbol();
                    }
                }
            }
            return this.myProhibitedNames.contains(name) ? RBundle.message((String)"refactoring.introduce.constant.scope.error") : null;
        }

        @Override
        public boolean isNameValid(String name) {
            return name != null && !RubyRefactoringUtil.KEYWORDS.contains(name) && TextUtil.isConstId((String)name);
        }
    }
}

