/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RemoveReturnFix;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyUnnecessaryReturnStatementInspection;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RSingletonMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterProcessor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyInlineMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(RubyInlineMethodProcessor.class);
    private static final String SUPER_CALL = RubyTokenTypes.kSUPER.toString();
    public static final String HELP_ID = "refactoring.inlineMethod";
    private final RMethod myMethod;
    private final Editor myEditor;
    private final String myDescriptiveName;
    private final PsiReference myReference;
    private final boolean myInvokeThisOnly;
    private static final Key<String> FQN_TRANSFORMATION_KEY = Key.create((String)"ruby.inline.method.fqn.transformation");
    private static final Key<Set<String>> FQN_INCLUDE_KEY = Key.create((String)"ruby.inline.method.include.transformation");

    public RubyInlineMethodProcessor(Project project, Editor editor, RMethod method, PsiReference reference, boolean invokeThisOnly) {
        super(project);
        this.myMethod = method;
        this.myEditor = editor;
        this.myReference = reference;
        this.myInvokeThisOnly = invokeThisOnly;
        this.myDescriptiveName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myMethod);
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{this.myDescriptiveName});
        if (string == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(1);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{RubyInlineMethodProcessor.this.myMethod};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)"all.invocations.in.project");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = RubyInlineMethodProcessor.findUsages(this.myMethod, this.myReference, this.myInvokeThisOnly);
        if (usageInfoArray == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(3);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        RubyInlineMethodProcessor.inspectUsages(this.myMethod, (MultiMap<PsiElement, String>)conflicts, usagesIn);
        return this.showConflicts(conflicts, usagesIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(4);
        }
        int col = -1;
        int line = -1;
        if (this.myEditor != null) {
            col = this.myEditor.getCaretModel().getLogicalPosition().column;
            line = this.myEditor.getCaretModel().getLogicalPosition().line;
            LogicalPosition pos = new LogicalPosition(0, 0);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
        LocalHistoryAction action = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        finally {
            action.finish();
        }
        if (this.myEditor != null) {
            LogicalPosition pos = new LogicalPosition(line, col);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
    }

    private void doRefactoring(UsageInfo[] usages) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed(RubyInlineMethodProcessor.getFeatureId());
        RubyInlineMethodProcessor.invoke(this.myProject, this.myMethod, this.myInvokeThisOnly, usages);
    }

    private static String getFeatureId() {
        return HELP_ID;
    }

    public static void invoke(@NotNull Project project, @NotNull RMethod method, boolean inlineThisOnly, UsageInfo @NotNull [] usages) {
        if (project == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(5);
        }
        if (method == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(6);
        }
        if (usages == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(7);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.info("Fix all the usages include super calls");
            }
            for (UsageInfo usage : usages) {
                String methodText;
                RContainer container;
                RCall call;
                RPsiElement element = (RPsiElement)usage.getElement();
                if (element == null) continue;
                boolean qualifiedCall = RubyInlineMethodProcessor.isQualifiedCall((PsiElement)element);
                RPsiElement receiver = null;
                if (qualifiedCall) {
                    receiver = ((RReference)element).getReceiver();
                }
                if ((call = RCallNavigator.getByCommand((PsiElement)element)) != null) {
                    element = call;
                }
                if ((container = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)element)) == null) {
                    container = RubyPsiUtil.getRFile((PsiElement)element);
                }
                if (qualifiedCall) {
                    Set data = (Set)method.getUserData(FQN_INCLUDE_KEY);
                    assert (data != null) : "fqn data should be initialized before inspecting all the references";
                    for (String fqn : data) {
                        RubyPsiUtil.addIncludeFQNCall(container, fqn);
                    }
                }
                if (RubyInlineMethodProcessor.updateReference(project, methodText = RubyInlineMethodProcessor.prepareMethodForInline(project, method, receiver, qualifiedCall), element)) continue;
                return;
            }
            method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    element.putUserData(FQN_TRANSFORMATION_KEY, null);
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$2", "visitElement"));
                }
            });
            method.putUserData(FQN_INCLUDE_KEY, null);
            if (!inlineThisOnly) {
                List comments;
                if (LOG.isDebugEnabled()) {
                    LOG.info("Removing method with comments");
                }
                if (!(comments = RubyCommentsUtilCore.getPsiComments((PsiElement)method)).isEmpty()) {
                    PsiElement firstElement2remove = (PsiElement)comments.get(0);
                    PsiElement lastElement2remove = ((PsiComment)comments.get(comments.size() - 1)).getNextSibling();
                    firstElement2remove.getParent().deleteChildRange(firstElement2remove, lastElement2remove);
                }
                method.delete();
            }
        }), RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{method.getName()}), null);
    }

    private static boolean isQualifiedCall(PsiElement element) {
        if (!(element instanceof RReference)) {
            return false;
        }
        RPsiElement receiver = ((RReference)element).getReceiver();
        return receiver != null && !RubyTokenTypes.kSUPER.toString().equals(receiver.getName());
    }

    private static String prepareMethodForInline(@NotNull Project project, @NotNull RMethod method, @Nullable RPsiElement receiver, boolean qualifiedCall) {
        String methodText;
        if (project == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(8);
        }
        if (method == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(9);
        }
        final String replacement = RubyInlineMethodProcessor.getReplacement(method, receiver);
        if (qualifiedCall) {
            final StringBuilder builder2 = new StringBuilder();
            method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (replacement != null && element instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(element.getText())) {
                        builder2.append(replacement);
                        return;
                    }
                    Object data = (String)element.getUserData(FQN_TRANSFORMATION_KEY);
                    if (data != null) {
                        if (replacement != null && "self".equals(data)) {
                            data = replacement + "." + element.getText();
                        }
                        builder2.append((String)data);
                        return;
                    }
                    if (element instanceof LeafPsiElement) {
                        builder2.append(element.getText());
                        return;
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$3", "visitElement"));
                }
            });
            methodText = builder2.toString();
        } else {
            methodText = method.getText();
        }
        RMethod methodToInline = (RMethod)RubyElementFactoryCore.createElementFromText((Project)project, (String)methodText, (LanguageLevel)method.getLanguageLevel());
        if (replacement != null && !receiver.getText().equals(replacement)) {
            methodToInline.getCompoundStatement().addBefore((PsiElement)RubyElementFactoryCore.createExpressionFromText((PsiElement)method, (String)(replacement + " = " + receiver.getText())), methodToInline.getCompoundStatement().getFirstChild());
        }
        for (RReturnStatement returnStatement : RubyUnnecessaryReturnStatementInspection.inspectMethod(methodToInline, true)) {
            ApplicationManager.getApplication().runWriteAction(() -> RemoveReturnFix.removeUnnecessaryReturn(returnStatement));
        }
        return methodToInline.getText();
    }

    private static String getReplacement(@NotNull RMethod method, @Nullable RPsiElement receiver) {
        Object replacement;
        if (method == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(10);
        }
        if (receiver == null) {
            return null;
        }
        boolean isConstantReceiver = false;
        final Ref instanceCallNumber = new Ref((Object)0);
        if (RubyPsiUtil.isConstantValue((PsiElement)receiver) || receiver instanceof RField) {
            replacement = receiver.getText();
            isConstantReceiver = true;
        } else {
            String[] suggested = NamesSuggestor.getSuggestedNames((PsiElement)receiver);
            String initReplacement = suggested.length != 0 ? suggested[0] : "new_object";
            replacement = initReplacement;
            List<String> variables = ScopeUtil.collectAllScopeVariableNames(method.getScope());
            int i = 1;
            while (((String)replacement).equals(receiver.getName()) || variables.contains(replacement)) {
                replacement = initReplacement + i;
                ++i;
            }
        }
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (element instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(element.getText()) || "self".equals(element.getUserData(FQN_TRANSFORMATION_KEY))) {
                    instanceCallNumber.set((Object)((Integer)instanceCallNumber.get() + 1));
                    return;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$4", "visitElement"));
            }
        });
        boolean hasMultipleCalls = (Integer)instanceCallNumber.get() > 1;
        return hasMultipleCalls && !isConstantReceiver ? replacement : receiver.getText();
    }

    public static UsageInfo[] findUsages(RMethod method, PsiReference reference, boolean inlineThisOnly) {
        ArrayList<UsageInfo> references2fix = new ArrayList<UsageInfo>();
        if (inlineThisOnly) {
            references2fix.add(new UsageInfo(reference.getElement()));
        } else {
            Set<UsageInfo> referenceUsages = RubyIntroduceParameterProcessor.findUsages(Collections.singletonList(method));
            if (LOG.isDebugEnabled()) {
                LOG.info("References Found: " + referenceUsages.size());
            }
            references2fix.addAll(referenceUsages);
        }
        Collection<RContainer> overridingElements = RubyOverrideImplementUtil.getOverridingElements((RContainer)method);
        if (LOG.isDebugEnabled()) {
            LOG.info("Overriding Methods Found: " + overridingElements.size());
        }
        for (RContainer element : overridingElements) {
            List statements = element.getCompoundStatement().getStatements();
            if (statements.isEmpty()) continue;
            RPsiElement statement = (RPsiElement)statements.get(0);
            if (statement instanceof RIdentifier && SUPER_CALL.equals(statement.getText())) {
                references2fix.add(new UsageInfo((PsiElement)statement));
                continue;
            }
            if (!(statement instanceof RCall) || !SUPER_CALL.equals(((RCall)statement).getCommand())) continue;
            references2fix.add(new UsageInfo((PsiElement)statement));
        }
        return references2fix.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static boolean updateReference(@NotNull Project project, @NotNull String methodText, @NotNull RPsiElement element) {
        Scope scope;
        if (project == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(11);
        }
        if (methodText == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(12);
        }
        if (element == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(13);
        }
        LOG.assertTrue((scope = ScopeUtilCore.getScope((RPsiElement)element)) != null, (Object)"Null scope is not expected here");
        final HashSet<String> reservedLocalNames = new HashSet<String>(ScopeUtil.collectScopeVariableNames((PsiElement)element));
        if (element instanceof RCall) {
            RubyInlineMethodProcessor.extractAssignmentParameters((RCall)element);
        }
        LanguageLevel languageLevel = element.getLanguageLevel();
        final RMethod method = (RMethod)RubyElementFactoryCore.createElementFromText((Project)project, (String)methodText, (LanguageLevel)languageLevel);
        final HashMap<String, String> renameMap = new HashMap<String, String>();
        final Consumer<String> rename = name -> {
            int i = 1;
            while (reservedLocalNames.contains(name + i)) {
                ++i;
            }
            renameMap.put((String)name, name + i);
            reservedLocalNames.add(name + i);
        };
        for (String string : ScopeUtil.collectAllScopeVariableNames(method.getScope())) {
            if (!reservedLocalNames.contains(string)) continue;
            rename.accept(string);
        }
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
                String name;
                if (rIdentifier == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (rIdentifier.isBlockParameterDeclaration() && RubyPsiUtilCore.getParentContainer((PsiElement)rIdentifier) == method && !renameMap.containsKey(name = rIdentifier.getName()) && reservedLocalNames.contains(name)) {
                    rename.accept(name);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rIdentifier", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$5", "visitRIdentifier"));
            }
        });
        final HashSet<Pair> identifiers2rename = new HashSet<Pair>();
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRIdentifier(@NotNull RIdentifier identifier) {
                if (identifier == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (RubyPsiUtilCore.getParentContainer((PsiElement)identifier) != method || identifier.getParent() instanceof RReference && ((RReference)identifier.getParent()).getValue() == identifier) {
                    return;
                }
                String name = identifier.getName();
                if (renameMap.containsKey(name)) {
                    identifiers2rename.add(Pair.create((Object)identifier, (Object)((String)renameMap.get(name))));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$6", "visitRIdentifier"));
            }
        });
        if (element instanceof RCall) {
            for (RPsiElement rPsiElement : ((RCall)element).getCallArguments().getElements()) {
                String name2;
                if (!(rPsiElement instanceof RAssoc) || !renameMap.containsKey(name2 = ((RAssoc)rPsiElement).getKeyText())) continue;
                identifiers2rename.add(Pair.create((Object)((PsiNamedElement)((RAssoc)rPsiElement).getKey()), (Object)((String)renameMap.get(name2))));
            }
        }
        for (Pair pair : identifiers2rename) {
            ((PsiNamedElement)pair.first).setName((String)pair.second);
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (PsiElement assignment : RubyInlineMethodProcessor.inlineAndInitializeArguments(project, element, languageLevel, method, renameMap)) {
            arrayList.add(assignment.getNode());
            arrayList.add(RubyElementFactoryCore.createNewLine((PsiElement)element).getNode());
        }
        List list = method.getCompoundStatement().getStatements();
        RPsiElement elementStatement = RubyPsiUtilCore.getStatement((PsiElement)element);
        Object expressionName = method.getName() + "_value";
        if (reservedLocalNames.contains(expressionName)) {
            rename.accept((String)expressionName);
            expressionName = (String)renameMap.get(expressionName);
        }
        if (elementStatement != element && list.size() > 1) {
            RPsiElement lastStatement = (RPsiElement)list.get(list.size() - 1);
            lastStatement.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)((String)expressionName + " = " + lastStatement.getText()), (LanguageLevel)languageLevel));
        }
        ASTNode compoundStatementNode = RubyPsiUtilCore.getCompoundStatement((PsiElement)element).getNode();
        ASTNode elementStatementNode = elementStatement.getNode();
        if (!arrayList.isEmpty()) {
            for (ASTNode node : arrayList) {
                compoundStatementNode.addChild(node, elementStatementNode);
            }
        }
        if (elementStatement == element) {
            for (ASTNode node : method.getCompoundStatement().getNode().getChildren(null)) {
                compoundStatementNode.addChild(node, elementStatementNode);
            }
            RubyInlineMethodProcessor.removePreviousElement((PsiElement)element);
            element.delete();
        } else if (list.isEmpty()) {
            element.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)RubyTokenTypesCore.kNIL.toString(), (LanguageLevel)languageLevel));
        } else if (list.size() == 1) {
            if (RubyReplaceExpressionUtil.isNeedParenthesis(element, (RPsiElement)list.get(0))) {
                element.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)("(" + ((RPsiElement)list.get(0)).getText() + ")"), (LanguageLevel)languageLevel));
            } else {
                element.replace((PsiElement)list.get(0));
            }
        } else {
            for (ASTNode node : method.getCompoundStatement().getNode().getChildren(null)) {
                compoundStatementNode.addChild(node, elementStatementNode);
            }
            compoundStatementNode.addChild(RubyElementFactoryCore.createNewLine((PsiElement)element).getNode(), elementStatementNode);
            element.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)expressionName, (LanguageLevel)languageLevel));
        }
        return true;
    }

    private static void extractAssignmentParameters(@NotNull RCall call) {
        if (call == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(14);
        }
        for (RPsiElement argument : call.getCallArguments().getElements()) {
            RPsiElement value;
            if (!(argument instanceof RAssignmentExpression) || (value = ((RAssignmentExpression)argument).getValue()) == null) continue;
            RubyIntroduceVariableHandler.insertDeclaration((PsiElement)argument, (PsiElement)call, null, false, RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER);
            argument.replace((PsiElement)value);
        }
    }

    private static void removePreviousElement(PsiElement element) {
        PsiElement sibling = element.getPrevSibling();
        if (RubySpaceUtil.isEol((PsiElement)sibling)) {
            sibling.delete();
        }
    }

    private static List<PsiElement> inlineAndInitializeArguments(Project project, RPsiElement element, LanguageLevel languageLevel, RMethod method, Map<String, String> renameMap) {
        ArrayList<PsiElement> argumentInitializers = new ArrayList<PsiElement>();
        List callArguments = element instanceof RCall ? ((RCall)element).getArguments() : Collections.emptyList();
        List methodArguments = method.getArguments();
        int callArgumentIndex = 0;
        for (int argumentIndex = 0; argumentIndex < methodArguments.size(); ++argumentIndex) {
            StringBuilder builder2;
            RArgument argument = (RArgument)methodArguments.get(argumentIndex);
            ArgumentInfo.Type type = argument.getType();
            if (type.isPositional() || type.isKeyword()) {
                builder2 = new StringBuilder();
                if (callArgumentIndex < callArguments.size()) {
                    if (callArguments.get(callArgumentIndex) instanceof RArrayToArguments) {
                        RubyInlineMethodProcessor.addRestOfCallArgsAndParameters(builder2, methodArguments, argumentIndex, callArguments, callArgumentIndex);
                        argumentIndex = methodArguments.size();
                        argumentInitializers.add((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)builder2.toString(), (LanguageLevel)languageLevel));
                        continue;
                    }
                    Ref matchCallArgument = new Ref((Object)true);
                    if (RubyInlineMethodProcessor.tryToInlineArgument(method, argument.getName(), (PsiElement)callArguments.get(callArgumentIndex), renameMap, (Ref<Boolean>)matchCallArgument)) {
                        if (!((Boolean)matchCallArgument.get()).booleanValue()) continue;
                        ++callArgumentIndex;
                        continue;
                    }
                    builder2.append(argument.getName()).append(" = ").append(((RPsiElement)callArguments.get(callArgumentIndex)).getText());
                    argumentInitializers.add((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)builder2.toString(), (LanguageLevel)languageLevel));
                    ++callArgumentIndex;
                    continue;
                }
                RPsiElement value = type.isOptional() ? argument.getValue() : RubyElementFactoryCore.createExpressionFromText((Project)project, (String)RubyTokenTypesCore.kNIL.toString(), (LanguageLevel)languageLevel);
                Ref matchCallArgument = new Ref((Object)true);
                if (RubyInlineMethodProcessor.tryToInlineArgument(method, argument.getName(), (PsiElement)value, renameMap, (Ref<Boolean>)matchCallArgument)) {
                    if (!((Boolean)matchCallArgument.get()).booleanValue()) continue;
                    ++callArgumentIndex;
                    continue;
                }
                builder2.append(argument.getName()).append(" = ").append(value.getText());
                argumentInitializers.add((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)builder2.toString(), (LanguageLevel)languageLevel));
                continue;
            }
            if (type != ArgumentInfo.Type.ARRAY) continue;
            builder2 = new StringBuilder();
            RubyInlineMethodProcessor.addRestOfCallArgsAndParameters(builder2, methodArguments, argumentIndex, callArguments, callArgumentIndex);
            argumentIndex = methodArguments.size();
            argumentInitializers.add((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)builder2.toString(), (LanguageLevel)languageLevel));
        }
        return argumentInitializers;
    }

    private static void addRestOfCallArgsAndParameters(StringBuilder builder2, List<RArgument> methodArguments, int argumentIndex, List<RPsiElement> callArguments, int callArgumentIndex) {
        while (argumentIndex < methodArguments.size()) {
            RArgument argument;
            if (!builder2.isEmpty()) {
                builder2.append(", ");
            }
            if ((argument = methodArguments.get(argumentIndex)).getType() == ArgumentInfo.Type.ARRAY) {
                builder2.append("*");
            }
            builder2.append(argument.getName());
            ++argumentIndex;
        }
        builder2.append(" = ");
        if (callArgumentIndex < callArguments.size()) {
            while (callArgumentIndex < callArguments.size()) {
                builder2.append(callArguments.get(callArgumentIndex).getText());
                if (callArgumentIndex < callArguments.size() - 1) {
                    builder2.append(", ");
                }
                ++callArgumentIndex;
            }
        } else {
            builder2.append("[]");
        }
    }

    public static boolean tryToInlineArgument(RMethod method, final String argumentName, PsiElement value, Map<String, String> renameMap, Ref<Boolean> matchCallArgument) {
        final ArrayList usages = new ArrayList();
        final Ref readAccessOnly = new Ref((Object)true);
        method.getCompoundStatement().accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRIdentifier(@NotNull RIdentifier identifier) {
                if (identifier == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (argumentName.equals(identifier.getName()) && (identifier.isParameter() || identifier.isLocalVariable())) {
                    usages.add(identifier);
                    readAccessOnly.set((Object)((Boolean)readAccessOnly.get() != false && !RubyPsiUtilCore.isDeclaration((PsiElement)identifier) ? 1 : 0));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$7", "visitRIdentifier"));
            }
        });
        if (((Boolean)readAccessOnly.get()).booleanValue() && (RubyPsiUtil.isConstantValue(value) || usages.size() <= 1)) {
            PsiElement replacement = RubyInlineMethodProcessor.tryParsePredefinedParams(method, argumentName, value, renameMap, matchCallArgument);
            if (replacement == null) {
                return false;
            }
            for (RIdentifier usage : usages) {
                usage.replace(replacement);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement tryParsePredefinedParams(@NotNull RMethod method, @NotNull String usageText, @NotNull PsiElement value, @NotNull Map<String, String> renameMap, @NotNull Ref<Boolean> matchCallArgument) {
        if (method == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(15);
        }
        if (usageText == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(16);
        }
        if (value == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(17);
        }
        if (renameMap == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(18);
        }
        if (matchCallArgument == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(19);
        }
        LanguageLevel languageLevel = method.getLanguageLevel();
        Object replacement = value;
        if (languageLevel != null) {
            if (!languageLevel.isLessThan(LanguageLevel.RUBY20) && value instanceof RAssoc) {
                RPsiElement key = ((RAssoc)value).getKey();
                if (key != null && usageText.equals(key.getText())) {
                    replacement = ((RAssoc)value).getValue();
                } else {
                    replacement = RubyInlineMethodProcessor.findPredefinedParameter(usageText, value);
                    if (replacement == null && (replacement = (PsiElement)ContainerUtil.find((Iterable)method.getArguments(), it -> it.getType() == ArgumentInfo.Type.NAMED && usageText.equals(it.getName()))) != null) {
                        replacement = ((RArgument)replacement).getValue();
                        matchCallArgument.set((Object)false);
                    }
                }
            } else if (value instanceof RAssignmentExpression) {
                String assignmentObjectOperand = ((RAssignmentExpression)value).getObject().getText();
                replacement = usageText.equals(assignmentObjectOperand = renameMap.getOrDefault(assignmentObjectOperand, assignmentObjectOperand)) ? ((RAssignmentExpression)value).getValue() : RubyInlineMethodProcessor.findPredefinedParameter(usageText, value);
            }
        }
        if (replacement instanceof RBinaryExpression) {
            replacement = RubyElementFactoryCore.createElementFromText((PsiElement)replacement, (String)("(" + replacement.getText() + ")"));
        }
        return replacement;
    }

    private static PsiElement findPredefinedParameter(@NotNull String usageText, @NotNull PsiElement value) {
        PsiElement[] children;
        if (usageText == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(20);
        }
        if (value == null) {
            RubyInlineMethodProcessor.$$$reportNull$$$0(21);
        }
        RPsiElement replacement = null;
        PsiElement list = value.getParent();
        for (PsiElement child : children = list.getChildren()) {
            RPsiElement key;
            if (child instanceof RAssoc && (key = ((RAssoc)child).getKey()) != null && usageText.equals(key.getText())) {
                replacement = ((RAssoc)child).getValue();
            }
            if (!(child instanceof RAssignmentExpression) || !usageText.equals((key = ((RAssignmentExpression)child).getObject()).getText())) continue;
            replacement = ((RAssignmentExpression)child).getValue();
        }
        return replacement;
    }

    public static void inspectUsages(final RMethod method, final MultiMap<PsiElement, String> conflicts, UsageInfo[] usagesIn) {
        Collection exitPointsAndStatements = RControlFlowUtil.findExitPointsAndStatements((ControlFlow)method.getControlFlow());
        if (exitPointsAndStatements.size() > 1) {
            String message = RefactoringBundle.message((String)"refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", (Object[])new Object[]{RubyInlineMethodProcessor.getRefactoringName()});
            for (UsageInfo usageInfo : usagesIn) {
                PsiElement psiElement = usageInfo.getElement();
                RPsiElement statement = RubyPsiUtilCore.getStatement((PsiElement)psiElement);
                if (statement != psiElement) {
                    conflicts.putValue((Object)psiElement, (Object)message);
                    continue;
                }
                RCompoundStatement compoundStatement = (RCompoundStatement)statement.getParent();
                if (PsiTreeUtil.getParentOfType((PsiElement)compoundStatement, (Class[])new Class[]{RContainer.class, RCompoundStatement.class}) instanceof RCompoundStatement) {
                    conflicts.putValue((Object)psiElement, (Object)message);
                    continue;
                }
                List statements = compoundStatement.getStatements();
                if (statements.get(statements.size() - 1) == statement) continue;
                conflicts.putValue((Object)psiElement, (Object)message);
            }
        }
        final HashSet instanceFieldsUsed = new HashSet();
        final HashSet classFieldsUsed = new HashSet();
        final Ref superCallUsed = new Ref((Object)false);
        method.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
                if (rClassVariable == null) {
                    8.$$$reportNull$$$0(0);
                }
                classFieldsUsed.add(rClassVariable.getText());
            }

            public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
                if (rInstanceVariable == null) {
                    8.$$$reportNull$$$0(1);
                }
                instanceFieldsUsed.add(rInstanceVariable.getText());
            }

            public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
                if (rPseudoConstant == null) {
                    8.$$$reportNull$$$0(2);
                }
                if (RubyTokenTypes.kSUPER.toString().equals(rPseudoConstant.getText())) {
                    superCallUsed.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rClassVariable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rInstanceVariable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rPseudoConstant";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClassVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRInstanceVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRPseudoConstant";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!instanceFieldsUsed.isEmpty() || !classFieldsUsed.isEmpty() || ((Boolean)superCallUsed.get()).booleanValue()) {
            for (UsageInfo usageInfo : usagesIn) {
                PsiElement psiElement = usageInfo.getElement();
                if (!(psiElement instanceof RReference)) continue;
                for (String s : instanceFieldsUsed) {
                    conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{s, psiElement.getText()}));
                }
                for (String s : classFieldsUsed) {
                    conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{s, psiElement.getText()}));
                }
                if (!((Boolean)superCallUsed.get()).booleanValue()) continue;
                conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{RubyTokenTypes.kSUPER.toString(), psiElement.getText()}));
            }
        }
        method.putUserData(FQN_INCLUDE_KEY, new HashSet());
        for (UsageInfo usageInfo : usagesIn) {
            final PsiElement callElement = usageInfo.getElement();
            if (!RubyInlineMethodProcessor.isQualifiedCall(callElement)) continue;
            method.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
                    if (rIdentifier == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    if (rIdentifier.isParameter() || rIdentifier.isLocalVariable()) {
                        return;
                    }
                    this.inspectElement((RPsiElement)rIdentifier);
                }

                public void visitRFid(@NotNull RFid rFid) {
                    if (rFid == null) {
                        9.$$$reportNull$$$0(1);
                    }
                    this.inspectElement((RPsiElement)rFid);
                }

                public void visitRConstant(@NotNull RConstant rConstant) {
                    if (rConstant == null) {
                        9.$$$reportNull$$$0(2);
                    }
                    this.inspectElement((RPsiElement)rConstant);
                }

                public void inspectElement(RPsiElement psiElement) {
                    if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)psiElement) != null) {
                        return;
                    }
                    PsiReference reference = psiElement.getReference();
                    if (reference == null) {
                        return;
                    }
                    Symbol resolve = ResolveUtil.resolveToSymbolWithCaching(reference);
                    if (resolve == null) {
                        return;
                    }
                    if (SymbolUtil.isTopLevelSymbol(resolve)) {
                        return;
                    }
                    Symbol parentSymbol = resolve.getParentSymbol();
                    if (parentSymbol != null && SymbolUtil.isTopLevelSymbol(parentSymbol) && ("Kernel".equals(parentSymbol.getName()) || "Object".equals(parentSymbol.getName()))) {
                        return;
                    }
                    if (resolve.getType() == Type.CLASS_METHOD) {
                        if (((RMethodSymbol)resolve).getVisibility() != Visibility.PUBLIC) {
                            conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), callElement.getText()}));
                        }
                        String fqn = RSingletonMethodImpl.makeRubyCallableFQN((FQN)resolve.getFQNWithNesting()).getFullPath();
                        psiElement.putUserData(FQN_TRANSFORMATION_KEY, (Object)fqn);
                        return;
                    }
                    if (resolve.getType() == Type.CONSTANT) {
                        String fqn = resolve.getFQNWithNesting().getFullPath();
                        psiElement.putUserData(FQN_TRANSFORMATION_KEY, (Object)fqn);
                        return;
                    }
                    if (resolve.getType() == Type.INSTANCE_METHOD) {
                        if (((RMethodSymbol)resolve).getVisibility() != Visibility.PUBLIC) {
                            conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), callElement.getText()}));
                        }
                        if (parentSymbol != null && Types.MODULE_OR_CLASS.contains(parentSymbol.getType())) {
                            if (parentSymbol.getType() == Type.CLASS) {
                                psiElement.putUserData(FQN_TRANSFORMATION_KEY, (Object)"self");
                                return;
                            }
                            Set data = (Set)method.getUserData(FQN_INCLUDE_KEY);
                            String fqn = parentSymbol.getFQNWithNesting().getFullPath();
                            assert (data != null) : "data should be initialized before inspection";
                            data.add(fqn);
                            return;
                        }
                    }
                    conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), callElement.getText()}));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "rIdentifier";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "rFid";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "rConstant";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$9";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRIdentifier";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRFid";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRConstant";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public static boolean inspectMethod(Project project, Editor editor, final RMethod method) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        if (RailsUtil.isUnderVendor((PsiElement)method) || ModuleUtilCore.findModuleForPsiElement((PsiElement)method) == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.inlineMethod.libraries.error.message"), (String)RubyInlineMethodProcessor.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        if (method.isConstructor()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.inlineMethod.constructor.error.message"), (String)RubyInlineMethodProcessor.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        List argumentInfos = method.getArgumentInfos();
        for (ArgumentInfo info : argumentInfos) {
            if (!info.getType().isBlock()) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.inlineMethod.block.parameter.error.message"), (String)RubyInlineMethodProcessor.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        final Ref recursionCallFound = new Ref((Object)false);
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRFid(@NotNull RFid rFid) {
                PsiReference reference;
                if (rFid == null) {
                    10.$$$reportNull$$$0(0);
                }
                if ((reference = rFid.getReference()) != null && ResolveUtil.isReferenceTo(reference, (PsiElement)method)) {
                    recursionCallFound.set((Object)true);
                }
            }

            public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
                PsiReference reference;
                if (rIdentifier == null) {
                    10.$$$reportNull$$$0(1);
                }
                if ((reference = rIdentifier.getReference()) != null && ResolveUtil.isReferenceTo(reference, (PsiElement)method)) {
                    recursionCallFound.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rFid";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rIdentifier";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRFid";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIdentifier";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (((Boolean)recursionCallFound.get()).booleanValue()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{RubyInlineMethodProcessor.getRefactoringName()}), (String)RubyInlineMethodProcessor.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        return true;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.method.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageText";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchCallArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareMethodForInline";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReplacement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractAssignmentParameters";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryParsePredefinedParams";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findPredefinedParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

