/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.refactoring.inline.RubyInlineMethodDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.inline.RubyInlineMethodProcessor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterProcessor;

public final class RubyInlineMethodHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(Language l) {
        return l instanceof RubyLanguage;
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof RMethod;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference reference;
        RMethod method = (RMethod)element;
        if (!RubyInlineMethodProcessor.inspectMethod(project, editor, method)) {
            return;
        }
        Set<UsageInfo> referenceUsages = RubyIntroduceParameterProcessor.findUsages(Collections.singletonList((RMethod)element));
        boolean inlineSingleReferenceIsAvailable = true;
        if (referenceUsages.size() <= 1) {
            inlineSingleReferenceIsAvailable = false;
        }
        if ((reference = TargetElementUtil.findReference((Editor)editor)) == null) {
            inlineSingleReferenceIsAvailable = false;
        }
        RubyInlineMethodDialog dialog = new RubyInlineMethodDialog(project, editor, method, reference, inlineSingleReferenceIsAvailable);
        dialog.show();
    }
}

