/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.inline.RubyInlineMethodProcessor;

public class RubyInlineMethodDialog
extends InlineOptionsDialog {
    private final Editor myEditor;
    private final RMethod myMethod;
    private final PsiReference myReference;

    public RubyInlineMethodDialog(Project project, Editor editor, RMethod method, PsiReference reference, boolean inlineSingleCallAvailable) {
        super(project, true, (PsiElement)method);
        this.myEditor = editor;
        this.myMethod = method;
        this.myReference = reference;
        this.myInvokedOnReference = inlineSingleCallAvailable;
        this.setTitle(RubyInlineMethodDialog.getRefactoringName());
        this.init();
    }

    protected String getNameLabelText() {
        return RefactoringBundle.message((String)"inline.method.method.label", (Object[])new Object[]{RMethodPresentationUtil.formatName((RMethod)this.myMethod, (int)257), ""});
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.invocation.only.and.keep.the.method");
    }

    protected boolean isInlineThis() {
        return true;
    }

    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.invocations.and.remove.the.method");
    }

    protected void doAction() {
        this.invokeRefactoring(new RubyInlineMethodProcessor(this.getProject(), this.myEditor, this.myMethod, this.myReference, this.isInlineThisOnly()));
    }

    protected String getHelpId() {
        return "refactoring.inlineMethod";
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.method.title");
    }
}

