/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RIdentifierReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyDefUseUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.inline.RPsiElementReference;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyInlineLocalHandler
extends InlineActionHandler {
    private static final Logger LOG = Logger.getInstance(RubyInlineLocalHandler.class);
    private static final Pair<RAssignmentExpression, Boolean> EMPTY_DEF_RESULT = Pair.create(null, (Object)false);

    public boolean isEnabledForLanguage(Language l) {
        return l instanceof RubyLanguage;
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof RIdentifier)) {
            return false;
        }
        RIdentifier identifier = (RIdentifier)element;
        return identifier.isLocalVariable() && !identifier.isParameter() && PsiTreeUtil.getParentOfType((PsiElement)identifier, RCondition.class) == null;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        RIdentifierReference refExpr = psiReference instanceof RIdentifierReference ? (RIdentifierReference)psiReference : null;
        RubyInlineLocalHandler.invoke(project, editor, (RIdentifier)element, refExpr);
    }

    public static void invoke(@NotNull Project project, Editor editor, RIdentifier local, RIdentifierReference refExpr) {
        if (project == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(0);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        String localName = local.getName();
        ScopeHolder containerBlock = (ScopeHolder)ScopeUtil.getLocalVariableScope((RPsiElement)local);
        LOG.assertTrue(containerBlock != null);
        Pair<RAssignmentExpression, Boolean> defPair = RubyInlineLocalHandler.getAssignmentToInline(containerBlock, refExpr, local, project);
        RAssignmentExpression def = (RAssignmentExpression)defPair.first;
        if (def == null || def.getValue() == null) {
            String key = (Boolean)defPair.second != false ? "variable.has.no.dominating.definition" : "variable.has.no.initializer";
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyInlineLocalHandler.getRefactoringName(), (String)"refactoring.inlineVariable");
            return;
        }
        if (def instanceof RMultiAssignmentExpression) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RBundle.message((String)"refactoring.inline.local.multi.assignment", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyInlineLocalHandler.getRefactoringName(), (String)"refactoring.inlineVariable");
            return;
        }
        RPsiElement[] refsToInline = RubyDefUseUtil.getPostRefs(containerBlock, local, def.getObject());
        if (refsToInline.length == 0) {
            String message = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyInlineLocalHandler.getRefactoringName(), (String)"refactoring.inlineVariable");
            return;
        }
        PsiFile workingFile = local.getContainingFile();
        for (RPsiElement ref : refsToInline) {
            PsiFile otherFile = ref.getContainingFile();
            if (otherFile.equals((Object)workingFile)) continue;
            String message = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyInlineLocalHandler.getRefactoringName(), (String)"refactoring.inlineVariable");
            return;
        }
        for (RPsiElement ref : refsToInline) {
            RPsiElement[] defs = RubyDefUseUtil.getLatestDefs(containerBlock, local, (PsiElement)ref);
            boolean isSameDefinition = true;
            for (RPsiElement otherDef : defs) {
                isSameDefinition &= RubyInlineLocalHandler.isSameDefinition(def, (PsiElement)otherDef);
            }
            if (isSameDefinition) continue;
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyInlineLocalHandler.getRefactoringName(), (String)"refactoring.inlineVariable");
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> RubyInlineLocalHandler.lambda$invoke$1((PsiElement[])refsToInline, def, localName, local), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    @Nullable
    private static RExpressionSubstitution getExpressionSubstitution(@NotNull PsiElement element) {
        if (element == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(1);
        }
        if (element instanceof RIdentifier && element.getParent() instanceof RCompoundStatement && element.getParent().getParent() instanceof RExpressionSubstitution) {
            return (RExpressionSubstitution)element.getParent().getParent();
        }
        return null;
    }

    @NotNull
    private static PsiReference replaceSubstitution(@NotNull RExpressionSubstitution substitution, @NotNull String valueText) {
        if (substitution == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(2);
        }
        if (valueText == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(3);
        }
        PsiElement stringCandidate = substitution.getParent();
        assert (stringCandidate instanceof RDStringLiteralImpl);
        RDStringLiteralImpl string = (RDStringLiteralImpl)stringCandidate;
        String stringText = string.getText();
        return new RPsiElementReference(string.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)substitution, (String)stringText.replace(substitution.getText(), valueText))));
    }

    @NotNull
    public static RPsiElement parenthesizeRCall(@NotNull RPsiElement value) {
        if (value == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(4);
        }
        LanguageLevel level = value.getLanguageLevel();
        RPsiElement newValue = value;
        if (value instanceof RCall && level != null && !(value instanceof RArrayIndexing)) {
            String text = ((RCall)value).getPsiCommand().getText() + "(" + ((RCall)value).getCallArguments().getText() + ")";
            newValue = RubyElementFactoryCore.createExpressionFromText((Project)value.getProject(), (String)text, (LanguageLevel)level);
        }
        RPsiElement rPsiElement = newValue;
        if (rPsiElement == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(5);
        }
        return rPsiElement;
    }

    private static boolean isSameDefinition(RAssignmentExpression def, PsiElement otherDef) {
        return RubyPsiUtil.getAnyAssignmentByLeftPart(otherDef) == def;
    }

    private static RPsiElement prepareValue(RAssignmentExpression def, String localName) {
        RPsiElement value = def.getValue();
        assert (value != null);
        if (def instanceof RSelfAssignmentExpressionImpl) {
            RSelfAssignmentExpressionImpl expression = (RSelfAssignmentExpressionImpl)def;
            String op = expression.getOperation().getText().replace('=', ' ');
            return RubyElementFactoryCore.createElementFromText((PsiElement)def, (String)(localName + " " + op + value.getText() + ")"));
        }
        return value;
    }

    @NotNull
    private static Pair<RAssignmentExpression, Boolean> getAssignmentToInline(ScopeHolder containerBlock, RIdentifierReference expr, RIdentifier local, Project project) {
        if (expr != null) {
            RPsiElement[] candidates = RubyDefUseUtil.getLatestDefs(containerBlock, local, expr.getElement());
            if (candidates.length == 1) {
                RAssignmentExpression expression = RubyPsiUtil.getAnyAssignmentByLeftPart((PsiElement)candidates[0]);
                Pair pair = Pair.create((Object)expression, (Object)false);
                if (pair == null) {
                    RubyInlineLocalHandler.$$$reportNull$$$0(6);
                }
                return pair;
            }
            Pair pair = Pair.create(null, (Object)(candidates.length > 0 ? 1 : 0));
            if (pair == null) {
                RubyInlineLocalHandler.$$$reportNull$$$0(7);
            }
            return pair;
        }
        Query query = ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false);
        PsiReference first = (PsiReference)query.findFirst();
        RPsiElement lValue = first != null ? (RPsiElement)first.resolve() : null;
        Pair pair = lValue != null ? Pair.create((Object)RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)lValue), (Object)false) : EMPTY_DEF_RESULT;
        if (pair == null) {
            RubyInlineLocalHandler.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.variable.title");
    }

    private static /* synthetic */ void lambda$invoke$1(PsiElement[] refsToInline, RAssignmentExpression def, String localName, RIdentifier local) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiReference[] exprs = new PsiReference[refsToInline.length];
            RPsiElement value = RubyInlineLocalHandler.prepareValue(def, localName);
            for (PsiElement element : refsToInline) {
                RPsiElement newValue = RubyInlineLocalHandler.parenthesizeRCall(value);
                RExpressionSubstitution substitution = RubyInlineLocalHandler.getExpressionSubstitution(element);
                exprs[i] = newValue instanceof RDStringLiteralImpl && substitution != null && substitution.getParent() instanceof RDStringLiteralImpl ? RubyInlineLocalHandler.replaceSubstitution(substitution, ((RDStringLiteralImpl)newValue).getContent()) : (RubyReplaceExpressionUtil.isNeedParenthesis((RPsiElement)element, newValue) ? new RPsiElementReference(element.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)local, (String)("(" + newValue.getText() + ")")))) : new RPsiElementReference(element.replace((PsiElement)newValue)));
            }
            for (PsiReference expr : exprs) {
                RListOfExpressions list;
                PsiElement element = expr.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof RArrayToArguments) || (list = (RListOfExpressions)PsiTreeUtil.findChildOfType((PsiElement)element, RListOfExpressions.class)) == null) continue;
                parent.getParent().replace((PsiElement)list);
            }
            PsiElement next = def.getNextSibling();
            if (RubySpaceUtil.isAnyNewLine((PsiElement)next)) {
                RubyPsiUtil.removeElements(next);
            }
            RubyPsiUtil.removeElements(new PsiElement[]{def});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineLocalHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineLocalHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parenthesizeRCall";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentToInline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionSubstitution";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstitution";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parenthesizeRCall";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

