/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;

class RPsiElementReference
implements PsiReference {
    private final PsiElement myElement;
    private final TextRange myTextRange;

    RPsiElementReference(PsiElement element) {
        this.myElement = element;
        int relativeStartOffset = this.myElement.getTextOffset() - RubyPsiUtil.getOriginalTextOffset(this.myElement);
        this.myTextRange = new TextRange(relativeStartOffset, relativeStartOffset + this.myElement.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            RPsiElementReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            RPsiElementReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        return this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myTextRange.substring(this.myElement.getText());
        if (string == null) {
            RPsiElementReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            RPsiElementReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RPsiElementReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            RPsiElementReference.$$$reportNull$$$0(5);
        }
        return element == this.myElement;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RPsiElementReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RPsiElementReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

