/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractModule;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractModule.ExtractModuleDialog;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyExtractModuleHandler
extends RubyClassRefactoringHandlerBase {
    private static final Logger LOG = Logger.getInstance(RubyExtractModuleHandler.class);

    public void showDialog(Project project, PsiElement element, Editor editor, PsiFile file, DataContext dataContext) {
        RContainer clazz = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)element);
        assert (clazz != null);
        RubyMemberInfoStorage infoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos(clazz, element);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ExtractModuleDialog dialog = new ExtractModuleDialog(project, clazz, infoStorage);
        if (dialog.showAndGet()) {
            RubyExtractModuleHandler.extractModule(clazz, dialog.getSelectedMemberInfos(), dialog.getSuperBaseName(), dialog.getTargetDirectory(), dialog.isStatic());
        }
    }

    @ApiStatus.Internal
    public static void extractModule(RContainer clazz, Collection<RubyMemberInfo> selectedMemberInfos, String superBaseName, VirtualFile targetDirectory, boolean isStatic) {
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> {
            try {
                RubyExtractModuleHandler.navigate((PsiElement)RubyExtractModuleHandler.doExtractModule(clazz, selectedMemberInfos, superBaseName, targetDirectory, isStatic));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        })), RBundle.message((String)"refactoring.extract.module.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    private static PsiElement doExtractModule(RContainer clazz, Collection<RubyMemberInfo> members, String superBaseName, VirtualFile targetDirectory, boolean isStatic) throws IOException {
        Project project = clazz.getProject();
        String statement = RubyClassMembersPsiHelper.prepareContainerStatements(superBaseName, members, "module", isStatic);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        RFile file = RubyClassMembersPsiHelper.createTargetFile(project, targetDirectory, RubyRefactoringUtil.getNewFileName(superBaseName, module), statement);
        RubyClassMembersPsiHelper.removeMembers(members);
        RubyClassMembersPsiHelper.insertRequire(clazz.getContainingFile(), file);
        RubyExtractModuleHandler.insertInclude(clazz, superBaseName, isStatic ? "extend" : "include");
        return RubyClassMembersPsiHelper.findPrepared(file, superBaseName);
    }

    private static void insertInclude(RContainer clazz, String superBaseName, String type) {
        List include = RubyElementFactoryCore.getNotEmptyTopLevelElements((Project)clazz.getProject(), (String)(type + " " + superBaseName + "\n"), (LanguageLevel)RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)clazz));
        RefactoringPsiHelper.insertElements(clazz.getFirstChild(), include);
    }

    protected String getHelpId() {
        return "refactoring.extractModule";
    }

    protected String getTitle() {
        return RBundle.message((String)"refactoring.extract.module.header");
    }

    protected String getInvalidPositionMessage() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.class");
    }
}

