/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractModule;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyExtractSuperBaseDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;

public class ExtractModuleDialog
extends RubyExtractSuperBaseDialog {
    private JRadioButton myStaticButton;
    private JRadioButton myInstanceButton;

    public ExtractModuleDialog(Project project, RContainer clazz, RubyMemberInfoStorage memberInfos) {
        super(project, clazz, memberInfos);
        this.setTitle(RBundle.message((String)"refactoring.extract.module.header"));
        this.init();
    }

    @Override
    protected JPanel createNorthPanel() {
        Box box = this.createBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(RBundle.message((String)"refactoring.extract.module.context")), "North");
        MyContextActionListener listener = new MyContextActionListener();
        this.myStaticButton = new JRadioButton(RBundle.message((String)"refactoring.extract.module.context.static"));
        this.myInstanceButton = new JRadioButton(RBundle.message((String)"refactoring.extract.module.context.instance"));
        ButtonGroup group = new ButtonGroup();
        this.myStaticButton.addActionListener(listener);
        group.add(this.myStaticButton);
        this.myInstanceButton.addActionListener(listener);
        group.add(this.myInstanceButton);
        _panel.add((Component)this.myStaticButton, "Center");
        _panel.add((Component)this.myInstanceButton, "West");
        this.selectSelectedContext();
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)box, "Center");
        return panel2;
    }

    private void selectSelectedContext() {
        for (RubyMemberInfo memberInfo : this.myMemberInfos) {
            if (!memberInfo.isStatic() || !memberInfo.isChecked()) continue;
            this.myStaticButton.setSelected(true);
            return;
        }
        this.myInstanceButton.setSelected(true);
    }

    public boolean isStatic() {
        return this.myStaticButton.isSelected();
    }

    protected String getHelpId() {
        return "refactoring.extract.module.dialog";
    }

    @Override
    protected String getSuperBaseType() {
        return "module";
    }

    @Override
    protected VirtualFile getRoot() {
        VirtualFile root = (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsApp.fromPsiElement((PsiElement)this.myClass), app -> (VirtualFile)ContainerUtil.getFirstItem(app.getPaths().findFiles("lib")));
        return root != null ? root : super.getRoot();
    }

    @Override
    protected String getMembersBorderTitle() {
        return RBundle.message((String)"refactoring.extract.module.members.to.form.module");
    }

    @Override
    protected String getFileBrowserTitle() {
        return RBundle.message((String)"refactoring.extract.module.directory.for.module");
    }

    @Override
    protected boolean isStaticAllowed() {
        return this.isStatic();
    }

    @Override
    protected boolean isInstanceAllowed() {
        return !this.isStatic();
    }

    private class MyContextActionListener
    implements ActionListener {
        private MyContextActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtractModuleDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
        }
    }
}

