/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodSettingsImpl;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.MethodDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.RubyBlockToMethodReferenceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RCodeBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyDuplicatesFinder;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHandler;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHelperBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class RubyExtractMethodHelper
extends RubyExtractMethodHelperBase {
    public static final RubyExtractMethodHelper HELPER = new RubyExtractMethodHelper();

    @Override
    protected void handleExtractFromExpression(Project project, Editor editor, CodeFragment codeFragment, RPsiElement expression) {
        if (!codeFragment.getOutputVariables().isEmpty()) {
            String message = codeFragment.isReturnInstructionInside() ? RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.with.return.statement.inside.and.not.empty.output.variables") : RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.from.expression.with.not.empty.output.variables");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyExtractMethodHandler.getDialogTitle(), (String)"refactoring.extractMethod");
            return;
        }
        ExtractMethodSettings<Visibility> settings = this.getExtractSettings(project, codeFragment, expression);
        if (settings == null) {
            return;
        }
        String methodName = settings.getMethodName();
        AbstractVariableData[] variableData = settings.getAbstractVariableData();
        RubyDuplicatesFinder finder = new RubyDuplicatesFinder(expression.getContainingFile(), (PsiElement)expression, (PsiElement)expression, variableData);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RubyExtractMethodHandler.getDialogTitle(), null, () -> {
            RMethod generatedMethod = RubyExtractMethodHelper.generateMethodFromExpression(project, settings, expression);
            generatedMethod = RubyExtractMethodHelper.insertGeneratedMethod(expression, generatedMethod, (Visibility)settings.getVisibility());
            RubyExtractMethodHelper.processParameters(project, generatedMethod, variableData);
            PsiElement callElement = RubyExtractMethodHelper.generateCallElement(codeFragment, methodName, variableData, expression, project);
            callElement = RefactoringPsiHelper.replaceExpression(project, (PsiElement)expression, callElement);
            RContainer container = RubyPsiUtilCore.getParentContainer((PsiElement)callElement);
            RubyExtractMethodHelper.processDuplicates(container, callElement, generatedMethod, finder, editor);
            RubyExtractMethodHelper.setSelectionAndCaret(editor, callElement);
        }, (PsiFile[])new PsiFile[]{expression.getContainingFile()});
    }

    private static PsiElement generateCallElement(@NotNull CodeFragment codeFragment, @NotNull String methodName, AbstractVariableData @NotNull [] variableData, @NotNull RPsiElement expression, @NotNull Project project) {
        if (codeFragment == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(3);
        }
        if (variableData == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(4);
        }
        String text4Call = (codeFragment.isReturnInstructionInside() ? "return " : "") + methodName;
        String args = RubyExtractMethodHelper.createArguments(variableData, false, true);
        if (StringUtil.isNotEmpty((String)args)) {
            text4Call = text4Call + "(" + args + ")";
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)expression);
        assert (languageLevel != null);
        return RubyElementFactoryCore.createElementFromText((Project)project, (String)text4Call, (LanguageLevel)languageLevel);
    }

    private static RMethod generateMethodFromExpression(Project project, ExtractMethodSettings<Visibility> settings, RPsiElement expression) {
        String methodText = RubyExtractMethodHelper.generateSignature(settings, expression, true) + expression.getText() + "\nend";
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)expression);
        assert (languageLevel != null);
        RMethod method = (RMethod)RubyElementFactoryCore.createElementFromText((Project)project, (String)methodText, (LanguageLevel)languageLevel);
        RubyPsiUtil.markGenerated((PsiElement)method);
        return method;
    }

    @Override
    protected void handleExtractFromStatements(Project project, Editor editor, CodeFragment codeFragment, RPsiElement statement1, RPsiElement statement2) {
        List outputVariables = (List)codeFragment.getOutputVariables();
        if (!outputVariables.isEmpty() && codeFragment.isReturnInstructionInside()) {
            String message = RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.with.return.statement.inside.and.not.empty.output.variables");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyExtractMethodHandler.getDialogTitle(), (String)"refactoring.extractMethod");
            return;
        }
        ExtractMethodSettings<Visibility> extractSettings = this.getExtractSettings(project, codeFragment, statement1);
        if (extractSettings == null) {
            return;
        }
        String methodName = extractSettings.getMethodName();
        AbstractVariableData[] variableData = extractSettings.getAbstractVariableData();
        List<PsiElement> elementsRange = RubyExtractMethodHelper.collectElements((PsiElement)statement1, (PsiElement)statement2);
        RubyDuplicatesFinder finder = new RubyDuplicatesFinder(statement1.getContainingFile(), (PsiElement)statement1, (PsiElement)statement2, variableData);
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)statement1);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RubyExtractMethodHandler.getDialogTitle(), null, () -> {
            String prefix;
            RMethod generatedMethod = RubyExtractMethodHelper.generateMethodFromElements(project, extractSettings, elementsRange);
            generatedMethod = RubyExtractMethodHelper.insertGeneratedMethod(statement1, generatedMethod, (Visibility)extractSettings.getVisibility());
            if (!outputVariables.isEmpty()) {
                assert (!codeFragment.isReturnInstructionInside());
                if (outputVariables.size() != 1 || !StringUtil.equals((CharSequence)ScopeUtil.getLastReturnName((ScopeHolder)generatedMethod), (CharSequence)((CharSequence)outputVariables.get(0)))) {
                    StringBuilder builder2 = new StringBuilder();
                    for (Object outputVariable : outputVariables) {
                        if (!builder2.isEmpty()) {
                            builder2.append(",");
                        }
                        builder2.append((String)outputVariable);
                    }
                    if (outputVariables.size() > 1) {
                        builder2.insert(0, "return ");
                    }
                    RPsiElement returnStatement = RubyElementFactoryCore.createElementFromText((Project)project, (String)builder2.toString(), (LanguageLevel)languageLevel);
                    generatedMethod.getCompoundStatement().add((PsiElement)returnStatement);
                }
            }
            RubyExtractMethodHelper.processParameters(project, generatedMethod, variableData);
            if (outputVariables.isEmpty()) {
                prefix = RubyExtractMethodHelper.insertReturn(statement1, codeFragment) ? "return " : "";
            } else {
                StringBuilder builder3 = new StringBuilder();
                for (String outputVariable : outputVariables) {
                    if (!builder3.isEmpty()) {
                        builder3.append(",");
                    }
                    builder3.append(outputVariable);
                }
                builder3.append(" = ");
                prefix = builder3.toString();
            }
            String params = RubyExtractMethodHelper.createArguments(variableData, false, true);
            boolean generateParenthesesAroundArguments = RubyCodeStyleSettings.getInstance((Editor)editor).PARENTHESES_AROUND_METHOD_ARGUMENTS && !params.isEmpty();
            char open = generateParenthesesAroundArguments ? (char)'(' : (char)' ';
            char close = generateParenthesesAroundArguments ? (char)')' : (char)' ';
            String text4Call = prefix + methodName + open + params + close;
            RPsiElement callElement = RubyElementFactoryCore.createElementFromText((Project)project, (String)text4Call, (LanguageLevel)languageLevel);
            callElement = RubyExtractMethodHelper.replaceElements(elementsRange, (PsiElement)callElement);
            RContainer container = RubyPsiUtilCore.getParentContainer((PsiElement)callElement);
            RubyExtractMethodHelper.applyPostReplacementInspections((PsiElement)callElement);
            RubyExtractMethodHelper.processDuplicates(container, (PsiElement)callElement, generatedMethod, finder, editor);
            RubyExtractMethodHelper.setSelectionAndCaret(editor, (PsiElement)callElement);
        }, (PsiFile[])new PsiFile[]{statement1.getContainingFile()});
    }

    private static boolean insertReturn(RPsiElement statement1, CodeFragment codeFragment) {
        RContainer container = statement1.getParentContainer();
        return !(container instanceof RClass) && !(container instanceof RModule) && codeFragment.isReturnInstructionInside();
    }

    private static void processParameters(Project project, RMethod generatedMethod, AbstractVariableData[] variableData) {
        Map<String, String> variableMap = RubyExtractMethodHelper.createVariableMap(variableData);
        RArgumentList argumentList = generatedMethod.getArgumentList();
        assert (argumentList != null);
        for (RArgument argument : argumentList.getArguments()) {
            if (RIdentifier.isNumberedParameterName((CharSequence)argument.getText())) {
                RubyExtractMethodHelper.renameNumberedParameter(project, variableMap, argument, generatedMethod);
                continue;
            }
            boolean ok = RubyExtractMethodHelper.renameIdentifierParameter(project, variableMap, argument);
            if (ok) continue;
            break;
        }
    }

    private static void renameNumberedParameter(final @NotNull Project project, @NotNull Map<String, String> variableMap, @NotNull RArgument argument, @NotNull RMethod generatedMethod) {
        if (project == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(5);
        }
        if (variableMap == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(6);
        }
        if (argument == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(7);
        }
        if (generatedMethod == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(8);
        }
        RIdentifier parameter = Objects.requireNonNull((RIdentifier)PsiTreeUtil.getChildOfType((PsiElement)argument, RIdentifier.class));
        final String name = parameter.getText();
        final String newName = variableMap.get(name);
        final LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)parameter);
        assert (languageLevel != null);
        generatedMethod.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRIdentifier(@NotNull RIdentifier identifier) {
                if (identifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (identifier.getText().equals(name)) {
                    identifier.replace((PsiElement)RubyElementFactoryCore.createElementFromText((Project)project, (String)newName, (LanguageLevel)languageLevel));
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof ScopeHolder)) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "identifier";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIdentifier";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean renameIdentifierParameter(@NotNull Project project, @NotNull Map<String, String> variableMap, @NotNull RArgument argument) {
        String newName;
        String name;
        if (project == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(9);
        }
        if (variableMap == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(10);
        }
        if (argument == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(11);
        }
        if (!StringUtil.equals((CharSequence)(name = argument.getName()), (CharSequence)(newName = variableMap.get(name)))) {
            RIdentifier identifier = argument.getIdentifier();
            if (identifier == null) {
                return true;
            }
            UsageInfo[] usages = RenameUtil.findUsages((PsiElement)identifier, (String)newName, (boolean)false, (boolean)false, Collections.singletonMap(identifier, newName));
            try {
                RenameUtil.doRename((PsiElement)identifier, (String)newName, (UsageInfo[])usages, (Project)project, (RefactoringElementListener)new RefactoringElementListenerComposite());
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage((IncorrectOperationException)e, (PsiElement)identifier, (Project)project);
                return false;
            }
        }
        return true;
    }

    private static String createArguments(AbstractVariableData[] variableData, boolean fakeSignature, boolean isParams) {
        StringBuilder builder2 = new StringBuilder();
        for (AbstractVariableData data : variableData) {
            if (!fakeSignature && !data.isPassAsParameter()) continue;
            if (!builder2.isEmpty()) {
                builder2.append(", ");
            }
            builder2.append(fakeSignature || isParams ? data.getOriginalName() : data.getName());
        }
        return builder2.toString();
    }

    private static Map<String, String> createVariableMap(AbstractVariableData[] variableData) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (AbstractVariableData data : variableData) {
            result.put(data.getOriginalName(), data.getName());
        }
        return result;
    }

    private static RMethod insertGeneratedMethod(@NotNull RPsiElement anchor, @NotNull RMethod generatedMethod, @Nullable Visibility visibility) {
        RContainer contextContainer;
        RCompoundStatement compoundStatement;
        Pair data;
        if (anchor == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(12);
        }
        if (generatedMethod == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(13);
        }
        if ((data = (Pair)anchor.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE)) != null) {
            anchor = (RPsiElement)data.first;
        }
        RCompoundStatement rCompoundStatement = compoundStatement = (contextContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{RTopLevelContainer.class, RModule.class, RClass.class})) != null ? contextContainer.getCompoundStatement() : (RCompoundStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)anchor, (Class[])new Class[]{RCompoundStatement.class});
        assert (compoundStatement != null) : anchor.getContainingFile();
        RContainer parentMethod = RubyPsiUtilCore.getParentContainer((PsiElement)anchor);
        if (!(parentMethod instanceof RMethod) || contextContainer instanceof RTopLevelContainer || contextContainer == null) {
            RPsiElement statement = RubyPsiUtilCore.getStatement((RCompoundStatement)compoundStatement, (PsiElement)anchor);
            assert (statement != null);
            List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)statement);
            RPsiElement element2AddBefore = comments.isEmpty() ? statement : (PsiElement)comments.get(0);
            return (RMethod)element2AddBefore.getParent().addBefore((PsiElement)generatedMethod, (PsiElement)element2AddBefore);
        }
        RPsiElement elementToAddAfter = RubyExtractMethodHelper.findOrCreateElementForVisibility((RMethod)parentMethod, contextContainer, visibility);
        return (RMethod)compoundStatement.addAfter((PsiElement)generatedMethod, (PsiElement)elementToAddAfter);
    }

    @Nullable(value="null means add first")
    private static @Nullable(value="null means add first") RPsiElement findOrCreateElementForVisibility(@NotNull RMethod containerMethod, @NotNull RContainer containerClassModule, @Nullable Visibility visibility) {
        RCompoundStatement compoundStatement;
        RPsiElement coveringStatement;
        if (containerMethod == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(14);
        }
        if (containerClassModule == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(15);
        }
        if ((coveringStatement = RubyPsiUtilCore.getStatement((RCompoundStatement)(compoundStatement = containerClassModule.getCompoundStatement()), (PsiElement)containerMethod)) == null) {
            return RubyExtractMethodHelper.reportUnexpectedExtraction(containerMethod, containerClassModule);
        }
        if (visibility == null) {
            return coveringStatement;
        }
        EnumMap<Visibility, RPsiElement> lastElementsForVisibility = new EnumMap<Visibility, RPsiElement>(Visibility.class);
        EnumMap<Visibility, RPsiElement> firstElementsForVisibility = new EnumMap<Visibility, RPsiElement>(Visibility.class);
        Visibility currentVisibility = Visibility.PUBLIC;
        for (RPsiElement element : compoundStatement.getStatements()) {
            if (VisibilityUtilCore.isVisibilityChangeCall((ASTNode)element.getNode())) {
                currentVisibility = VisibilityUtilCore.getVisibility((String)element.getText());
                lastElementsForVisibility.put(currentVisibility, element);
                firstElementsForVisibility.put(currentVisibility, element);
            } else if (element instanceof RMethod) {
                lastElementsForVisibility.put(currentVisibility, element);
            }
            if (element != coveringStatement || !lastElementsForVisibility.containsKey(visibility)) continue;
            return (RPsiElement)lastElementsForVisibility.get(visibility);
        }
        if (firstElementsForVisibility.containsKey(visibility)) {
            return (RPsiElement)firstElementsForVisibility.get(visibility);
        }
        if (visibility == Visibility.PUBLIC) {
            RPsiElement visibilityModifier = Stream.of((RPsiElement)firstElementsForVisibility.get(Visibility.PROTECTED), (RPsiElement)firstElementsForVisibility.get(Visibility.PRIVATE)).min((o1, o2) -> {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getTextRange().getStartOffset() - o2.getTextRange().getStartOffset();
            }).orElseGet(() -> RubyExtractMethodHelper.reportUnexpectedExtraction(containerMethod, containerClassModule));
            return (RPsiElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)visibilityModifier, RPsiElement.class);
        }
        RPsiElement anchorForModifier = visibility == Visibility.PRIVATE ? null : (RPsiElement)firstElementsForVisibility.get(Visibility.PRIVATE);
        RPsiElement newModifier = RubyElementFactoryCore.createElementFromText((PsiElement)containerClassModule, (String)visibility.getPresentableName());
        PsiElement addedModifier = compoundStatement.addBefore((PsiElement)newModifier, (PsiElement)anchorForModifier);
        if (!(addedModifier instanceof RPsiElement)) {
            RubyExtractMethodHelper.reportUnexpectedExtraction(containerMethod, containerClassModule);
        }
        return (RPsiElement)addedModifier;
    }

    private static RPsiElement reportUnexpectedExtraction(@NotNull RMethod method, @NotNull RContainer container) {
        if (method == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(16);
        }
        if (container == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(17);
        }
        throw new AssertionError((Object)(container.getText() + ";;;" + method.getText()));
    }

    private static RMethod generateMethodFromElements(Project project, ExtractMethodSettings<Visibility> settings, List<? extends PsiElement> elementsRange) {
        PsiElement first = elementsRange.get(0);
        StringBuilder methodText = new StringBuilder(RubyExtractMethodHelper.generateSignature(settings, (RPsiElement)first, true));
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)first);
        for (PsiElement psiElement : elementsRange) {
            methodText.append(psiElement.getText());
        }
        methodText.append("\nend");
        RMethod method = (RMethod)RubyElementFactoryCore.createElementFromText((Project)project, (String)methodText.toString(), (LanguageLevel)languageLevel);
        RubyPsiUtil.markGenerated((PsiElement)method);
        return method;
    }

    public static String generateSignature(ExtractMethodSettings<Visibility> extractMethodSettings, @NotNull RPsiElement expression, boolean fakeSignature) {
        RContainer parentContainer;
        if (expression == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(18);
        }
        boolean includeSelf = (parentContainer = expression.getParentContainer()) instanceof RSingletonMethod || parentContainer instanceof RClass || parentContainer instanceof RModule;
        String params = RubyExtractMethodHelper.createArguments(extractMethodSettings.getAbstractVariableData(), fakeSignature, false);
        boolean generateParenthesesAroundArguments = RubyCodeStyleSettings.getInstance((PsiElement)expression).PARENTHESES_AROUND_METHOD_ARGUMENTS && !params.isEmpty();
        char open = generateParenthesesAroundArguments ? (char)'(' : ' ';
        char close = generateParenthesesAroundArguments ? (char)')' : ' ';
        return (includeSelf ? "def self." : "def ") + extractMethodSettings.getMethodName() + (String)(params.isEmpty() ? "" : open + params + close) + "\n";
    }

    @ApiStatus.Internal
    @Nullable
    public ExtractMethodSettings<Visibility> getExtractSettings(Project project, CodeFragment codeFragment, RPsiElement expression) {
        RubyExtractMethodValidator validator = new RubyExtractMethodValidator(expression, ContextImpl.getContext((PsiElement)expression));
        RubyExtractMethodDialog dialog = new RubyExtractMethodDialog(project, "method_name", codeFragment, validator, expression);
        return dialog.showAndGet() ? new ExtractMethodSettingsImpl(dialog.getMethodName(), dialog.getAbstractVariableData(), (Object)((Visibility)dialog.getVisibility())) : null;
    }

    private static void processDuplicates(@Nullable RContainer container, @NotNull PsiElement callElement, @NotNull RMethod generatedMethod, @NotNull RubyDuplicatesFinder finder, @NotNull Editor editor) {
        if (callElement == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(19);
        }
        if (generatedMethod == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(20);
        }
        if (finder == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(22);
        }
        ArrayList<Object> scope = new ArrayList<Object>();
        if (container instanceof RMethod) {
            RContainer parentContainer = RubyPsiUtilCore.getParentContainer((PsiElement)container);
            if (parentContainer instanceof RClass || parentContainer instanceof RModule) {
                scope.add(container);
                for (RMethod method : ((RMethodHolder)parentContainer).getMethods()) {
                    if (method.equals((Object)container) || method.equals((Object)generatedMethod) || method.getClass() != generatedMethod.getClass()) continue;
                    scope.add(method);
                }
            } else {
                RubyExtractMethodHelper.addFileStatements(parentContainer, scope);
            }
        }
        RubyExtractMethodHelper.addFileStatements(container, scope);
        ExtractMethodHelper.processDuplicates((PsiElement)callElement, (PsiElement)generatedMethod, scope, (SimpleDuplicatesFinder)finder, (Editor)editor, pair -> RubyExtractMethodHelper.replaceMatch((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()));
    }

    private static void addFileStatements(RContainer container, List<? super PsiElement> scope) {
        if (container instanceof RFile) {
            for (RPsiElement element : container.getStatements()) {
                if (element instanceof RClass || element instanceof RModule) continue;
                scope.add((PsiElement)element);
            }
        }
    }

    private static void applyPostReplacementInspections(@NotNull PsiElement callElement) {
        RCompoundStatement statement;
        if (callElement == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(23);
        }
        if ((statement = RCompoundStatementNavigator.getByPsiElement((PsiElement)callElement)) == null) {
            return;
        }
        RCodeBlock codeBlock = RCodeBlockNavigator.getByBlockCmsSt((RCompoundStatement)statement);
        if (codeBlock == null) {
            return;
        }
        RBlockCall blockCall = codeBlock.getBlockCall();
        if (blockCall == null) {
            return;
        }
        MethodDescriptor descriptor = RubyBlockToMethodReferenceUtil.getBlockMethodDescriptor(blockCall);
        if (descriptor != null) {
            RubyBlockToMethodReferenceUtil.replaceBlock(blockCall, descriptor.getReference());
        }
    }

    private static void replaceMatch(@NotNull SimpleMatch match, @NotNull PsiElement callElement) {
        if (match == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(24);
        }
        if (callElement == null) {
            RubyExtractMethodHelper.$$$reportNull$$$0(25);
        }
        PsiElement newCallElement = RubyExtractMethodHelper.replaceElements(match, callElement);
        RubyExtractMethodHelper.applyPostReplacementInspections(newCallElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableData";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableMap";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 8: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerMethod";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClassModule";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateCallElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "renameNumberedParameter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "renameIdentifierParameter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "insertGeneratedMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrCreateElementForVisibility";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnexpectedExtraction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSignature";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "processDuplicates";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPostReplacementInspections";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceMatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class RubyExtractMethodValidator
    implements ExtractMethodValidator {
        private final RPsiElement myExpression;
        private final ContextImpl myContext;

        public RubyExtractMethodValidator(RPsiElement expression, ContextImpl context) {
            this.myExpression = expression;
            this.myContext = context;
        }

        public String check(String name) {
            Symbol symbol = SymbolUtil.getSymbolRepresentingContext(SymbolUtil.getScopeContextWithCaching((PsiElement)this.myExpression), this.myContext);
            assert (symbol != null);
            return SymbolUtil.findMethod(symbol, name, Types.METHODS_LIKE, (PsiElement)this.myExpression) != null ? RBundle.message((String)"refactoring.extract.method.error.method.name.clashes.with.existing.method") : null;
        }

        public boolean isValidName(String name) {
            return TextUtil.isMethodName((String)name);
        }
    }
}

