/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment.RubyExtractMethodUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHelperBase;

public class RubyExtractMethodHandler
implements RefactoringActionHandler,
ElementsHandler {
    public static final String HELP_ID = "refactoring.extractMethod";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(0);
        }
        Pair<PsiElement, PsiElement> selected = RefactoringPsiHelper.getSelectedElements(editor, file);
        this.invoke(project, new PsiElement[]{(PsiElement)selected.first, (PsiElement)selected.second}, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(2);
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (file == null || editor == null) {
            return;
        }
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        PsiElement element1 = elements[0];
        PsiElement element2 = elements[1];
        if (!RubyExtractMethodHandler.isEnabledOnElements(element1, element2)) {
            this.errorCannotPerformRefactoring(project, editor);
            return;
        }
        Pair<RPsiElement, RPsiElement> statements = RubyExtractMethodHandler.getStatements(element1, element2);
        RubyExtractMethodHelperBase helper = this.getHelper();
        if (statements != null) {
            if (!this.checkAvailableForStatements(statements)) {
                this.errorCannotPerformRefactoring(project, editor);
                return;
            }
            ScopeHolder owner = ScopeUtilCore.findScopeHolder((PsiElement)((PsiElement)statements.first));
            assert (owner != null);
            Object fragment = RubyExtractMethodUtil.createCodeFragment(owner, element1, element2);
            if (fragment instanceof String) {
                RubyExtractMethodHandler.showError(project, editor, fragment);
                return;
            }
            helper.handleExtractFromStatements(project, editor, (CodeFragment)fragment, (RPsiElement)statements.first, (RPsiElement)statements.second);
        } else {
            Object expression = RefactoringPsiHelper.getSelectedExpression(project, file, element1, element2, false, HELP_ID);
            if (expression == null || expression instanceof String && StringUtil.isEmpty((String)((String)expression))) {
                this.errorCannotPerformRefactoring(project, editor);
                return;
            }
            if (expression instanceof String) {
                RubyExtractMethodHandler.showError(project, editor, expression);
                return;
            }
            if (!(expression instanceof RExpression)) {
                this.errorCannotPerformRefactoring(project, editor);
                return;
            }
            ScopeHolder owner = ScopeUtilCore.findScopeHolder((PsiElement)element1);
            assert (owner != null);
            Object fragment = RubyExtractMethodUtil.createCodeFragment(owner, element1, element2);
            if (fragment instanceof String) {
                RubyExtractMethodHandler.showError(project, editor, fragment);
                return;
            }
            helper.handleExtractFromExpression(project, editor, (CodeFragment)fragment, (RPsiElement)expression);
        }
    }

    public boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(3);
        }
        return elements.length == 2 && RubyExtractMethodHandler.isEnabledOnElements(elements[0], elements[1]);
    }

    protected boolean checkAvailableForStatements(@NotNull Pair<RPsiElement, RPsiElement> statements) {
        if (statements == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected void errorCannotPerformRefactoring(@NotNull Project project, Editor editor) {
        if (project == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(5);
        }
        String message = RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.using.selected.elements");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RubyExtractMethodHandler.getDialogTitle(), (String)HELP_ID);
    }

    @NotNull
    protected RubyExtractMethodHelperBase getHelper() {
        RubyExtractMethodHelper rubyExtractMethodHelper = RubyExtractMethodHelper.HELPER;
        if (rubyExtractMethodHelper == null) {
            RubyExtractMethodHandler.$$$reportNull$$$0(6);
        }
        return rubyExtractMethodHelper;
    }

    @Nullable
    private static Pair<RPsiElement, RPsiElement> getStatements(PsiElement element1, PsiElement element2) {
        RPsiElement commonParent;
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        RPsiElement rPsiElement = commonParent = parent != null ? RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)parent) : null;
        if (commonParent == null) {
            return null;
        }
        Object compoundStatement = commonParent instanceof RCompoundStatement ? (RCompoundStatement)commonParent : (commonParent.getParent() instanceof RCompoundStatement ? (RCompoundStatement)commonParent.getParent() : null);
        if (compoundStatement == null) {
            return null;
        }
        RPsiElement statement1 = RubyPsiUtilCore.getStatement((RCompoundStatement)compoundStatement, (PsiElement)element1);
        RPsiElement statement2 = RubyPsiUtilCore.getStatement((RCompoundStatement)compoundStatement, (PsiElement)element2);
        if (statement1 == null || statement2 == null) {
            return null;
        }
        return element1 == PsiTreeUtil.getDeepestFirst((PsiElement)statement1) && element2 == PsiTreeUtil.getDeepestLast((PsiElement)statement2) ? Pair.create((Object)statement1, (Object)statement2) : null;
    }

    private static void showError(Project project, Editor editor, Object fragment) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)((String)fragment), (String)RubyExtractMethodHandler.getDialogTitle(), (String)HELP_ID);
    }

    private static boolean isEnabledOnElements(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        return element1 != null && element2 != null && RubyPsiUtilCore.isBefore((PsiElement)element1, (PsiElement)element2);
    }

    @ApiStatus.Internal
    @Nls
    public static String getDialogTitle() {
        return RefactoringBundle.message((String)"extract.method.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailableForStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "errorCannotPerformRefactoring";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

