/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubySuperClassesCollector;

public class RubyMemberInfoStorage
extends AbstractMemberInfoStorage<RPsiElement, RContainer, RubyMemberInfo> {
    private static final TypeSet MEMBERS_TYPES = new TypeSet(new Type[]{Type.CLASS_METHOD, Type.INSTANCE_METHOD});
    private Set<RContainer> myInstanceClasses;
    private Set<RContainer> myStaticClasses;

    public RubyMemberInfoStorage(RContainer aClass) {
        this(aClass, (MemberInfoBase.Filter<RPsiElement>)new MemberInfoBase.EmptyFilter());
    }

    private RubyMemberInfoStorage(RContainer aClass, MemberInfoBase.Filter<RPsiElement> memberInfoFilter) {
        super((PsiElement)aClass, memberInfoFilter);
    }

    protected boolean isInheritor(RContainer baseClass, RContainer aClass) {
        return this.getSubclasses((PsiElement)baseClass).contains(aClass);
    }

    protected void buildSubClassesMap(RContainer aClass) {
        this.buildSubClassesMapImpl(aClass, new HashSet<RContainer>());
    }

    private void buildSubClassesMapImpl(RContainer aClass, Set<RContainer> visited) {
        visited.add(aClass);
        if (this.myInstanceClasses == null) {
            this.myInstanceClasses = new HashSet<RContainer>();
            this.myStaticClasses = new HashSet<RContainer>();
        }
        Map<RContainer, ContextImpl> classes = RubySuperClassesCollector.getSuperClassesAndAllModules(aClass, true);
        this.buildSubclassesMapForSet(aClass, visited, classes);
    }

    private void buildSubclassesMapForSet(RContainer aClass, Set<RContainer> visited, Map<RContainer, ContextImpl> classes) {
        for (Map.Entry<RContainer, ContextImpl> entry : classes.entrySet()) {
            RContainer clazz = entry.getKey();
            this.getSubclasses((PsiElement)clazz).add(aClass);
            Access access = entry.getValue().getAccess();
            if (!access.acceptInstance() || clazz instanceof RClass) {
                this.myStaticClasses.add(clazz);
            }
            if (access.acceptInstance()) {
                this.myInstanceClasses.add(clazz);
            }
            if (visited.contains(clazz)) continue;
            this.buildSubClassesMapImpl(clazz, visited);
        }
    }

    protected void extractClassMembers(RContainer aClass, ArrayList<RubyMemberInfo> temp) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)aClass);
        if (symbol == null) {
            return;
        }
        for (Symbol s : Symbol.getSymbolsByFilter((Symbol)symbol, (Predicate)Symbol.Filter.byTypes((TypeSet)MEMBERS_TYPES), (PsiElement)aClass)) {
            PsiElement declaration = s.getPsiElement();
            if (declaration instanceof RCall) {
                RCall call = (RCall)declaration;
                for (RPsiElement element : call.getCallArguments().getElements()) {
                    RubyMemberInfoStorage.registerMember(temp, (PsiElement)element);
                }
                continue;
            }
            if (!(declaration instanceof RPsiElement)) continue;
            RubyMemberInfoStorage.registerMember(temp, declaration);
        }
        if (symbol instanceof ClassModuleSymbol) {
            RubyMemberInfoStorage.registerIncludeExtend(temp, ((ClassModuleSymbol)symbol).getIncludeSymbols((PsiElement)aClass));
            RubyMemberInfoStorage.registerIncludeExtend(temp, ((ClassModuleSymbol)symbol).getExtendSymbols((PsiElement)aClass));
        }
    }

    private static void registerIncludeExtend(ArrayList<RubyMemberInfo> temp, List<Symbol> symbols) {
        for (Symbol s : symbols) {
            PsiElement declaration = s.getPsiElement();
            if (!(declaration instanceof RPsiElement)) continue;
            RubyMemberInfoStorage.registerMember(temp, declaration);
        }
    }

    private static void registerMember(ArrayList<RubyMemberInfo> temp, PsiElement declaration) {
        for (RubyMemberInfo member : temp) {
            if (member.getMember() != declaration) continue;
            return;
        }
        temp.add(new RubyMemberInfo((RPsiElement)declaration));
    }

    protected boolean memberConflict(RPsiElement member1, RPsiElement member) {
        return member1 instanceof RMethod && member instanceof RMethod && RubyRefactoringUtil.areConflictingMethods((RMethod)member, (RMethod)member1);
    }

    public Set<RContainer> getInstanceClasses() {
        return this.myInstanceClasses;
    }

    public Set<RContainer> getStaticClasses() {
        return this.myStaticClasses;
    }
}

