/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtilCore;

public class RubyMemberInfo
extends MemberInfoBase<RPsiElement> {
    private final Visibility myVisibility;
    private final List<PsiComment> myComments = RubyCommentsUtilCore.getPsiComments((PsiElement)this.getMember());
    private final List<RAliasStatement> myAliases;

    public RubyMemberInfo(RPsiElement member) {
        super((PsiElement)member);
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)PsiTreeUtil.getParentOfType((PsiElement)member, RContainer.class, (boolean)false));
        this.myVisibility = symbol instanceof RMethodSymbol ? (((RMethod)member).isConstructor() ? Visibility.PUBLIC : ((RMethodSymbol)symbol).getVisibility()) : Visibility.PUBLIC;
        if (member instanceof RMethod) {
            RMethod method = (RMethod)member;
            this.overrides = !RubyOverrideImplementUtil.getOverriddenMethods(method).isEmpty();
            Symbol methodSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)method);
            this.isStatic = member instanceof RSingletonMethod || methodSymbol != null && methodSymbol.getType() == Type.CLASS_METHOD;
            this.displayName = RubyMemberInfo.buildDisplayMethodName(method);
            this.myAliases = this.gatherAliases();
        } else {
            if (member instanceof PsiNamedElement) {
                RCall rCall = RubyPsiUtil.getCoveringRCall((PsiElement)member);
                this.displayName = member.getName();
                if (rCall != null) {
                    this.displayName = rCall.getCommand() + " " + this.displayName;
                    this.isStatic = rCall.getCallType() == RubyIncludeExtendCallTypes.EXTEND_CALL;
                }
            } else {
                String text = member.getText();
                this.displayName = text != null ? text : "invalid";
            }
            this.myAliases = Collections.emptyList();
        }
    }

    private List<RAliasStatement> gatherAliases() {
        ArrayList<RAliasStatement> aliases = new ArrayList<RAliasStatement>();
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)this.getContainingClass());
        if (classSymbol == null) {
            return Collections.emptyList();
        }
        for (PsiElement element : classSymbol.getAllDeclarations(this.getMember())) {
            if (!(element instanceof RClass)) continue;
            RClass aClass = (RClass)element;
            for (RPsiElement candidate : aClass.getStatements()) {
                if (!(candidate instanceof RAliasStatement) || !Comparing.strEqual((String)((RPsiElement)this.getMember()).getName(), (String)((RAliasStatement)candidate).getOldName())) continue;
                aliases.add((RAliasStatement)candidate);
            }
        }
        return aliases;
    }

    private static String buildDisplayMethodName(RMethod method) {
        StringBuilder builder2 = new StringBuilder(method.getName());
        builder2.append("(");
        List arguments = method.getArgumentInfos();
        for (ArgumentInfo argumentInfo : arguments) {
            builder2.append(argumentInfo.getName());
            if (arguments.size() <= 1 || argumentInfo == arguments.get(arguments.size() - 1)) continue;
            builder2.append(", ");
        }
        builder2.append(")");
        return builder2.toString();
    }

    @Nullable
    public Icon getVisibilityIcon() {
        return RContainerPresentationUtilCore.getIconForAccessModifier((Visibility)this.myVisibility);
    }

    public Visibility getVisibility() {
        return this.myVisibility;
    }

    @Nullable
    public RContainer getContainingClass() {
        RClass clazz = RubyPsiUtil.getContainingRClass(this.getMember());
        return clazz != null ? clazz : RubyPsiUtil.getContainingRModule(this.getMember());
    }

    public List<PsiComment> getComments() {
        return this.myComments;
    }

    public List<RAliasStatement> getAliases() {
        return this.myAliases;
    }

    public String toString() {
        return "RubyMemberInfo{myVisibility=" + String.valueOf(this.myVisibility) + ", myComments=" + String.valueOf(this.myComments) + ", myAliases=" + String.valueOf(this.myAliases) + "}";
    }
}

