/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsRequireUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public final class RubyClassMembersPsiHelper {
    private RubyClassMembersPsiHelper() {
    }

    public static PsiElement findPrepared(RFile file, String superBaseName) {
        Symbol newContainerSymbol = SymbolUtil.findConstantByFQN(file.getProject(), Type.CLASS, superBaseName, null);
        PsiElement newContainerElement = newContainerSymbol != null ? newContainerSymbol.getPsiElement() : null;
        return newContainerElement != null ? newContainerElement : file;
    }

    public static void insertRequire(PsiFile toFile, RFile file) {
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        RailsApp app = RailsApp.fromPsiElement((PsiElement)toFile);
        if (app != null) {
            for (VirtualFile railsPath : RailsRequireUtil.getRailsDefaultLoadPath(app.getModule())) {
                if (!VfsUtilCore.isAncestor((VirtualFile)railsPath, (VirtualFile)vFile, (boolean)false)) continue;
                return;
            }
        }
        RubyClassMembersPsiHelper.insertRequireByAnchor(file, toFile.getFirstChild());
    }

    public static void insertRequireByAnchor(RFile file, PsiElement anchor) {
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        PsiFile toFile = anchor.getContainingFile();
        VirtualFile vToFile = toFile.getVirtualFile();
        assert (vToFile != null);
        String relativePath = VfsUtilCore.findRelativePath((VirtualFile)vToFile, (VirtualFile)vFile, (char)'/');
        assert (relativePath != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)toFile);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        String statement = sdk != null && RubyVersionUtil.isVersionGreaterOrEqual(sdk, "1.9.2") ? "require_relative '" + relativePath.replace("\\", "/") + "'\n" : "require File.expand_path(File.dirname(__FILE__) + '/" + relativePath.replace("\\", "/") + "')\n";
        List require = RubyElementFactoryCore.getNotEmptyTopLevelElements((PsiElement)toFile, (String)statement);
        RefactoringPsiHelper.insertElements(anchor, require);
    }

    public static RFile createTargetFile(Project project, VirtualFile targetDirectory, String newFileName, String statements) throws IOException {
        int index = newFileName.lastIndexOf(47);
        if (index > 0) {
            targetDirectory = RubyClassMembersPsiHelper.createDirectoryIfMissing(targetDirectory.getFileSystem(), targetDirectory.getPath() + "/" + newFileName.substring(0, index));
            newFileName = newFileName.substring(index + 1);
        }
        assert (targetDirectory != null);
        VirtualFile file = targetDirectory.createChildData(RubyClassMembersPsiHelper.class, newFileName);
        VfsUtil.saveText((VirtualFile)file, (String)statements);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        assert (psiFile instanceof RFile);
        RubyClassMembersPsiHelper.reformat(Collections.singletonList(psiFile));
        return (RFile)psiFile;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull VirtualFileSystem fileSystem, @NotNull String directoryPath) throws IOException {
        String path;
        VirtualFile file;
        if (fileSystem == null) {
            RubyClassMembersPsiHelper.$$$reportNull$$$0(0);
        }
        if (directoryPath == null) {
            RubyClassMembersPsiHelper.$$$reportNull$$$0(1);
        }
        if ((file = fileSystem.refreshAndFindFileByPath(path = FileUtil.toSystemIndependentName((String)directoryPath))) == null) {
            int pos = path.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = RubyClassMembersPsiHelper.createDirectoryIfMissing(fileSystem, path.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = path.substring(pos + 1);
            return parent.createChildDirectory((Object)fileSystem, dirName);
        }
        return file;
    }

    public static String prepareContainerStatements(String superBaseName, Collection<? extends RubyMemberInfo> members, String type, boolean isStatic) {
        return RubyClassMembersPsiHelper.prepareStatementsRec(superBaseName.split("::"), members, type, isStatic, 0);
    }

    @Nullable
    public static PsiElement insertMethods(RContainer toClass, Collection<? extends RubyMemberInfo> members, String access, boolean isStatic) {
        if (members.isEmpty()) {
            return null;
        }
        PsiElement anchor = null;
        for (RubyMemberInfo rubyMemberInfo : members) {
            Pair<PsiElement, Boolean> anchorAndInsertModifier = RubyClassMembersPsiHelper.findAnchor(toClass, access);
            String statements = RubyClassMembersPsiHelper.prepareStatements(rubyMemberInfo, access, true, (Boolean)anchorAndInsertModifier.second, isStatic);
            RFile file = RubyElementFactoryCore.createRubyFile((Project)toClass.getProject(), (String)statements, (LanguageLevel)RubyPsiUtilCore.getLanguageLevel((PsiElement)toClass));
            RClass fakeClass = RContainerUtil.getFirstClassInFile((PsiFile)file);
            assert (fakeClass != null);
            List<? extends PsiElement> elements = fakeClass.getStatements();
            elements = RubyClassMembersPsiHelper.gatherMembersWithComments(elements);
            elements = RefactoringPsiHelper.insertElements((PsiElement)anchorAndInsertModifier.first, elements);
            RubyClassMembersPsiHelper.reformat(elements);
            anchor = !elements.isEmpty() ? elements.get(0) : anchor;
        }
        return anchor;
    }

    public static void removeMembers(Collection<? extends RubyMemberInfo> members) {
        for (RubyMemberInfo rubyMemberInfo : members) {
            ArrayList<Object> toRemove = new ArrayList<Object>();
            if (rubyMemberInfo.getMember() instanceof RMethod) {
                toRemove.addAll(RubyClassMembersPsiHelper.collectToRemoveMethod(rubyMemberInfo));
            } else {
                toRemove.addAll(RubyClassMembersPsiHelper.collectToRemoveInclude(rubyMemberInfo));
            }
            toRemove.addAll(rubyMemberInfo.getComments());
            toRemove.addAll(rubyMemberInfo.getAliases());
            RubyPsiUtil.removeElements(toRemove.toArray(PsiElement.EMPTY_ARRAY));
        }
    }

    public static void splitByAccess(Collection<? extends RubyMemberInfo> members, Collection<? super RubyMemberInfo> pub, Collection<? super RubyMemberInfo> prot, Collection<? super RubyMemberInfo> priv) {
        for (RubyMemberInfo rubyMemberInfo : members) {
            Visibility visibility = rubyMemberInfo.getVisibility();
            if (visibility == Visibility.PUBLIC) {
                pub.add(rubyMemberInfo);
                continue;
            }
            if (visibility == Visibility.PROTECTED) {
                prot.add(rubyMemberInfo);
                continue;
            }
            priv.add(rubyMemberInfo);
        }
    }

    private static List<PsiElement> collectToRemoveMethod(RubyMemberInfo member) {
        List<PsiElement> visibility;
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement element = member.getMember();
        if ((element = RubyClassMembersPsiHelper.removeWithWhitespaces(element, result, false)) == null || RubyClassMembersPsiHelper.isAccessCall(element)) {
            for (element = ((RPsiElement)member.getMember()).getPrevSibling(); element != null && RefactoringPsiHelper.isExtendedWhitespace(element); element = element.getPrevSibling()) {
            }
            if (RubyClassMembersPsiHelper.isAccessCall(element)) {
                RubyClassMembersPsiHelper.removeWithWhitespaces(element, result, false);
            }
        }
        if ((visibility = RubyClassMembersPsiHelper.findStandaloneVisibility(member)) != null) {
            result.addAll(visibility);
        }
        return result;
    }

    @Nullable
    private static PsiElement removeWithWhitespaces(@NotNull PsiElement element, @NotNull ArrayList<? super PsiElement> result, boolean isRemoveMultiWhitespaces) {
        if (element == null) {
            RubyClassMembersPsiHelper.$$$reportNull$$$0(2);
        }
        if (result == null) {
            RubyClassMembersPsiHelper.$$$reportNull$$$0(3);
        }
        result.add((PsiElement)element);
        PsiElement prev = element;
        for (element = element.getNextSibling(); element != null && RefactoringPsiHelper.isExtendedWhitespace(element); element = element.getNextSibling()) {
            if (!(element instanceof PsiComment || !isRemoveMultiWhitespaces && prev instanceof PsiComment)) {
                result.add((PsiElement)element);
            }
            prev = element;
        }
        return element;
    }

    @Nullable
    private static List<PsiElement> findStandaloneVisibility(RubyMemberInfo member) {
        RContainer clazz = member.getContainingClass();
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz);
        if (symbol == null) {
            return null;
        }
        for (PsiElement element : symbol.getAllDeclarations(null)) {
            if (!(element instanceof RContainer)) continue;
            for (RPsiElement statement : ((RContainer)element).getStatements()) {
                List<PsiElement> elements;
                if (!(statement instanceof RCall) || !(((RCall)statement).getCallType() instanceof RubyVisibilityCallTypeImpl) || (elements = RubyClassMembersPsiHelper.findVisibilityElements(member, (RCall)statement)) == null) continue;
                return elements;
            }
        }
        return null;
    }

    @Nullable
    private static List<PsiElement> findVisibilityElements(RubyMemberInfo member, RCall statement) {
        List args = statement.getArguments();
        if (args.isEmpty()) {
            return null;
        }
        if (args.size() == 1 && RubyClassMembersPsiHelper.isVisibilityArgument(member, (RPsiElement)args.get(0))) {
            return Collections.singletonList(statement);
        }
        for (int i = 0; i < args.size(); ++i) {
            RPsiElement arg = (RPsiElement)args.get(i);
            if (!RubyClassMembersPsiHelper.isVisibilityArgument(member, arg)) continue;
            if (i == args.size() - 1) {
                return RubyClassMembersPsiHelper.collectLastArgument((PsiElement)arg);
            }
            return RubyClassMembersPsiHelper.collectNonLastArgument((PsiElement)arg);
        }
        return null;
    }

    private static boolean isVisibilityArgument(RubyMemberInfo member, RPsiElement arg) {
        String name = ((RPsiElement)member.getMember()).getName();
        String argName = arg instanceof RSymbol ? ((RPsiElement)((RSymbol)arg).getContent()).getName() : (arg instanceof RStringLiteral ? arg.getName() : null);
        return name != null && name.equals(argName);
    }

    private static boolean isAccessCall(PsiElement element) {
        return RubyClassMembersPsiHelper.isAccessCall(element, null);
    }

    private static boolean isAccessCall(@Nullable PsiElement element, @Nullable String access) {
        String text = element instanceof RIdentifier ? element.getText() : null;
        return text != null && (access == null && ("public".equals(text) || "protected".equals(text) || "private".equals(text)) || text.equals(access));
    }

    private static List<PsiElement> collectToRemoveInclude(RubyMemberInfo member) {
        RPsiElement arg = (RPsiElement)member.getMember();
        RCall call = RubyPsiUtil.getCoveringRCall((PsiElement)arg);
        assert (call != null) : "Can't get covering call: member = [" + String.valueOf((Object)member) + "]arg = [" + (arg == null ? null : arg.getText()) + "]";
        List arguments = call.getArguments();
        if (arguments.size() == 1) {
            return Collections.singletonList(call);
        }
        return arguments.get(arguments.size() - 1) == arg ? RubyClassMembersPsiHelper.collectLastArgument((PsiElement)arg) : RubyClassMembersPsiHelper.collectNonLastArgument((PsiElement)arg);
    }

    private static List<PsiElement> collectNonLastArgument(PsiElement element) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        result.add(element);
        element = element.getNextSibling();
        while (element instanceof PsiWhiteSpace) {
            result.add(element);
            element = element.getNextSibling();
        }
        if (element != null && ",".equals(element.getText())) {
            result.add(element);
            element = element.getNextSibling();
        }
        while (element instanceof PsiWhiteSpace) {
            result.add(element);
            element = element.getNextSibling();
        }
        return result;
    }

    private static List<PsiElement> collectLastArgument(PsiElement element) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        result.add(element);
        element = element.getPrevSibling();
        while (element instanceof PsiWhiteSpace) {
            result.add(element);
            element = element.getPrevSibling();
        }
        if (element != null && element.getNode().getElementType() == RubyTokenTypes.tCOMMA) {
            result.add(element);
            element = element.getPrevSibling();
        }
        while (element instanceof PsiWhiteSpace) {
            result.add(element);
            element = element.getPrevSibling();
        }
        return result;
    }

    private static void reformat(List<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return;
        }
        PsiElement first = elements.get(0);
        int startOffset = first.getTextRange().getStartOffset();
        int endOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset();
        PsiFile file = first.getContainingFile();
        PsiFile baseFile = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage());
        assert (baseFile != null);
        CodeStyleManager.getInstance((Project)first.getProject()).reformatText(baseFile, startOffset, endOffset);
    }

    private static Pair<PsiElement, Boolean> findAnchor(RContainer toClass, String access) {
        List elements = toClass.getStatements();
        if ("public".equals(access) && !elements.isEmpty()) {
            return Pair.create((Object)((PsiElement)elements.get(0)), (Object)false);
        }
        for (RPsiElement element : elements) {
            int index;
            if (!RubyClassMembersPsiHelper.isAccessCall((PsiElement)element, access) || (index = elements.indexOf(element)) + 1 >= elements.size()) continue;
            return Pair.create((Object)((PsiElement)elements.get(index + 1)), (Object)false);
        }
        return Pair.create((Object)RubyClassMembersPsiHelper.findDefaultAnchor(toClass), (Object)true);
    }

    @Nullable
    public static PsiElement findDefaultAnchor(RContainer toClass) {
        PsiElement lastChild = toClass.getLastChild();
        return lastChild != null ? lastChild.getPrevSibling() : null;
    }

    private static String prepareStatements(RubyMemberInfo member, String access, boolean createClass, boolean insertModifier, boolean isStatic) {
        StringBuilder builder2 = new StringBuilder();
        if (createClass) {
            builder2.append("class Foo\n");
        }
        if (insertModifier && !"public".equals(access)) {
            builder2.append(access).append('\n').append('\n');
        }
        for (PsiComment comment : member.getComments()) {
            builder2.append(comment.getText()).append('\n');
        }
        RPsiElement element = (RPsiElement)member.getMember();
        if (element instanceof RConstant) {
            builder2.append(member.getDisplayName()).append('\n');
        } else {
            String text = element.getText();
            if (!isStatic) {
                builder2.append(text);
            } else {
                builder2.append(text.replaceFirst("^\\s*def\\s*(self|a-zA-Z:)\\.", "def "));
            }
            builder2.append('\n');
        }
        for (RAliasStatement alias : member.getAliases()) {
            builder2.append(alias.getText()).append('\n');
        }
        if (createClass) {
            builder2.append("end");
        }
        return builder2.toString();
    }

    private static List<? extends PsiElement> gatherMembersWithComments(List<? extends PsiElement> elements) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement psiElement : elements) {
            result.addAll(RubyCommentsUtilCore.getPsiComments((PsiElement)psiElement));
            result.add(psiElement);
        }
        return result;
    }

    private static String prepareStatementsRec(String[] fqn, Collection<? extends RubyMemberInfo> members, String type, boolean isStatic, int index) {
        boolean last = index == fqn.length - 1;
        String insertType = last ? type : "module";
        String body = last ? RubyClassMembersPsiHelper.prepareBody(members, isStatic) : RubyClassMembersPsiHelper.prepareStatementsRec(fqn, members, type, isStatic, index + 1);
        return insertType + " " + fqn[index] + "\n" + body + "end\n";
    }

    private static String prepareBody(Collection<? extends RubyMemberInfo> members, boolean isStatic) {
        ArrayList pub = new ArrayList();
        ArrayList prot = new ArrayList();
        ArrayList priv = new ArrayList();
        RubyClassMembersPsiHelper.splitByAccess(members, pub, prot, priv);
        StringBuilder builder2 = new StringBuilder();
        for (RubyMemberInfo member : pub) {
            builder2.append(RubyClassMembersPsiHelper.prepareStatements(member, "public", false, false, isStatic));
        }
        if (!prot.isEmpty()) {
            builder2.append("\n\nprotected\n");
            for (RubyMemberInfo member : prot) {
                builder2.append(RubyClassMembersPsiHelper.prepareStatements(member, "protected", false, false, isStatic));
            }
        }
        if (!priv.isEmpty()) {
            builder2.append("\n\nprivate\n");
            for (RubyMemberInfo member : priv) {
                builder2.append(RubyClassMembersPsiHelper.prepareStatements(member, "private", false, false, isStatic));
            }
        }
        return builder2.toString();
    }

    public static void removeContainer(RContainer container) {
        RubyPsiUtil.removeElements(new PsiElement[]{container});
    }

    public static void removeComments(@NotNull List<? extends PsiComment> comments) {
        if (comments == null) {
            RubyClassMembersPsiHelper.$$$reportNull$$$0(4);
        }
        if (comments.isEmpty()) {
            return;
        }
        ArrayList whitespacesToRemove = new ArrayList();
        RubyClassMembersPsiHelper.removeWithWhitespaces((PsiElement)comments.get(0), whitespacesToRemove, true);
        RubyPsiUtil.removeElements(whitespacesToRemove.toArray(PsiElement.EMPTY_ARRAY));
        RubyPsiUtil.removeElements(comments.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubyClassMembersPsiHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDirectoryIfMissing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeWithWhitespaces";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

