/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.util.NlsSafe;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;

public class RubyClassCellRenderer
extends DefaultListCellRenderer {
    private final boolean myShowReadOnly;

    public RubyClassCellRenderer() {
        this.setOpaque(true);
        this.myShowReadOnly = true;
    }

    public RubyClassCellRenderer(boolean showReadOnly) {
        this.setOpaque(true);
        this.myShowReadOnly = showReadOnly;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        return RubyClassCellRenderer.customizeRenderer(this, value, this.myShowReadOnly);
    }

    public static JLabel customizeRenderer(JLabel cellRendererComponent, Object value, boolean showReadOnly) {
        Icon icon;
        RContainer aClass = (RContainer)value;
        cellRendererComponent.setText(RubyClassCellRenderer.getClassText(aClass));
        int flags = 1;
        if (showReadOnly) {
            flags |= 2;
        }
        if ((icon = aClass.getIcon(flags)) != null) {
            cellRendererComponent.setIcon(icon);
        }
        return cellRendererComponent;
    }

    @NlsSafe
    public static String getClassText(RContainer aClass) {
        String qualifiedName = aClass instanceof RClass ? RubyClassResolveUtil.getQualifiedName((RClass)aClass) : ((RModule)aClass).getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        return aClass.getName();
    }
}

