/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring;

import com.intellij.psi.tree.IElementType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RDefinedStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RRescueModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;

public final class RubyReplaceExpressionUtil {
    private static final Map<IElementType, Integer> OPERATOR_PRECEDENCES = Map.ofEntries(Map.entry(RubyTokenTypes.kOR, 2), Map.entry(RubyTokenTypes.kAND, 2), Map.entry(RubyTokenTypes.tDOT2, 8), Map.entry(RubyTokenTypes.tDOT3, 8), Map.entry(RubyTokenTypesCore.tOR, 9), Map.entry(RubyTokenTypesCore.tAND, 10), Map.entry(RubyTokenTypes.tCMP, 11), Map.entry(RubyTokenTypesCore.tEQ, 11), Map.entry(RubyTokenTypes.tEQQ, 11), Map.entry(RubyTokenTypes.tNEQ, 11), Map.entry(RubyTokenTypes.tMATCH, 11), Map.entry(RubyTokenTypes.tNMATCH, 11), Map.entry(RubyTokenTypes.tLT, 12), Map.entry(RubyTokenTypes.tLEQ, 12), Map.entry(RubyTokenTypes.tGT, 12), Map.entry(RubyTokenTypes.tGEQ, 12), Map.entry(RubyTokenTypes.tBIT_OR, 13), Map.entry(RubyTokenTypes.tXOR, 13), Map.entry(RubyTokenTypes.tBIT_AND, 14), Map.entry(RubyTokenTypes.tRSHFT, 15), Map.entry(RubyTokenTypes.tLSHFT, 15), Map.entry(RubyTokenTypes.tPLUS, 16), Map.entry(RubyTokenTypes.tMINUS, 16), Map.entry(RubyTokenTypes.tMULT, 17), Map.entry(RubyTokenTypes.tDIV, 17), Map.entry(RubyTokenTypes.tPERC, 17), Map.entry(RubyTokenTypes.tPOW, 19));
    private static final int MAX_PRIORITY = 100;

    public static boolean isNeedParenthesis(@NotNull RPsiElement oldExpr, @NotNull RPsiElement newExpr) {
        RBinaryExpression binaryExpression;
        if (oldExpr == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(0);
        }
        if (newExpr == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(1);
        }
        RPsiElement parentExpr = (RPsiElement)oldExpr.getParent();
        int newPriority = RubyReplaceExpressionUtil.getExpressionPriority(newExpr);
        int parentPriority = RubyReplaceExpressionUtil.getExpressionPriority(parentExpr);
        if (parentPriority > newPriority) {
            return true;
        }
        return parentPriority == newPriority && parentPriority != 100 && parentExpr instanceof RBinaryExpression && RubyReplaceExpressionUtil.isNotAssociative(binaryExpression = (RBinaryExpression)parentExpr) && oldExpr.equals((Object)binaryExpression.getRightOperand());
    }

    public static int getBinaryTypePriority(@NotNull IElementType opType) {
        if (opType == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(2);
        }
        return OPERATOR_PRECEDENCES.getOrDefault(opType, 100);
    }

    public static boolean isNotAssociative(@NotNull RBinaryExpression binaryExpression) {
        IElementType opType;
        if (binaryExpression == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(3);
        }
        return (opType = RubyReplaceExpressionUtil.getOperationType((RExpression)binaryExpression)) == RubyTokenTypes.tCMP || opType == RubyTokenTypesCore.tEQ || opType == RubyTokenTypes.tEQQ || opType == RubyTokenTypes.tNEQ || opType == RubyTokenTypes.tMATCH || opType == RubyTokenTypes.tNMATCH || binaryExpression instanceof RRangeExpression;
    }

    public static int getExpressionPriority(@NotNull RPsiElement expr) {
        IElementType opType;
        if (expr == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(4);
        }
        int priority = 100;
        if (expr instanceof RCompoundStatement || expr instanceof RCondition) {
            priority = 0;
        }
        if (expr instanceof RIfModStatement || expr instanceof RUnlessModStatement || expr instanceof RWhileModStatement || expr instanceof RUntilModStatement || expr instanceof RListOfExpressions) {
            priority = 1;
        }
        if (expr instanceof RDefinedStatement) {
            priority = 4;
        }
        if (expr instanceof RAssignmentExpression) {
            priority = 5;
        }
        if (expr instanceof RRescueModStatement) {
            priority = 6;
        }
        if (expr instanceof RTernaryExpression) {
            priority = 7;
        }
        if (expr instanceof RRangeExpression) {
            priority = 8;
        }
        if (expr instanceof RUnaryExpression) {
            opType = RubyReplaceExpressionUtil.getOperationType((RExpression)expr);
            if (opType == RubyTokenTypes.kNOT) {
                priority = 3;
            }
            if (opType == RubyTokenTypes.tUMINUS || opType == RubyTokenTypes.tUMINUS_OP) {
                priority = 18;
            }
            if (opType == RubyTokenTypes.tEXCLAMATION || opType == RubyTokenTypes.tUTILDE_OP || opType == RubyTokenTypes.tUPLUS_OP || opType == RubyTokenTypes.tUPLUS) {
                priority = 20;
            }
        }
        if (expr instanceof RBinaryExpression) {
            opType = RubyReplaceExpressionUtil.getOperationType((RExpression)expr);
            priority = RubyReplaceExpressionUtil.getBinaryTypePriority(opType);
        }
        assert (priority <= 100);
        return priority;
    }

    @NotNull
    private static IElementType getOperationType(@NotNull RExpression expr) {
        if (expr == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(5);
        }
        if (expr instanceof RBinaryExpression) {
            IElementType iElementType = ((RBinaryExpression)expr).getOperationType();
            if (iElementType == null) {
                RubyReplaceExpressionUtil.$$$reportNull$$$0(6);
            }
            return iElementType;
        }
        IElementType iElementType = ((RUnaryExpression)expr).getOperationType();
        if (iElementType == null) {
            RubyReplaceExpressionUtil.$$$reportNull$$$0(7);
        }
        return iElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/RubyReplaceExpressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/RubyReplaceExpressionUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNeedParenthesis";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryTypePriority";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNotAssociative";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionPriority";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOperationType";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

