/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RBoolMatchingImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RubyRefactoringUtil {
    public static final Set<String> KEYWORDS;
    private static final NotNullLazyValue<TokenSet> TYPES_TO_IGNORE;

    private RubyRefactoringUtil() {
    }

    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull RPsiElement pattern, @Nullable RPsiElement context) {
        if (pattern == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyRefactoringUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        RubyElementVisitor visitor = new RubyElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof RArgument || element instanceof RBlockArgumentList) {
                    return;
                }
                if (PsiEquivalenceUtil.areEquivalent((PsiElement)element, (PsiElement)pattern, (o1, o2) -> {
                    if (o1 instanceof RIdentifier) {
                        RIdentifier id1 = (RIdentifier)o1;
                        if (o2 instanceof RIdentifier) {
                            RIdentifier id2 = (RIdentifier)o2;
                            if (o1.getText().equals(o2.getText()) && id1.isLocalVariable() && id2.isLocalVariable()) {
                                return true;
                            }
                        }
                    }
                    if (o1 != null && PsiTreeUtil.isAncestor((PsiElement)pattern, (PsiElement)o1, (boolean)false) || o2 != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)o2, (boolean)false)) {
                        return true;
                    }
                    return pattern.getReference() != null && ResolveUtil.isReferenceTo(pattern.getReference(), element) || element.getReference() != null && ResolveUtil.isReferenceTo(element.getReference(), (PsiElement)pattern);
                }, (boolean)false)) {
                    occurrences.add(element);
                    return;
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/refactoring/RubyRefactoringUtil$1", "visitElement"));
            }
        };
        context.acceptChildren((PsiElementVisitor)visitor);
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static Map<PsiElement, TextRange> getSubstringOccurrences(@NotNull String pattern, @Nullable RPsiElement context) {
        if (pattern == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(3);
        }
        HashMap<PsiElement, TextRange> results = new HashMap<PsiElement, TextRange>();
        if (context == null) {
            HashMap<PsiElement, TextRange> hashMap = results;
            if (hashMap == null) {
                RubyRefactoringUtil.$$$reportNull$$$0(4);
            }
            return hashMap;
        }
        FindManager findManager = FindManager.getInstance((Project)context.getProject());
        FindModel findModel = findManager.getFindInFileModel().clone();
        findModel.setCaseSensitive(true);
        findModel.setRegularExpressions(false);
        findModel.setStringToFind(pattern);
        String text = context.getText();
        int offset = context.getTextRange().getStartOffset();
        FindResult result = findManager.findString((CharSequence)text, 0, findModel);
        while (result.isStringFound()) {
            int start = result.getStartOffset();
            int end = result.getEndOffset();
            RStringLiteral literalExpression = (RStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)context.findElementAt(start), RStringLiteral.class);
            if (RubyRefactoringUtil.isInterpolationAllowed((PsiElement)literalExpression) && RubyRefactoringUtil.isSubstring(context, start, end) && !results.containsKey(literalExpression)) {
                int substringOffset = literalExpression.getTextRange().getStartOffset() - offset;
                results.put((PsiElement)literalExpression, new TextRange(start - substringOffset, end - substringOffset));
            }
            result = findManager.findString((CharSequence)text, result.getEndOffset(), findModel);
        }
        HashMap<PsiElement, TextRange> hashMap = results;
        if (hashMap == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private static boolean isSubstring(@NotNull RPsiElement element, int startOffset, int endOffset) {
        if (element == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(6);
        }
        PsiElement element1 = element.findElementAt(startOffset);
        PsiElement element2 = element.findElementAt(endOffset - 1);
        return element1 != null && element1 == element2 && RubyRefactoringUtil.isInterpolationAllowed(element1.getParent());
    }

    @Nullable
    public static RMethod findMethodBySignature(RContainer clazz, RMethod method, boolean checkBases) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz);
        return RubyRefactoringUtil.findMethodBySignature(symbol, method, checkBases);
    }

    private static RMethod findMethodBySignature(Symbol symbol, RMethod method, boolean checkBases) {
        RMethod bySignature;
        Symbol superClassSymbol;
        if (symbol == null) {
            return null;
        }
        for (PsiElement element : symbol.getAllDeclarations((PsiElement)method)) {
            RMethod found;
            if (!(element instanceof RClass) || (found = RubyRefactoringUtil.findMethod((RClass)element, method)) == null) continue;
            return found;
        }
        if (checkBases && (superClassSymbol = ((ClassModuleSymbol)symbol).getSuperClassSymbol((PsiElement)method)) != null && (bySignature = RubyRefactoringUtil.findMethodBySignature(superClassSymbol, method, true)) != null) {
            return bySignature;
        }
        return null;
    }

    @Nullable
    private static RMethod findMethod(RClass clazz, RMethod method) {
        for (RPsiStructureElement element : clazz.getStructureElements()) {
            if (!(element instanceof RMethod) || !RubyRefactoringUtil.areConflictingMethods(method, (RMethod)element)) continue;
            return (RMethod)element;
        }
        return null;
    }

    public static boolean areConflictingMethods(RMethod method, RMethod element) {
        int argumentsCount = method.getArgumentInfos().size();
        String methodName = method.getName();
        return Comparing.strEqual((String)element.getName(), (String)methodName) && element.getArgumentInfos().size() == argumentsCount;
    }

    public static String getNewFileName(@NotNull String newName, @Nullable Module module) {
        if (newName == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(7);
        }
        return NamingConventions.toUnderscoreCase((String)newName, (Module)module) + ".rb";
    }

    @NotNull
    public static RPsiElement negateExpression(@NotNull PsiElement expression) {
        IElementType op;
        IElementType negOp;
        RPsiElement underNegation;
        if (expression == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(8);
        }
        if (expression instanceof RBoolNegExpression && (underNegation = ((RBoolNegExpression)expression).getElement()) != null) {
            if (underNegation instanceof RGroupedExpression && ((RGroupedExpression)underNegation).getExpression() != null) {
                RPsiElement rPsiElement = ((RGroupedExpression)underNegation).getExpression();
                if (rPsiElement == null) {
                    RubyRefactoringUtil.$$$reportNull$$$0(9);
                }
                return rPsiElement;
            }
            RPsiElement rPsiElement = underNegation;
            if (rPsiElement == null) {
                RubyRefactoringUtil.$$$reportNull$$$0(10);
            }
            return rPsiElement;
        }
        if (expression instanceof RPseudoConstant) {
            String text = expression.getText();
            if (RubyTokenTypesCore.kTRUE.toString().equals(text)) {
                RPsiElement rPsiElement = RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)RubyTokenTypesCore.kFALSE.toString());
                if (rPsiElement == null) {
                    RubyRefactoringUtil.$$$reportNull$$$0(11);
                }
                return rPsiElement;
            }
            if (RubyTokenTypesCore.kFALSE.toString().equals(text) || RubyTokenTypesCore.kNIL.toString().equals(text)) {
                RPsiElement rPsiElement = RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)RubyTokenTypesCore.kTRUE.toString());
                if (rPsiElement == null) {
                    RubyRefactoringUtil.$$$reportNull$$$0(12);
                }
                return rPsiElement;
            }
        }
        if (expression instanceof RBoolMatchingExpression && (negOp = RBoolMatchingImpl.getOppositeOperation((IElementType)(op = ((RBoolMatchingExpression)expression).getOperationType()))) != null) {
            RPsiElement rightOperand = ((RBoolMatchingExpression)expression).getRightOperand();
            RPsiElement rPsiElement = RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)(((RBoolMatchingExpression)expression).getLeftOperand().getText() + " " + negOp.toString() + " " + (rightOperand != null ? rightOperand.getText() : "")));
            if (rPsiElement == null) {
                RubyRefactoringUtil.$$$reportNull$$$0(13);
            }
            return rPsiElement;
        }
        RPsiElement negationWithParens = RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)("!(" + expression.getText() + ")"));
        if (negationWithParens instanceof RBoolNegExpression && expression instanceof RPsiElement) {
            RPsiElement element = ((RBoolNegExpression)negationWithParens).getElement();
            assert (element != null);
            RPsiElement rPsiElement = RubyReplaceExpressionUtil.isNeedParenthesis(element, (RPsiElement)expression) ? negationWithParens : RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)("!" + expression.getText()));
            if (rPsiElement == null) {
                RubyRefactoringUtil.$$$reportNull$$$0(14);
            }
            return rPsiElement;
        }
        RPsiElement rPsiElement = negationWithParens;
        if (rPsiElement == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(15);
        }
        return rPsiElement;
    }

    public static boolean isTypeToIgnore(@NotNull IElementType type) {
        if (type == null) {
            RubyRefactoringUtil.$$$reportNull$$$0(16);
        }
        return ((TokenSet)TYPES_TO_IGNORE.getValue()).contains(type);
    }

    public static boolean isInterpolationAllowed(@Nullable PsiElement element) {
        if (element instanceof RStringLiteralBase) {
            return ((RStringLiteralBase)element).supportsInterpolation();
        }
        return false;
    }

    static {
        TYPES_TO_IGNORE = NotNullLazyValue.lazy(() -> TokenSet.orSet((TokenSet[])new TokenSet[]{RubySpaceUtil.ALL_WHITESPACES, TokenBNF.tOPS, RubyTokenSets.getTWHITESPACES()}));
        KEYWORDS = new HashSet<String>();
        for (IElementType type : TokenBNF.kALL_KEYWORDS.getTypes()) {
            KEYWORDS.add(type.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/RubyRefactoringUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/RubyRefactoringUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstringOccurrences";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "negateExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubstringOccurrences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSubstring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "negateExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTypeToIgnore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

