/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.presentation;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.erb.psi.ErbRubyFile;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyInsertHandlerExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.MethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyAbstractMethodInsertHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyMethodInsertHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyPsiLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.FieldType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.presentation.RConstantPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtilCore;
import org.jetbrains.plugins.ruby.ruby.presentation.RFieldAttrPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RFieldPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;

public final class SymbolLookupUtil {
    private static final Map<String, RubyCompletionGrouping> GROUPING_RULE_BY_OWNER = new HashMap<String, RubyCompletionGrouping>();
    private static final Map<Type, RubyCompletionGrouping> GROUPING_RULE_BY_KIND = new HashMap<Type, RubyCompletionGrouping>();
    private static final Map<Type, IconComputable> ICON_BY_KIND = new HashMap<Type, IconComputable>();

    private SymbolLookupUtil() {
    }

    @Nullable
    public static LookupElement createLookupItemBySymbol(@NotNull Symbol symbol, @Nullable Symbol birthTypeSymbol, @Nullable RType originalType, @NotNull String name, boolean bold, boolean showModulesFirst, boolean isInsertHandlerCanBeApplied) {
        MethodInsertHandlerCreator insertHandler;
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SymbolLookupUtil.$$$reportNull$$$0(1);
        }
        FQN symbolFQN = symbol.getFQNWithNesting();
        Type type = symbol.getType();
        if (Types.METHODS_LIKE.contains(type)) {
            RubyInsertHandlerExtensionsManager manager = RubyInsertHandlerExtensionsManager.getInstance();
            insertHandler = manager.getHandlerFor(symbol);
        } else {
            insertHandler = null;
        }
        LookupElement lookupElement = null;
        for (RubyCompletionProvider provider : RubyCompletionProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            lookupElement = provider.createLookupItem(symbol, name, bold, birthTypeSymbol, originalType, isInsertHandlerCanBeApplied, insertHandler, symbolFQN);
            if (lookupElement == null) continue;
            break;
        }
        if (lookupElement == null) {
            lookupElement = SymbolLookupUtil.createLookupItemImpl(symbol, originalType, name, bold, isInsertHandlerCanBeApplied, insertHandler);
        }
        if (showModulesFirst && lookupElement instanceof PrioritizedLookupElement) {
            int grouping = (int)((PrioritizedLookupElement)lookupElement).getPriority();
            if (grouping == RubyCompletionGrouping.MODULE_OR_CLASS.getValue()) {
                return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.MODULE_OR_CLASS_IN_COLON_REF.getValue());
            }
            if (grouping == RubyCompletionGrouping.CONSTS.getValue() || grouping == RubyCompletionGrouping.BOLDED.getValue() && type == Type.CONSTANT) {
                return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.CONSTS_IN_COLON_REF.getValue());
            }
        }
        return lookupElement;
    }

    @Nullable
    public static LookupElement createLookupItemImpl(@NotNull Symbol symbol, RType originalType, @NotNull String name, boolean bold, boolean isInsertHandlerCanBeApplied, @Nullable MethodInsertHandlerCreator insertHandlerCreator) {
        RubyLookupElement result;
        Icon icon;
        Type type;
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            SymbolLookupUtil.$$$reportNull$$$0(3);
        }
        if ((type = symbol.getType()) == Type.FILE) {
            return null;
        }
        if (StringUtil.isEmpty((String)name) || name.endsWith("IntellijIdeaRulezzz")) {
            return null;
        }
        RubyLookupElement variableAccess = SymbolLookupUtil.createLocalVariableAccess(name, bold, type);
        if (variableAccess != null) {
            return bold ? PrioritizedLookupElement.withPriority((LookupElement)variableAccess, (double)RubyCompletionGrouping.BOLDED.getValue()) : variableAccess;
        }
        PsiElement lastDeclaration = SymbolLookupUtil.getSymbolOriginalElement(symbol);
        RContainer container = !(lastDeclaration instanceof RangeInDocumentFakePsiElement) ? RubyPsiUtilCore.getParentContainer((PsiElement)lastDeclaration) : null;
        String tailText = null;
        InsertHandler insertHandler = null;
        if (Types.METHODS_LIKE.contains(symbol.getType()) && !(symbol instanceof MultiSymbol)) {
            Pair<String, InsertHandler<RubyLookupElement>> tailTextAndHandler = SymbolLookupUtil.getTailTextAndInsertHandler(symbol, lastDeclaration, isInsertHandlerCanBeApplied, insertHandlerCreator);
            tailText = (String)tailTextAndHandler.getFirst();
            insertHandler = (InsertHandler)tailTextAndHandler.second;
        }
        if (lastDeclaration instanceof RGlobalVariable) {
            bold = true;
        }
        if (lastDeclaration instanceof RField) {
            name = RFieldPresentationUtil.getFieldName((RField)((RField)lastDeclaration));
        }
        Symbol parent = symbol.getParentSymbol();
        String parentSymbolFQN = RContainerPresentationUtil.getPresentableSymbolName((Symbol)parent, (PsiElement)lastDeclaration);
        RubyCompletionGrouping grouping = SymbolLookupUtil.deterMineGroupingRule(parentSymbolFQN, symbol, bold, type, originalType);
        String typeText = null;
        if (symbol instanceof MultiSymbol) {
            typeText = "\u2026";
        } else if (lastDeclaration instanceof RGlobalVariable) {
            typeText = SymbolLookupUtil.extractHelpForGlobalVariable(lastDeclaration);
        } else if ("Object".equals(parentSymbolFQN) && container instanceof RFile) {
            typeText = ((RFile)container).getName();
        } else if (!Types.MODULE_OR_CLASS.contains(symbol.getType()) || !"Object".equals(parentSymbolFQN)) {
            typeText = parentSymbolFQN;
        }
        Icon explicitIcon = symbol.getExplicitIcon();
        Icon icon2 = icon = explicitIcon == null ? SymbolLookupUtil.getLookupItemIcon(symbol.getType(), lastDeclaration) : explicitIcon;
        RubyLookupElement rubyLookupElement = lastDeclaration != null ? (insertHandler != null ? new RubyPsiLookupElement(name, tailText, typeText, lastDeclaration, bold, icon, (InsertHandler<RubyLookupElement>)insertHandler) : new RubyPsiLookupElement(name, tailText, typeText, lastDeclaration, bold, icon)) : (result = insertHandler != null ? new RubyLookupElement(name, tailText, typeText, bold, icon, null, (InsertHandler<RubyLookupElement>)insertHandler) : new RubyLookupElement(name, tailText, typeText, bold, icon, null));
        int myGroupNumber = grouping == null ? (bold ? RubyCompletionGrouping.BOLDED.getValue() : RubyCompletionGrouping.GENERAL.getValue()) : (grouping == RubyCompletionGrouping.GENERAL || grouping == RubyCompletionGrouping.CONSTS ? (bold ? RubyCompletionGrouping.BOLDED.getValue() : grouping.getValue()) : (bold && grouping == RubyCompletionGrouping.INSTANCE_FIELDS ? RubyCompletionGrouping.INSTANCE_FIELDS_BOLD.getValue() : grouping.getValue()));
        return PrioritizedLookupElement.withPriority((LookupElement)result, (double)myGroupNumber);
    }

    @Nullable
    public static PsiElement getSymbolOriginalElement(@NotNull Symbol symbol) {
        PsiElement psiElement;
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(4);
        }
        return (psiElement = symbol.getPsiElement()) == null ? null : CompletionUtil.getOriginalElement((PsiElement)psiElement);
    }

    private static Pair<String, InsertHandler<RubyLookupElement>> getTailTextAndInsertHandler(@NotNull Symbol symbol, @Nullable PsiElement lastDeclaration, boolean isInsertHandlerCanBeApplied, @Nullable MethodInsertHandlerCreator insertHandlerCreator) {
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(5);
        }
        Object tailText = null;
        RubyMethodInsertHandler insertHandler = null;
        Type symbolType = symbol.getType();
        if (Types.METHODS_LIKE.contains(symbolType)) {
            List argumentInfos = lastDeclaration instanceof RMethod ? ((RMethod)lastDeclaration).getArgumentInfos() : (symbol instanceof RMethodSymbol ? ContainerUtil.notNullize((List)((RMethodSymbol)symbol).getArgumentInfos()) : Collections.emptyList());
            tailText = ArgumentInfoPresentation.getPresentableString(symbol.getProject(), argumentInfos, ArgumentInfoPresentation.NO_VALUES);
            if ("*several_variants".equals(tailText)) {
                tailText = "(*args)";
            } else if (StringUtil.isNotEmpty((String)tailText)) {
                tailText = "(" + (String)tailText + ")";
            }
            insertHandler = SymbolLookupUtil.getInsertHandler(symbol, (RPsiElement)ObjectUtils.tryCast((Object)lastDeclaration, RPsiElement.class), isInsertHandlerCanBeApplied, insertHandlerCreator);
        }
        Pair tailTextAndHandler = Pair.create(tailText, insertHandler);
        return tailTextAndHandler;
    }

    public static LookupElement createLookupItemForMethod(@NotNull String name, @Nullable PsiElement lastDeclaration, boolean bold, @NotNull String typeText, @NotNull RubyCompletionGrouping group, @Nullable Icon icon, @NotNull Symbol symbol, boolean isInsertHandlerCanBeApplied, @Nullable MethodInsertHandlerCreator insertHandlerCreator) {
        if (name == null) {
            SymbolLookupUtil.$$$reportNull$$$0(6);
        }
        if (typeText == null) {
            SymbolLookupUtil.$$$reportNull$$$0(7);
        }
        if (group == null) {
            SymbolLookupUtil.$$$reportNull$$$0(8);
        }
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(9);
        }
        Pair<String, InsertHandler<RubyLookupElement>> tailTextAndHandler = SymbolLookupUtil.getTailTextAndInsertHandler(symbol, lastDeclaration, isInsertHandlerCanBeApplied, insertHandlerCreator);
        String tailText = (String)tailTextAndHandler.getFirst();
        InsertHandler insertHandler = (InsertHandler)tailTextAndHandler.second;
        RubyPsiLookupElement element = insertHandler != null ? new RubyPsiLookupElement(name, tailText, typeText, lastDeclaration, bold, icon, (InsertHandler<RubyLookupElement>)insertHandler) : new RubyPsiLookupElement(name, tailText, typeText, lastDeclaration, bold, icon);
        return PrioritizedLookupElement.withPriority((LookupElement)element, (double)group.getValue());
    }

    @Nullable
    private static RubyLookupElement createLocalVariableAccess(String name, boolean bold, Type type) {
        if (type == Type.FIELD_WRITE_ACCESS) {
            return new RubyLookupElement(name, null, RBundle.message((String)"field.write"), bold, RubyIcons.Ruby.Nodes.Variable, null);
        }
        if (type == Type.CONSTANT_ACCESS) {
            return new RubyLookupElement(name, null, RBundle.message((String)"constant"), bold, RubyIcons.Ruby.Nodes.NotDefined, null);
        }
        if (type == Type.CALL_ACCESS) {
            return new RubyLookupElement(name, null, RBundle.message((String)"call"), bold, AllIcons.Nodes.Method, null);
        }
        return null;
    }

    @Nullable
    public static RubyCompletionGrouping determineGroupingByType(@NotNull Type type) {
        if (type == null) {
            SymbolLookupUtil.$$$reportNull$$$0(10);
        }
        return GROUPING_RULE_BY_KIND.get(type);
    }

    @Nullable
    private static RubyCompletionGrouping deterMineGroupingRule(@Nullable String parentSymbolFQN, @NotNull Symbol symbol, boolean bold, Type type, @Nullable RType originalType) {
        RubyCompletionGrouping rule;
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(11);
        }
        if (!bold && parentSymbolFQN != null && (rule = GROUPING_RULE_BY_OWNER.get(parentSymbolFQN)) != null) {
            return rule;
        }
        RubyCompletionGrouping rubyCompletionGrouping = rule = type == null ? null : GROUPING_RULE_BY_KIND.get(type);
        if (rule != null) {
            return rule;
        }
        return originalType == null ? null : originalType.getGroupForMember(symbol);
    }

    @Nullable
    private static RubyMethodInsertHandler getInsertHandler(@NotNull Symbol symbol, @Nullable RPsiElement methodDeclaration, boolean isInsertHandlerCanBeApplied, @Nullable MethodInsertHandlerCreator insertHandlerCreator) {
        if (symbol == null) {
            SymbolLookupUtil.$$$reportNull$$$0(12);
        }
        RubyMethodInsertHandler result = isInsertHandlerCanBeApplied && insertHandlerCreator != null ? insertHandlerCreator.createInsertHandler(methodDeclaration) : null;
        String name = symbol.getName();
        if (result == null && name != null && name.endsWith("=")) {
            result = new RubyAbstractMethodInsertHandler(methodDeclaration){

                @Override
                public void handleInsertMethodSignature(InsertionContext context, @Nullable RPsiElement methodDeclaration, String lookupItem) {
                    Editor editor = context.getEditor();
                    int offset = context.getTailOffset();
                    editor.getDocument().insertString(offset - 1, (CharSequence)" ");
                    editor.getCaretModel().moveToOffset(offset + 1);
                }
            };
        }
        return result;
    }

    private static void fillSymbolKind2IconMap() {
        IconComputable classIcon = new IconComputable(){

            @Override
            public Icon compute(@Nullable PsiElement latestDeclaration, Type type) {
                return latestDeclaration != null ? latestDeclaration.getIcon(1) : AllIcons.Nodes.Class;
            }
        };
        ICON_BY_KIND.put(Type.CLASS, classIcon);
        IconComputable moduleIcon = new IconComputable(){

            @Override
            public Icon compute(@Nullable PsiElement latestDeclaration, Type type) {
                return latestDeclaration != null ? latestDeclaration.getIcon(1) : RubyIcons.Ruby.Nodes.Module;
            }
        };
        ICON_BY_KIND.put(Type.MODULE, moduleIcon);
        MethodIconComputable methodIcon = new MethodIconComputable();
        ICON_BY_KIND.put(Type.INSTANCE_METHOD, methodIcon);
        ICON_BY_KIND.put(Type.CLASS_METHOD, methodIcon);
        ICON_BY_KIND.put(Type.ALIAS, new SimpleComputable(AllIcons.Nodes.Alias));
        ICON_BY_KIND.put(Type.INSTANCE_FIELD, new SimpleComputable(RFieldPresentationUtil.createIconForField((FieldType)FieldType.INSTANCE_VARIABLE)));
        ICON_BY_KIND.put(Type.CLASS_FIELD, new SimpleComputable(RFieldPresentationUtil.createIconForField((FieldType)FieldType.CLASS_VARIABLE)));
        IconComputable fieldAttr = new IconComputable(){

            @Override
            public Icon compute(@Nullable PsiElement latestDeclaration, Type type) {
                if (latestDeclaration instanceof RCall) {
                    return latestDeclaration.getIcon(0);
                }
                return type == Type.FIELD_READER ? RFieldAttrPresentationUtil.ATTR_READER_ICON : RFieldAttrPresentationUtil.ATTR_WRITER_ICON;
            }
        };
        ICON_BY_KIND.put(Type.FIELD_READER, fieldAttr);
        ICON_BY_KIND.put(Type.FIELD_WRITER, fieldAttr);
        ICON_BY_KIND.put(Type.CONSTANT, new SimpleComputable(RConstantPresentationUtil.getIcon()));
        ICON_BY_KIND.put(Type.CONSTANT_ACCESS, new SimpleComputable(RContainerPresentationUtilCore.createIconWithAccessSign((Icon)RubyIcons.Ruby.Nodes.Variable, (Visibility)Visibility.PUBLIC)));
        ICON_BY_KIND.put(Type.CALL_ACCESS, new SimpleComputable(RContainerPresentationUtilCore.createIconWithAccessSign((Icon)AllIcons.Nodes.Method, (Visibility)Visibility.PUBLIC)));
        ICON_BY_KIND.put(Type.FIELD_WRITE_ACCESS, new SimpleComputable((Icon)RFieldAttrPresentationUtil.ATTR_WRITER_ICON));
    }

    @Nullable
    public static Icon getLookupItemIcon(@NotNull Type type, @Nullable PsiElement lastDeclaration) {
        NavigationItem navigationItem;
        ItemPresentation presentation;
        Icon icon;
        IconComputable iconBySymbol;
        if (type == null) {
            SymbolLookupUtil.$$$reportNull$$$0(13);
        }
        if ((iconBySymbol = ICON_BY_KIND.get(type)) != null && (icon = iconBySymbol.compute(lastDeclaration, type)) != null) {
            return icon;
        }
        if (lastDeclaration instanceof NavigationItem && (presentation = (navigationItem = (NavigationItem)lastDeclaration).getPresentation()) != null) {
            return presentation.getIcon(false);
        }
        return null;
    }

    @Nullable
    private static String extractHelpForGlobalVariable(PsiElement lastDeclaration) {
        String typeText = RubyCommentsUtilCore.getPsiHelp((PsiElement)lastDeclaration);
        if (typeText != null) {
            int i = (typeText = typeText.substring(1)).indexOf(46);
            if (i != -1) {
                typeText = typeText.substring(0, i);
            }
            if ((i = typeText.indexOf(10)) != -1) {
                typeText = typeText.substring(0, i);
            }
            typeText = typeText.trim();
        }
        return typeText;
    }

    public static void insertAndMoveCaret(String[] linesToInsert, int newCaretColumn, int newCaretLine, InsertionContext context) {
        int i;
        StringBuilder signatureBuff = new StringBuilder();
        if (context.getFile() instanceof ErbRubyFile) {
            String[] adjustedLinesToInsert = new String[linesToInsert.length];
            for (i = 0; i < linesToInsert.length; ++i) {
                adjustedLinesToInsert[i] = linesToInsert[i].replaceAll(" do", " do %>").replaceAll("end", "<% end %>");
            }
            linesToInsert = adjustedLinesToInsert;
        }
        int linesCount = linesToInsert.length;
        for (i = 0; i < linesCount; ++i) {
            if (i != 0) {
                signatureBuff.append('\n');
            }
            signatureBuff.append(linesToInsert[i]);
        }
        String signature = signatureBuff.toString();
        Editor editor = context.getEditor();
        int insertionStartOffset = editor.getCaretModel().getOffset();
        int caretColumn = editor.getCaretModel().getLogicalPosition().column;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)signature);
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
        TextRange myTextRange = new TextRange(insertionStartOffset, insertionStartOffset + signature.length());
        CodeStyleManager.getInstance((Project)context.getProject()).reformatText(context.getFile().getOriginalFile(), myTextRange.getStartOffset(), myTextRange.getEndOffset());
        int offsetInTheEndOfShouldString = linesCount == 1 ? newCaretColumn - linesToInsert[0].length() : caretColumn + newCaretColumn - editor.getCaretModel().getLogicalPosition().column;
        editor.getCaretModel().moveCaretRelatively(offsetInTheEndOfShouldString, newCaretLine - linesCount + 1, false, false, true);
    }

    public static MethodInsertHandlerCreator createNoSignatureHandlerCreator() {
        return new MethodInsertHandlerCreator(){

            @Override
            public RubyMethodInsertHandler createInsertHandler(@Nullable RPsiElement methodDeclaration) {
                return null;
            }
        };
    }

    static {
        GROUPING_RULE_BY_OWNER.put("BasicObject", RubyCompletionGrouping.KERNEL_OR_OBJECT_CHILDREN);
        GROUPING_RULE_BY_OWNER.put("Kernel", RubyCompletionGrouping.KERNEL_OR_OBJECT_CHILDREN);
        GROUPING_RULE_BY_OWNER.put("Object", RubyCompletionGrouping.KERNEL_OR_OBJECT_CHILDREN);
        GROUPING_RULE_BY_OWNER.put("Module", RubyCompletionGrouping.MODULE_OR_CLASS_CHILDREN);
        GROUPING_RULE_BY_OWNER.put("Class", RubyCompletionGrouping.MODULE_OR_CLASS_CHILDREN);
        GROUPING_RULE_BY_KIND.put(Type.LOCAL_VARIABLE, RubyCompletionGrouping.LOCAL_OR_PARAMETER);
        GROUPING_RULE_BY_KIND.put(Type.METHOD_PARAMETER, RubyCompletionGrouping.LOCAL_OR_PARAMETER);
        GROUPING_RULE_BY_KIND.put(Type.INSTANCE_FIELD, RubyCompletionGrouping.INSTANCE_FIELDS);
        GROUPING_RULE_BY_KIND.put(Type.CLASS_FIELD, RubyCompletionGrouping.CLASS_FIELDS);
        GROUPING_RULE_BY_KIND.put(Type.CLASS, RubyCompletionGrouping.MODULE_OR_CLASS);
        GROUPING_RULE_BY_KIND.put(Type.MODULE, RubyCompletionGrouping.MODULE_OR_CLASS);
        GROUPING_RULE_BY_KIND.put(Type.CONSTANT, RubyCompletionGrouping.CONSTS);
        SymbolLookupUtil.fillSymbolKind2IconMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/SymbolLookupUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupItemBySymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupItemImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolOriginalElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTailTextAndInsertHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupItemForMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "determineGroupingByType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "deterMineGroupingRule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getInsertHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getLookupItemIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MethodIconComputable
    implements IconComputable {
        private final NotNullLazyValue<Icon> myPublicInstanceMethodIcon = NotNullLazyValue.lazy(() -> RContainerPresentationUtilCore.createIconWithAccessSign((Icon)AllIcons.Nodes.Method, (Visibility)Visibility.PUBLIC));
        private final NotNullLazyValue<Icon> myPublicClassMethodIcon = NotNullLazyValue.lazy(() -> RContainerPresentationUtilCore.createIconWithAccessSign((Icon)RMethodPresentationUtil.createStaticIcon((Icon)AllIcons.Nodes.Method), (Visibility)Visibility.PUBLIC));

        private MethodIconComputable() {
        }

        @Override
        public Icon compute(@Nullable PsiElement latestDeclaration, Type type) {
            if (latestDeclaration instanceof RMethod) {
                return latestDeclaration.getIcon(1);
            }
            return Type.INSTANCE_METHOD == type ? (Icon)this.myPublicInstanceMethodIcon.getValue() : (Icon)this.myPublicClassMethodIcon.getValue();
        }
    }

    private static class SimpleComputable
    implements IconComputable {
        private final Icon myIcon;

        SimpleComputable(@NotNull Icon icon) {
            if (icon == null) {
                SimpleComputable.$$$reportNull$$$0(0);
            }
            this.myIcon = icon;
        }

        @Override
        public Icon compute(@Nullable PsiElement latestDeclaration, @NotNull Type type) {
            if (type == null) {
                SimpleComputable.$$$reportNull$$$0(1);
            }
            return this.myIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/SymbolLookupUtil$SimpleComputable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface IconComputable {
        public Icon compute(@Nullable PsiElement var1, Type var2);
    }
}

