/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyPostfixUtil {
    private static final Key<Integer> CHOOSE_EXPR_COUNT = Key.create((String)"CHOOSE_EXPR_COUNT");
    public static final String RUBY_POSTFIX_TEMPLATE_GROUP = "Ruby postfix templates";

    @TestOnly
    public static void chooseExprCount(int exprNumber, @NotNull Document document) {
        if (document == null) {
            RubyPostfixUtil.$$$reportNull$$$0(0);
        }
        document.putUserData(CHOOSE_EXPR_COUNT, (Object)exprNumber);
    }

    @Nullable
    public static Integer getExprCount(@NotNull Document document) {
        if (document == null) {
            RubyPostfixUtil.$$$reportNull$$$0(1);
        }
        return (Integer)document.getUserData(CHOOSE_EXPR_COUNT);
    }

    @NotNull
    public static PostfixTemplateExpressionSelector selectorTopmost() {
        return RubyPostfixUtil.selectorTopmost((Condition<PsiElement>)Conditions.alwaysTrue());
    }

    @NotNull
    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset() {
        return RubyPostfixUtil.selectorAllExpressionsWithCurrentOffset((Condition<PsiElement>)Conditions.alwaysTrue());
    }

    @NotNull
    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset(@NotNull Condition<PsiElement> additionalFilter) {
        if (additionalFilter == null) {
            RubyPostfixUtil.$$$reportNull$$$0(2);
        }
        return new PostfixTemplateExpressionSelectorBase(additionalFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                List<PsiElement> expressions = RubyPostfixUtil.getAllExpressionsAtOffset(context.getContainingFile(), offset - 1);
                Integer exprCount = RubyPostfixUtil.getExprCount(document);
                if (ApplicationManager.getApplication().isUnitTestMode() && exprCount != null && expressions.size() > exprCount) {
                    return Collections.singletonList(expressions.get(exprCount));
                }
                return expressions;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/postfix/RubyPostfixUtil$1";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static PostfixTemplateExpressionSelector selectorTopmost(@NotNull Condition<PsiElement> expressionsFilter) {
        if (expressionsFilter == null) {
            RubyPostfixUtil.$$$reportNull$$$0(3);
        }
        return new PostfixTemplateExpressionSelectorBase(expressionsFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                List<PsiElement> expressionsInRange = RubyPostfixUtil.getAllExpressionsAtOffset(context.getContainingFile(), offset - 1);
                return ContainerUtil.createMaybeSingletonList((Object)((PsiElement)ContainerUtil.getLastItem(expressionsInRange)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/postfix/RubyPostfixUtil$2";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static List<PsiElement> getAllExpressionsAtOffset(PsiFile file, int offset) {
        ArrayList<PsiElement> expressions = new ArrayList<PsiElement>();
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset), RExpression.class);
        while (!(element instanceof RCompoundStatement)) {
            if (element != null) {
                expressions.add(element);
            }
            if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, RExpression.class, (boolean)true)) != null) continue;
        }
        ArrayList<PsiElement> arrayList = expressions;
        if (arrayList == null) {
            RubyPostfixUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static PostfixTemplateExpressionSelector selectorIdentifier() {
        return RubyPostfixUtil.selectorAllExpressionsWithCurrentOffset((Condition<PsiElement>)((Condition)element -> element instanceof RIdentifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionsFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/postfix/RubyPostfixUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/postfix/RubyPostfixUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExpressionsAtOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseExprCount";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExprCount";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectorAllExpressionsWithCurrentOffset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectorTopmost";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

