/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.navigation;

import com.intellij.lang.LanguageExtension;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;

public interface RubyAssociatedDeclarationProvider
extends PossiblyDumbAware {
    public static final LanguageExtension<RubyAssociatedDeclarationProvider> EXTENSION = new LanguageExtension("org.jetbrains.plugins.ruby.ruby.associatedDeclarationProvider");
    public static final Class<? extends PsiElement>[] DECLARATION_CLASSES = (Class[])ContainerUtil.ar((Object[])new Class[]{RClass.class, RMethod.class, RModule.class});

    @NotNull
    public List<? extends Symbol> getAssociatedDeclarations(@NotNull Project var1, @NotNull SearchScope var2, @NotNull Symbol var3);

    public boolean isAvailable(@NotNull Project var1, @NotNull PsiFile var2);

    @NotNull
    public static List<? extends Symbol> getParentSignatures(@NotNull PsiFile file, int offset, boolean strict) {
        List signatures;
        if (file == null) {
            RubyAssociatedDeclarationProvider.$$$reportNull$$$0(0);
        }
        if ((signatures = (List)ObjectUtils.doIfNotNull((Object)file.findElementAt(offset), rightElement -> RubyAssociatedDeclarationProvider.getParentSignatures(rightElement, strict))) != null && !signatures.isEmpty()) {
            List list = signatures;
            if (list == null) {
                RubyAssociatedDeclarationProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiElement leftElement = offset > 0 ? file.findElementAt(offset - 1) : null;
        List<Object> list = leftElement != null ? RubyAssociatedDeclarationProvider.getParentSignatures(leftElement, strict) : Collections.emptyList();
        if (list == null) {
            RubyAssociatedDeclarationProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<? extends Symbol> getParentSignatures(@NotNull PsiElement element, boolean strict) {
        PsiSymbolDeclarationService service;
        PsiElement parent;
        if (element == null) {
            RubyAssociatedDeclarationProvider.$$$reportNull$$$0(3);
        }
        if ((parent = PsiTreeUtil.findFirstParent((PsiElement)element, arg_0 -> RubyAssociatedDeclarationProvider.lambda$getParentSignatures$1(service = PsiSymbolDeclarationService.getInstance(), arg_0))) != null) {
            List<Symbol> list = service.getDeclarations(parent).stream().filter(declaration -> !strict || declaration.getAbsoluteRange().intersectsStrict(element.getTextRange())).map(PsiSymbolDeclaration::getSymbol).toList();
            if (list == null) {
                RubyAssociatedDeclarationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiElement declaration2 = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])DECLARATION_CLASSES);
        if (declaration2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyAssociatedDeclarationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        Symbol symbol = PsiSymbolService.getInstance().asSymbol(declaration2);
        if (!(declaration2 instanceof PsiNameIdentifierOwner) || !strict) {
            List<Symbol> list = List.of(symbol);
            if (list == null) {
                RubyAssociatedDeclarationProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)((PsiNameIdentifierOwner)declaration2).getNameIdentifier(), (PsiElement)element, (boolean)false)) {
            List<Symbol> list = List.of(symbol);
            if (list == null) {
                RubyAssociatedDeclarationProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RubyAssociatedDeclarationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ boolean lambda$getParentSignatures$1(PsiSymbolDeclarationService service, PsiElement it) {
        return !service.getDeclarations(it).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/navigation/RubyAssociatedDeclarationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/navigation/RubyAssociatedDeclarationProvider";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentSignatures";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

