/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.module;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.gem.module.GemScannerSuppressor;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleManagerSettings;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleProperties;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.wizard.RubyFrameworkProjectGenerator;

@State(name="RubyModuleManagerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class RubyModuleManager
implements Disposable,
PersistentStateComponent<RubyModuleManagerSettings> {
    private static final Logger LOG = Logger.getInstance(RubyModuleManager.class);
    @NotNull
    private final Project myProject;
    private long myProjectOpenTimestamp;
    private final RubyModuleManagerSettings mySettings;
    private final SynchronizedClearableLazy<Set<VirtualFile>> myBlackListedRootsSetProvider;
    private final NotNullLazyValue<MergingUpdateQueue> mySuggestionQueueProvider;
    private final AtomicReference<Set<RubyModuleDescription>> myQueuedModuleDescriptions;
    private final NotNullLazyValue<MergingUpdateQueue> myRescanQueueProvider;
    @NonNls
    private static final String MODULE_MANAGER_NOTIFICATION_GROUP_ID = "Ruby Module Manager";
    private boolean myInternalChange;

    public RubyModuleManager(@NotNull Project project) {
        if (project == null) {
            RubyModuleManager.$$$reportNull$$$0(0);
        }
        this.myProjectOpenTimestamp = 0L;
        this.mySettings = new RubyModuleManagerSettings();
        this.myBlackListedRootsSetProvider = new SynchronizedClearableLazy(() -> {
            PathMacroManager pathMacroManager = this.getPathMacroManager();
            HashSet<VirtualFile> set = new HashSet<VirtualFile>();
            for (String path : this.mySettings.getBlackListedRootsPaths()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(pathMacroManager.expandPath(path)), (boolean)true);
                if (virtualFile == null || !virtualFile.isValid() || !virtualFile.isDirectory()) continue;
                set.add(virtualFile);
            }
            return set;
        });
        this.myInternalChange = false;
        this.myProject = project;
        this.mySuggestionQueueProvider = NotNullLazyValue.atomicLazy(() -> new MergingUpdateQueue("Shows notification about new Keyfiles", 2000, true, null, (Disposable)this, null, true));
        this.myQueuedModuleDescriptions = new AtomicReference<Set>(ConcurrentCollectionFactory.createConcurrentSet());
        this.myRescanQueueProvider = NotNullLazyValue.atomicLazy(() -> new MergingUpdateQueue("Runs project scanning for new modules", 500, true, null, (Disposable)this, null, true).usePassThroughInUnitTestMode());
    }

    public void projectOpened() {
        this.myProjectOpenTimestamp = Instant.now().getEpochSecond();
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                ((MergingUpdateQueue)RubyModuleManager.this.myRescanQueueProvider.getValue()).cancelAllUpdates();
            }

            public void exitDumbMode() {
                RubyModuleManager.this.queueSuggestion();
                RubyModuleManager.this.queueFullScan();
            }
        });
        busConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!RubyModuleManager.this.myInternalChange) {
                    RubyModuleManager.this.queueFullScan();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$2", "rootsChanged"));
            }
        });
        busConnection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!RubyModuleManager.this.myInternalChange) {
                    RubyModuleManager.this.blackListRoots(Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$3";
                objectArray[2] = "moduleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileListener());
    }

    public long getProjectOpenTimestamp() {
        return this.myProjectOpenTimestamp;
    }

    @NotNull
    private PathMacroManager getPathMacroManager() {
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.myProject);
        if (pathMacroManager == null) {
            RubyModuleManager.$$$reportNull$$$0(1);
        }
        return pathMacroManager;
    }

    public void queueFullScan() {
        ((MergingUpdateQueue)this.myRescanQueueProvider.getValue()).queue(Update.create((Object)"Scan for new modules", this::rescanForNewModules));
    }

    private boolean shouldCreateModule() {
        return this.mySettings.isShouldCreateModules() || this.shouldAskUser();
    }

    private boolean shouldAskUser() {
        return this.mySettings.isShouldAskUser();
    }

    private void rescanForNewModules() {
        ReadAction.nonBlocking(() -> {
            this.removeModules(ContainerUtil.filter((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(this.myProject), this::shouldRemoveModule));
            if (!this.shouldCreateModule()) {
                return;
            }
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)this.myProject);
            List moduleDescriptions = ContainerUtil.filter(RubyModuleManager.collectModuleDescriptions(scope), description -> !this.getBlackListedRoots().contains(description.directory) && description.shouldInstantiate());
            if (moduleDescriptions.isEmpty()) {
                return;
            }
            if (this.shouldAskUser()) {
                this.queueKeyFiles(moduleDescriptions);
            } else {
                this.addModulesIfNecessary(moduleDescriptions);
            }
        }).expireWith(RubyPluginUtil.getUnloadAwareDisposable(this.myProject)).coalesceBy(new Object[]{this.myProject, RubyModuleManager.class, "rescan"}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void invokeLaterInternalWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            RubyModuleManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.runInternalWriteAction(runnable));
    }

    @RequiresEdt
    private void runInternalWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            RubyModuleManager.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        WriteAction.run(() -> {
            this.myInternalChange = true;
            try {
                runnable.run();
            }
            finally {
                this.myInternalChange = false;
            }
        });
    }

    private void removeModules(@NotNull Collection<Module> modules) {
        if (modules == null) {
            RubyModuleManager.$$$reportNull$$$0(4);
        }
        if (modules.isEmpty()) {
            return;
        }
        this.invokeLaterInternalWriteAction(() -> {
            List nonDisposedModules = ContainerUtil.filter((Collection)modules, module -> !module.isDisposed());
            if (nonDisposedModules.isEmpty()) {
                return;
            }
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            modules.forEach(module -> modifiableModel.disposeModule(module));
            modifiableModel.commit();
        });
    }

    private boolean shouldRemoveModule(@Nullable Module module) {
        if (module == null || module.isDisposed() || !RubyModuleProperties.getInstance(module).isAutoCreated()) {
            return false;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length != 1) {
            return true;
        }
        VirtualFile mainContentRoot = contentRoots[0];
        if (mainContentRoot == null || !mainContentRoot.isValid()) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        VirtualFile moduleContainment = mainContentRoot.getParent();
        if (moduleContainment != null && (projectFileIndex.isExcluded(moduleContainment) || projectFileIndex.isInLibrary(moduleContainment))) {
            return true;
        }
        if (moduleContainment == null || ModuleUtilCore.findModuleForFile((VirtualFile)moduleContainment, (Project)this.myProject) == null) {
            return false;
        }
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        if (gemFile != null && !GemScannerSuppressor.isFileSuppressed(gemFile, module)) {
            return false;
        }
        return GemUtil.findGemspecFile(module) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blackListRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            RubyModuleManager.$$$reportNull$$$0(5);
        }
        SynchronizedClearableLazy<Set<VirtualFile>> synchronizedClearableLazy = this.myBlackListedRootsSetProvider;
        synchronized (synchronizedClearableLazy) {
            this.getBlackListedRoots().addAll(roots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblacklistRootsAndAddModuleIfNecessary(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            RubyModuleManager.$$$reportNull$$$0(6);
        }
        if (roots.isEmpty()) {
            return;
        }
        SynchronizedClearableLazy<Set<VirtualFile>> synchronizedClearableLazy = this.myBlackListedRootsSetProvider;
        synchronized (synchronizedClearableLazy) {
            this.getBlackListedRoots().removeAll(roots);
        }
        for (VirtualFile virtualFile : roots) {
            if (virtualFile == null) continue;
            this.addModulesIfNecessary(RubyModuleManager.collectModuleDescriptions(GlobalSearchScopes.directoryScope((Project)this.myProject, (VirtualFile)virtualFile, (boolean)false)));
        }
    }

    private void addModulesIfNecessary(@NotNull Collection<RubyModuleDescription> moduleDescriptions) {
        if (moduleDescriptions == null) {
            RubyModuleManager.$$$reportNull$$$0(7);
        }
        if (moduleDescriptions.isEmpty()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            List modulesToCreate = ContainerUtil.filter((Collection)moduleDescriptions, description -> !this.getBlackListedRoots().contains(description.directory) && description.shouldInstantiate());
            if (modulesToCreate.isEmpty()) {
                return;
            }
            this.invokeLaterInternalWriteAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                List validDescriptions = ContainerUtil.filter((Collection)modulesToCreate, RubyModuleDescription::isValid);
                if (validDescriptions.isEmpty()) {
                    return;
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                ModifiableModuleModel modifiableModel = moduleManager.getModifiableModel();
                for (RubyModuleDescription moduleDescription : validDescriptions) {
                    VirtualFile moduleRoot = moduleDescription.directory;
                    Module newModule = modifiableModel.newModule(FileUtil.join((String[])new String[]{this.getImlFileRoot(moduleRoot.getPath()), this.getNewModuleName(moduleRoot.getNameWithoutExtension()) + ".iml"}), "RUBY_MODULE");
                    this.configureModule(moduleRoot, newModule);
                }
                modifiableModel.commit();
            });
        }).expireWhen(() -> ((Project)this.myProject).isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresEdt
    private void configureModule(@NotNull VirtualFile moduleRoot, @NotNull Module newModule) {
        if (moduleRoot == null) {
            RubyModuleManager.$$$reportNull$$$0(8);
        }
        if (newModule == null) {
            RubyModuleManager.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.invokeLaterInternalWriteAction(() -> {
            if (newModule.isDisposed() || !moduleRoot.isValid()) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)newModule).getModifiableModel();
            model.setSdk(this.getPreferableSdk(moduleRoot));
            model.addContentEntry(moduleRoot);
            model.commit();
            RubyModuleProperties.getInstance(newModule).setAutoCreated(true);
            if ((!PlatformUtils.isIntelliJ() || ApplicationManager.getApplication().isUnitTestMode()) && RailsUtil.containsRailsApp(moduleRoot.getPath())) {
                RailsFacetUtil.configureRailsFacet(moduleRoot, newModule);
            } else {
                ModuleRootModificationUtil.updateModel((Module)newModule, rootModel -> RubyFrameworkProjectGenerator.setupStandardTestSourceRoots(moduleRoot, rootModel));
            }
            VirtualFile gemspecFile = GemUtil.findGemspecFile(newModule);
            VirtualFile gemfile = BundlerUtil.getGemfile(newModule);
            String gemName = (String)ObjectUtils.doIfNotNull((Object)GemSpecParser.getInstance().getGemSpec(gemfile, gemspecFile), specs -> (String)GemsSpecKeys.NAME.get((UserDataHolder)specs));
            VirtualFile closestAncestorRoot = null;
            for (VirtualFile root2 : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
                Module parentModule;
                boolean isParentModule;
                if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)moduleRoot, (boolean)true) || closestAncestorRoot != null && !VfsUtilCore.isAncestor(closestAncestorRoot, (VirtualFile)root2, (boolean)true)) continue;
                boolean bl = isParentModule = gemName == null;
                if (gemName != null && (parentModule = ModuleUtilCore.findModuleForFile((VirtualFile)root2, (Project)this.myProject)) != null && !RubyProjectGemSearchService.getInstance(this.myProject).findGems(parentModule, gemName).isEmpty()) {
                    isParentModule = true;
                }
                if (!isParentModule) continue;
                closestAncestorRoot = root2;
            }
            Module module = (Module)ObjectUtils.doIfNotNull(closestAncestorRoot, root -> ModuleUtilCore.findModuleForFile((VirtualFile)root, (Project)this.myProject));
            if (module != null && RModuleUtil.getInstance().isRubyModule(module)) {
                LOG.info("add module " + newModule.getName() + " as a dependency for " + module.getName());
                ModuleRootModificationUtil.updateModel((Module)module, ancestorRootModel -> ancestorRootModel.addModuleOrderEntry(newModule));
            }
        });
    }

    private void queueKeyFiles(@NotNull Collection<RubyModuleDescription> moduleDescriptions) {
        if (moduleDescriptions == null) {
            RubyModuleManager.$$$reportNull$$$0(10);
        }
        this.myQueuedModuleDescriptions.get().addAll(moduleDescriptions);
        this.queueSuggestion();
    }

    private void queueSuggestion() {
        if (this.myProject.isDisposed() || this.myQueuedModuleDescriptions.get().isEmpty()) {
            return;
        }
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ((MergingUpdateQueue)this.mySuggestionQueueProvider.getValue()).queue(Update.create((Object)this, () -> {
            boolean hasNotification;
            if (DumbService.isDumb((Project)this.myProject)) {
                this.queueSuggestion();
                return;
            }
            if (this.myProject.isDisposed() || this.myQueuedModuleDescriptions.get().isEmpty()) {
                return;
            }
            boolean bl = hasNotification = ((MyNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MyNotification.class, this.myProject)).length > 0;
            if (hasNotification) {
                return;
            }
            Notifications.Bus.notify((Notification)new MyNotification(), (Project)this.myProject);
        })));
    }

    @NotNull
    private String getImlFileRoot(@NotNull String moduleContentRootPath) {
        String string;
        if (moduleContentRootPath == null) {
            RubyModuleManager.$$$reportNull$$$0(11);
        }
        if (this.mySettings.isPutImlFilesInsideModules()) {
            String string2 = moduleContentRootPath;
            if (string2 == null) {
                RubyModuleManager.$$$reportNull$$$0(12);
            }
            return string2;
        }
        VirtualFile projectBaseDir = this.myProject.getBaseDir();
        if (projectBaseDir == null) {
            String string3 = moduleContentRootPath;
            if (string3 == null) {
                RubyModuleManager.$$$reportNull$$$0(13);
            }
            return string3;
        }
        VirtualFile ideaDir = projectBaseDir.findChild(".idea");
        if (ideaDir == null) {
            String string4 = moduleContentRootPath;
            if (string4 == null) {
                RubyModuleManager.$$$reportNull$$$0(14);
            }
            return string4;
        }
        try {
            VirtualFile modulesDirectory = VfsUtil.createDirectoryIfMissing((VirtualFile)ideaDir, (String)"modules");
            string = modulesDirectory == null ? moduleContentRootPath : modulesDirectory.getPath();
        }
        catch (IOException e) {
            LOG.warn("Could not create a .idea/modules directory", (Throwable)e);
            String string5 = moduleContentRootPath;
            if (string5 == null) {
                RubyModuleManager.$$$reportNull$$$0(16);
            }
            return string5;
        }
        if (string == null) {
            RubyModuleManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @RequiresReadLock
    @NotNull
    private String getNewModuleName(@NotNull String baseName) {
        if (baseName == null) {
            RubyModuleManager.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.softAssertReadAccess();
        Object moduleName = baseName;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        int counter = 1;
        while (moduleManager.findModuleByName((String)moduleName) != null) {
            moduleName = baseName + counter++;
        }
        String string = moduleName;
        if (string == null) {
            RubyModuleManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    private Sdk getPreferableSdk(@NotNull VirtualFile gemFileRoot) {
        RModuleUtil rubyModuleUtil;
        Sdk sdk;
        if (gemFileRoot == null) {
            RubyModuleManager.$$$reportNull$$$0(19);
        }
        if ((sdk = (rubyModuleUtil = RModuleUtil.getInstance()).findRubySdkForVirtualFile(this.myProject, gemFileRoot.getParent())) != null) {
            return sdk;
        }
        return Arrays.stream(rubyModuleUtil.getAllModulesWithRubySupport(this.myProject)).map(module -> rubyModuleUtil.findRubySdkForModule((Module)module)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void dispose() {
    }

    @RequiresReadLock
    @NotNull
    public static Collection<RubyModuleDescription> collectModuleDescriptions(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            RubyModuleManager.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = scope.getProject();
        if (project == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RubyModuleManager.$$$reportNull$$$0(21);
            }
            return list;
        }
        HashSet keyFiles = new HashSet(FilenameIndex.getVirtualFilesByName((String)"Gemfile", (GlobalSearchScope)scope));
        keyFiles.addAll(FilenameIndex.getVirtualFilesByName((String)"gems.rb", (GlobalSearchScope)scope));
        keyFiles.addAll(FilenameIndex.getAllFilesByExt((Project)project, (String)"gemspec", (GlobalSearchScope)scope));
        MultiMap dirsToKeyFiles = ContainerUtil.groupBy(keyFiles, keyFile -> keyFile.getParent());
        List list = ContainerUtil.mapNotNull((Collection)dirsToKeyFiles.entrySet(), entry -> {
            if (entry.getKey() == null) {
                return null;
            }
            return new RubyModuleDescription(project, (VirtualFile)entry.getKey(), ((Collection)entry.getValue()).stream().toList());
        });
        if (list == null) {
            RubyModuleManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    private Set<VirtualFile> getBlackListedRoots() {
        return (Set)this.myBlackListedRootsSetProvider.getValue();
    }

    @TestOnly
    public boolean isBlackListed(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RubyModuleManager.$$$reportNull$$$0(23);
        }
        return this.getBlackListedRoots().contains(virtualFile);
    }

    @NotNull
    public RubyModuleManagerSettings getState() {
        PathMacroManager pathMacroManager = this.getPathMacroManager();
        this.mySettings.setBlackListedRootsPaths(this.getBlackListedRoots().stream().filter(virtualFile -> virtualFile != null && virtualFile.isValid() && virtualFile.isDirectory()).map(virtualFile -> pathMacroManager.collapsePath(virtualFile.getPath())).collect(Collectors.toList()));
        RubyModuleManagerSettings rubyModuleManagerSettings = this.mySettings;
        if (rubyModuleManagerSettings == null) {
            RubyModuleManager.$$$reportNull$$$0(24);
        }
        return rubyModuleManagerSettings;
    }

    public void loadState(@NotNull RubyModuleManagerSettings state) {
        if (state == null) {
            RubyModuleManager.$$$reportNull$$$0(25);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.mySettings);
        this.myBlackListedRootsSetProvider.drop();
    }

    @NotNull
    public static RubyModuleManager getInstance(@NotNull Project project) {
        if (project == null) {
            RubyModuleManager.$$$reportNull$$$0(26);
        }
        RubyModuleManager rubyModuleManager = (RubyModuleManager)project.getService(RubyModuleManager.class);
        if (rubyModuleManager == null) {
            RubyModuleManager.$$$reportNull$$$0(27);
        }
        return rubyModuleManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12, 13, 14, 15, 16, 18, 21, 22, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModule";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleContentRootPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFileRoot";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacroManager";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getImlFileRoot";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewModuleName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectModuleDescriptions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterInternalWriteAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInternalWriteAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeModules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "blackListRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unblacklistRootsAndAddModuleIfNecessary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addModulesIfNecessary";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "queueKeyFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getImlFileRoot";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNewModuleName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableSdk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleDescriptions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isBlackListed";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12, 13, 14, 15, 16, 18, 21, 22, 24, 27 -> new IllegalStateException(string);
        };
    }

    private final class MyFileListener
    implements BulkFileListener {
        private MyFileListener() {
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyFileListener.$$$reportNull$$$0(0);
            }
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)RubyModuleManager.this.myProject);
            for (VFileEvent vFileEvent : events) {
                VirtualFile eventFile;
                if (vFileEvent instanceof VFileContentChangeEvent || (eventFile = vFileEvent.getFile()) == null) continue;
                if (projectFileIndex.isInContent(eventFile)) {
                    RubyModuleManager.this.queueFullScan();
                    return;
                }
                VirtualFile parentFile = eventFile.getParent();
                if (!(vFileEvent instanceof VFileDeleteEvent) || parentFile == null || !projectFileIndex.isInContent(parentFile)) continue;
                RubyModuleManager.this.queueFullScan();
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyFileListener", "after"));
        }
    }

    public record RubyModuleDescription(@NotNull Project project, @NotNull VirtualFile directory, @NotNull @NotNull List<@NotNull VirtualFile> keyFiles) {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile directory;
        @NotNull
        private final @NotNull List<@NotNull VirtualFile> keyFiles;

        public RubyModuleDescription(@NotNull Project project, @NotNull VirtualFile directory, @NotNull @NotNull List<@NotNull VirtualFile> keyFiles) {
            if (project == null) {
                RubyModuleDescription.$$$reportNull$$$0(0);
            }
            if (directory == null) {
                RubyModuleDescription.$$$reportNull$$$0(1);
            }
            if (keyFiles == null) {
                RubyModuleDescription.$$$reportNull$$$0(2);
            }
        }

        @Nullable
        private Module getContainingModule() {
            if (!this.isValid()) {
                return null;
            }
            return ModuleUtilCore.findModuleForFile((VirtualFile)this.directory, (Project)this.project);
        }

        public boolean isValid() {
            return this.directory.isValid() && ContainerUtil.and(this.keyFiles, keyFile -> keyFile.isValid());
        }

        @RequiresReadLock
        public boolean isExcluded() {
            ThreadingAssertions.softAssertReadAccess();
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.project);
            Module containingModule = this.getContainingModule();
            return index.isExcluded(this.directory) || ContainerUtil.or(this.keyFiles, keyFile -> index.isExcluded(keyFile) || containingModule != null && GemScannerSuppressor.isFileSuppressed(keyFile, containingModule));
        }

        public boolean isStandalone() {
            if (!this.isValid()) {
                return false;
            }
            Module containingModule = ModuleUtilCore.findModuleForFile((VirtualFile)this.directory, (Project)this.project);
            if (containingModule == null) {
                return true;
            }
            return ContainerUtil.exists((Object[])ModuleRootManager.getInstance((Module)containingModule).getContentRoots(), root -> root.equals(this.directory));
        }

        @RequiresReadLock
        public boolean shouldInstantiate() {
            ThreadingAssertions.softAssertReadAccess();
            return this.isValid() && !this.isExcluded() && !this.isStandalone();
        }

        @NotNull
        public Project project() {
            Project project = this.project;
            if (project == null) {
                RubyModuleDescription.$$$reportNull$$$0(3);
            }
            return project;
        }

        @NotNull
        public VirtualFile directory() {
            VirtualFile virtualFile = this.directory;
            if (virtualFile == null) {
                RubyModuleDescription.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @NotNull
        public @NotNull List<@NotNull VirtualFile> keyFiles() {
            List<VirtualFile> list = this.keyFiles;
            if (list == null) {
                RubyModuleDescription.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyFiles";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$RubyModuleDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$RubyModuleDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "project";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "directory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keyFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyNotification
    extends Notification {
        private MyNotification() {
            super(RubyModuleManager.MODULE_MANAGER_NOTIFICATION_GROUP_ID, RBundle.message((String)"module.manager.notification.title"), RBundle.message((String)"module.manager.notification.text"), NotificationType.INFORMATION);
            this.setSuggestionType(true);
            this.addAction(new AnAction(RBundle.message((String)"button.configure")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyNotification.this.expire();
                    MyNotification.this.suggestModulesToCreate();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyNotification$1", "actionPerformed"));
                }
            });
        }

        private void suggestModulesToCreate() {
            List whitelistedModules = ContainerUtil.filter((Collection)RubyModuleManager.this.myQueuedModuleDescriptions.getAndSet(ConcurrentCollectionFactory.createConcurrentSet()), desc -> !RubyModuleManager.this.getBlackListedRoots().contains(desc.directory));
            if (whitelistedModules.isEmpty()) {
                return;
            }
            MyDialog dialog = new MyDialog(RubyModuleManager.this.myProject, whitelistedModules);
            dialog.show();
            if (dialog.isDontShowSelected()) {
                RubyModuleManager.this.mySettings.setShouldAskUser(false);
                RubyModuleManager.this.mySettings.setShouldCreateModules(dialog.isSilentCreateSelected());
            }
            if (dialog.isOK()) {
                List modulesToCreate = dialog.getMarkedElements();
                RubyModuleManager.this.blackListRoots(ContainerUtil.mapNotNull((Collection)ContainerUtil.subtract((Collection)whitelistedModules, (Collection)modulesToCreate), module -> module.directory));
                RubyModuleManager.this.addModulesIfNecessary(modulesToCreate);
            } else {
                RubyModuleManager.this.blackListRoots(ContainerUtil.mapNotNull((Collection)whitelistedModules, module -> module.directory));
            }
        }
    }

    private static class MyDialog
    extends ChooseElementsDialog<RubyModuleDescription> {
        @Nullable
        private JCheckBox myDontShowCheckbox;
        @Nullable
        private JCheckBox mySilentCreateCheckbox;

        MyDialog(Project project, List<RubyModuleDescription> items) {
            super(project, items, RBundle.message((String)"module.manager.dialog.title"), RBundle.message((String)"module.manager.dialog.text"), true);
            this.getSilentCreateCheckbox().setVisible(false);
            this.getDontShowCheckbox().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.getSilentCreateCheckbox().setVisible(this.getDontShowCheckbox().isSelected());
                }
            });
        }

        protected boolean canElementsBeMarked() {
            return true;
        }

        protected boolean isElementMarkedByDefault(RubyModuleDescription element) {
            return true;
        }

        @NotNull
        protected String getItemText(@NotNull RubyModuleDescription item) {
            if (item == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            String string = FileUtil.toSystemDependentName((String)item.directory.getPath());
            if (string == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected Icon getItemIcon(@NotNull RubyModuleDescription item) {
            if (item == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            return null;
        }

        protected JComponent createCenterPanel() {
            JComponent panel2 = super.createCenterPanel();
            assert (panel2 != null);
            JPanel checkBoxesPanel = new JPanel(new BorderLayout());
            checkBoxesPanel.add((Component)this.getDontShowCheckbox(), "West");
            checkBoxesPanel.add((Component)this.getSilentCreateCheckbox(), "Center");
            panel2.add((Component)checkBoxesPanel, "South");
            return panel2;
        }

        @NotNull
        private JCheckBox getSilentCreateCheckbox() {
            if (this.mySilentCreateCheckbox == null) {
                this.mySilentCreateCheckbox = new JCheckBox(RBundle.message((String)"module.manager.dialog.create"));
            }
            JCheckBox jCheckBox = this.mySilentCreateCheckbox;
            if (jCheckBox == null) {
                MyDialog.$$$reportNull$$$0(3);
            }
            return jCheckBox;
        }

        @NotNull
        private JCheckBox getDontShowCheckbox() {
            if (this.myDontShowCheckbox == null) {
                this.myDontShowCheckbox = new JCheckBox(RBundle.message((String)"module.manager.notification.dont.show"));
            }
            JCheckBox jCheckBox = this.myDontShowCheckbox;
            if (jCheckBox == null) {
                MyDialog.$$$reportNull$$$0(4);
            }
            return jCheckBox;
        }

        public boolean isDontShowSelected() {
            return this.getDontShowCheckbox().isSelected();
        }

        public boolean isSilentCreateSelected() {
            return this.getSilentCreateCheckbox().isSelected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItemText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSilentCreateCheckbox";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDontShowCheckbox";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getItemText";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getItemIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

