/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.psi.reference;

import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyQualifiedNameCompletionTarget;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyQualifiedNameSymbolReference;
import org.jetbrains.plugins.ruby.ruby.model.util.RubySymbols;

public final class RubyReferenceFactory {
    private RubyReferenceFactory() {
    }

    @NotNull
    public static List<PsiSymbolReference> createQualifiedNameReferences(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull EnumSet<RubyQualifiedNameCompletionTarget> completionTargets) {
        RContainer containerDeclaration;
        if (declaringElement == null) {
            RubyReferenceFactory.$$$reportNull$$$0(0);
        }
        if (nameElement == null) {
            RubyReferenceFactory.$$$reportNull$$$0(1);
        }
        if (completionTargets == null) {
            RubyReferenceFactory.$$$reportNull$$$0(2);
        }
        if ((containerDeclaration = RubyPsiUtil.getContainingClassOrModule(declaringElement)) == null) {
            return RubyReferenceFactory.createQualifiedNameReferences(declaringElement, nameElement, RubySymbols.OBJECT_SYMBOL, FQN.INVALID, completionTargets);
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)containerDeclaration.getCompoundStatement(), (PsiElement)declaringElement, (boolean)true)) {
            containerDeclaration = RubyPsiUtil.getContainingClassOrModule((PsiElement)containerDeclaration);
        }
        if (containerDeclaration == null) {
            return RubyReferenceFactory.createQualifiedNameReferences(declaringElement, nameElement, RubySymbols.OBJECT_SYMBOL, FQN.INVALID, completionTargets);
        }
        RubyContainerSymbol container = (RubyContainerSymbol)ExtensionsKt.getSymbol((PsiElement)containerDeclaration, RubyContainerSymbol.class);
        FQN containerFqn = containerDeclaration.getFQNWithNesting();
        return RubyReferenceFactory.createQualifiedNameReferences(declaringElement, nameElement, (RubyContainerSymbol)ObjectUtils.coalesce((Object)container, (Object)RubySymbols.OBJECT_SYMBOL), containerFqn, completionTargets);
    }

    @NotNull
    public static List<PsiSymbolReference> createQualifiedNameReferences(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull RubyContainerSymbol container, @NotNull FQN containerFqn, @NotNull EnumSet<RubyQualifiedNameCompletionTarget> completionTargets) {
        String qualifiedName;
        TextRange textRange;
        String text;
        if (declaringElement == null) {
            RubyReferenceFactory.$$$reportNull$$$0(3);
        }
        if (nameElement == null) {
            RubyReferenceFactory.$$$reportNull$$$0(4);
        }
        if (container == null) {
            RubyReferenceFactory.$$$reportNull$$$0(5);
        }
        if (containerFqn == null) {
            RubyReferenceFactory.$$$reportNull$$$0(6);
        }
        if (completionTargets == null) {
            RubyReferenceFactory.$$$reportNull$$$0(7);
        }
        if ((text = StringUtil.trimEnd((String)nameElement.getText(), (String)"::")).isEmpty()) {
            List<PsiSymbolReference> list = Collections.emptyList();
            if (list == null) {
                RubyReferenceFactory.$$$reportNull$$$0(8);
            }
            return list;
        }
        int offset = nameElement.getTextOffset() - declaringElement.getTextOffset();
        int startIndex = text.startsWith("::") ? 2 : 0;
        startIndex += StringUtil.findFirst((CharSequence)text.substring(startIndex), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        int endIndex = text.indexOf("::", startIndex);
        ArrayList<PsiSymbolReference> references = new ArrayList<PsiSymbolReference>();
        while (endIndex > startIndex) {
            textRange = TextRange.create((int)(offset + startIndex), (int)(offset + endIndex));
            qualifiedName = StringUtil.strip((String)(endIndex >= 0 ? text.substring(0, endIndex) : text), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            references.add(RubyReferenceFactory.createQualifiedNameReference(declaringElement, textRange, container, containerFqn, qualifiedName, completionTargets));
            startIndex = endIndex + 2;
            startIndex += StringUtil.findFirst((CharSequence)text.substring(startIndex), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            endIndex = text.indexOf("::", startIndex += text.charAt(startIndex) == '_' ? 1 : 0);
        }
        textRange = TextRange.create((int)(offset + startIndex), (int)(offset + text.length()));
        qualifiedName = StringUtil.strip((String)text, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        references.add(RubyReferenceFactory.createQualifiedNameReference(declaringElement, textRange, container, containerFqn, qualifiedName, completionTargets));
        ArrayList<PsiSymbolReference> arrayList = references;
        if (arrayList == null) {
            RubyReferenceFactory.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static PsiSymbolReference createQualifiedNameReference(@NotNull PsiElement declaringElement, @NotNull TextRange textRange, @NotNull RubyContainerSymbol container, @NotNull FQN containerFqn, @NotNull String qualifiedName, @NotNull EnumSet<RubyQualifiedNameCompletionTarget> completionTargets) {
        if (declaringElement == null) {
            RubyReferenceFactory.$$$reportNull$$$0(10);
        }
        if (textRange == null) {
            RubyReferenceFactory.$$$reportNull$$$0(11);
        }
        if (container == null) {
            RubyReferenceFactory.$$$reportNull$$$0(12);
        }
        if (containerFqn == null) {
            RubyReferenceFactory.$$$reportNull$$$0(13);
        }
        if (qualifiedName == null) {
            RubyReferenceFactory.$$$reportNull$$$0(14);
        }
        if (completionTargets == null) {
            RubyReferenceFactory.$$$reportNull$$$0(15);
        }
        return new RubyQualifiedNameSymbolReference(declaringElement, textRange, container, containerFqn, qualifiedName, completionTargets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
            case 2: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionTargets";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/psi/reference/RubyReferenceFactory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/psi/reference/RubyReferenceFactory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedNameReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedNameReferences";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedNameReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

