/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.psi.reference;

import com.intellij.model.Symbol;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.EnumSet;
import java.util.SequencedCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.reference.PsiSymbolReferenceBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyQualifiedNameCompletionTarget;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubySingletonSymbol;
import org.jetbrains.plugins.ruby.ruby.model.psi.RubyResolveUtil;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyPsiSymbolReference;

public final class RubyQualifiedNameSymbolReference
extends PsiSymbolReferenceBase<PsiElement>
implements RubyPsiSymbolReference {
    private final RubyContainerSymbol myContainer;
    private final FQN myContainerFqn;
    private final String myQualifiedName;
    private final EnumSet<RubyQualifiedNameCompletionTarget> myCompletionTargets;

    RubyQualifiedNameSymbolReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @NotNull RubyContainerSymbol container, @NotNull FQN containerFqn, @NotNull String qualifiedName, @NotNull EnumSet<RubyQualifiedNameCompletionTarget> completionTargets) {
        if (element == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(0);
        }
        if (rangeInElement == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(1);
        }
        if (container == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(2);
        }
        if (containerFqn == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(3);
        }
        if (qualifiedName == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(4);
        }
        if (completionTargets == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(5);
        }
        super(element, rangeInElement);
        this.myContainer = container;
        this.myContainerFqn = containerFqn;
        this.myQualifiedName = qualifiedName;
        this.myCompletionTargets = EnumSet.copyOf(completionTargets);
    }

    @NotNull
    public EnumSet<RubyQualifiedNameCompletionTarget> getCompletionTargets() {
        EnumSet<RubyQualifiedNameCompletionTarget> enumSet = this.myCompletionTargets;
        if (enumSet == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(6);
        }
        return enumSet;
    }

    @NotNull
    public RubyContainerSymbol getContainer() {
        RubyContainerSymbol rubyContainerSymbol = this.myContainer;
        if (rubyContainerSymbol == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(7);
        }
        return rubyContainerSymbol;
    }

    @NotNull
    public FQN getContainerFqn() {
        FQN fQN = this.myContainerFqn;
        if (fQN == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(8);
        }
        return fQN;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean resolvesTo(@NotNull Symbol target) {
        if (target == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(10);
        }
        if (target instanceof RubySingletonSymbol) {
            return false;
        }
        if (target instanceof RubyQualifiedNameSymbol) {
            RubyQualifiedNameSymbol qualifiedNameSymbol = (RubyQualifiedNameSymbol)target;
            String name = (String)ObjectUtils.coalesce((Object)StringUtil.substringAfterLast((String)this.myQualifiedName, (String)"::"), (Object)this.myQualifiedName);
            return qualifiedNameSymbol.getName().equals(name) && super.resolvesTo(target);
        }
        return false;
    }

    @Override
    @NotNull
    protected SequencedCollection<? extends Symbol> resolveReferenceImpl() {
        SequencedCollection<? extends RubyQualifiedNameSymbol> sequencedCollection = RubyResolveUtil.resolveQualifiedName(this.myProject, this.mySearchScope, this.myContainer, this.myContainerFqn, this.myQualifiedName);
        if (sequencedCollection == null) {
            RubyQualifiedNameSymbolReference.$$$reportNull$$$0(11);
        }
        return sequencedCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionTargets";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/psi/reference/RubyQualifiedNameSymbolReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/psi/reference/RubyQualifiedNameSymbolReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolvesTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

