/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.psi;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.util.AssertionsKt;
import org.jetbrains.plugins.ruby.ruby.model.util.RubyContainerSymbolUtil;
import org.jetbrains.plugins.ruby.ruby.model.util.RubySymbols;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RubyResolveUtil {
    private RubyResolveUtil() {
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveQualifiedName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        AssertionsKt.assertBackgroundThreadIfEnabled();
        return RubyResolveUtil.resolveQualifiedName(project, searchScope, RubySymbols.OBJECT_SYMBOL, FQN.INVALID, name);
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveQualifiedName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyContainerSymbol container, @NotNull FQN nesting, @NotNull String name) {
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(4);
        }
        if (container == null) {
            RubyResolveUtil.$$$reportNull$$$0(5);
        }
        if (nesting == null) {
            RubyResolveUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.softAssertReadAccess();
        AssertionsKt.assertBackgroundThreadIfEnabled();
        Stream ancestors = container instanceof RubyModuleSymbol ? StreamUtil.concatLazy(container.allAncestors(project, searchScope), (Stream[])new Stream[]{RubySymbols.OBJECT_SYMBOL.allAncestors(project, searchScope)}) : container.allAncestors(project, searchScope);
        return RubyResolveUtil.resolveQualifiedName(project, searchScope, ancestors, nesting, name);
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveQualifiedName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Stream<? extends RubyContainerSymbol> ancestors, @NotNull FQN nesting, @NotNull String name) {
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(9);
        }
        if (ancestors == null) {
            RubyResolveUtil.$$$reportNull$$$0(10);
        }
        if (nesting == null) {
            RubyResolveUtil.$$$reportNull$$$0(11);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.softAssertReadAccess();
        AssertionsKt.assertBackgroundThreadIfEnabled();
        if (name.contains("$$ANON")) {
            return RubyResolveUtil.resolveAnonymousName(project, searchScope, name);
        }
        if (name.startsWith("::")) {
            return RubyResolveUtil.resolveQualifiedNameInAncestry(project, searchScope, RubySymbols.OBJECT_SYMBOL, name.substring(2));
        }
        int index = name.indexOf("::");
        if (index > 0) {
            String receiverName = name.substring(0, index);
            String newName = name.substring(index + 2);
            List list = RubyResolveUtil.resolveQualifiedName(project, searchScope, ancestors, nesting, receiverName).stream().mapMulti(RubyContainerSymbolUtil.followConstantAliases(project, searchScope)).mapMulti(StreamUtil.select(RubyContainerSymbol.class, (Class[])new Class[0])).flatMap(it -> RubyResolveUtil.resolveQualifiedNameInAncestry(project, searchScope, it, newName).stream()).distinct().toList();
            if (list == null) {
                RubyResolveUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        LinkedHashSet<RubyQualifiedNameSymbol> result = new LinkedHashSet<RubyQualifiedNameSymbol>();
        result.addAll(RubyResolveUtil.resolveSimpleNameInNesting(project, searchScope, nesting, name));
        if (!result.isEmpty()) {
            SequencedSet sequencedSet = Collections.unmodifiableSequencedSet(result);
            if (sequencedSet == null) {
                RubyResolveUtil.$$$reportNull$$$0(14);
            }
            return sequencedSet;
        }
        result.addAll(RubyResolveUtil.resolveSimpleNameInAncestry(project, searchScope, ancestors, name));
        if (!result.isEmpty()) {
            SequencedSet sequencedSet = Collections.unmodifiableSequencedSet(result);
            if (sequencedSet == null) {
                RubyResolveUtil.$$$reportNull$$$0(15);
            }
            return sequencedSet;
        }
        SortedSet sortedSet = Collections.emptySortedSet();
        if (sortedSet == null) {
            RubyResolveUtil.$$$reportNull$$$0(16);
        }
        return sortedSet;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    private static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveAnonymousName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(18);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.softAssertReadAccess();
        AssertionsKt.assertBackgroundThreadIfEnabled();
        FQN fqn = FQN.of((String)name);
        Type type = AnonymousDefiningCallType.getFQNType((FQN)fqn);
        if (type == Type.CLASS) {
            List<RubyClassSymbol> list = RubyClassSymbol.find(project, searchScope, fqn).stream().toList();
            if (list == null) {
                RubyResolveUtil.$$$reportNull$$$0(20);
            }
            return list;
        }
        if (type == Type.MODULE) {
            List<RubyModuleSymbol> list = RubyModuleSymbol.find(project, searchScope, fqn).stream().toList();
            if (list == null) {
                RubyResolveUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RubyResolveUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveQualifiedNameInAncestry(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyContainerSymbol container, @NotNull String name) {
        int index;
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(23);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(24);
        }
        if (container == null) {
            RubyResolveUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(26);
        }
        if ((index = name.indexOf("::")) > 0) {
            String receiverName = name.substring(0, index);
            String newName = name.substring(index + 2);
            List list = RubyResolveUtil.resolveQualifiedNameInAncestry(project, searchScope, container, receiverName).stream().mapMulti(RubyContainerSymbolUtil.followConstantAliases(project, searchScope)).mapMulti(StreamUtil.select(RubyContainerSymbol.class, (Class[])new Class[0])).flatMap(it -> RubyResolveUtil.resolveQualifiedNameInAncestry(project, searchScope, it, newName).stream()).distinct().toList();
            if (list == null) {
                RubyResolveUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        Iterator it2 = container.allAncestors(project, searchScope).distinct().iterator();
        while (it2.hasNext()) {
            RubyContainerSymbol next = (RubyContainerSymbol)it2.next();
            List<RubyQualifiedNameSymbol> constants = next.constants(project, searchScope).filter(constant -> constant.getName().equals(name)).distinct().toList();
            if (constants.isEmpty()) continue;
            List<RubyQualifiedNameSymbol> list = container.equals(RubySymbols.OBJECT_SYMBOL) || !next.equals(RubySymbols.OBJECT_SYMBOL) ? constants : Collections.emptyList();
            if (list == null) {
                RubyResolveUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RubyResolveUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    private static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveSimpleNameInAncestry(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Stream<? extends RubyContainerSymbol> ancestors, @NotNull String name) {
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(30);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(31);
        }
        if (ancestors == null) {
            RubyResolveUtil.$$$reportNull$$$0(32);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(33);
        }
        SequencedCollection sequencedCollection = ancestors.distinct().map(it -> it.constants(project, searchScope).filter(constant -> constant.getName().equals(name)).distinct().toList()).filter(it -> !it.isEmpty()).findFirst().orElse(Collections.emptyList());
        if (sequencedCollection == null) {
            RubyResolveUtil.$$$reportNull$$$0(34);
        }
        return sequencedCollection;
    }

    @NotNull
    private static SequencedCollection<? extends RubyQualifiedNameSymbol> resolveSimpleNameInNesting(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull FQN nesting, @NotNull String name) {
        if (project == null) {
            RubyResolveUtil.$$$reportNull$$$0(35);
        }
        if (searchScope == null) {
            RubyResolveUtil.$$$reportNull$$$0(36);
        }
        if (nesting == null) {
            RubyResolveUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            RubyResolveUtil.$$$reportNull$$$0(38);
        }
        if (nesting == FQN.INVALID) {
            SortedSet sortedSet = Collections.emptySortedSet();
            if (sortedSet == null) {
                RubyResolveUtil.$$$reportNull$$$0(39);
            }
            return sortedSet;
        }
        LinkedHashSet symbols = new LinkedHashSet();
        nesting.processNestingResolution(parent -> {
            ProgressManager.checkCanceled();
            if (parent == FQN.INVALID) {
                return true;
            }
            FQN candidateFqn = FQN.Builder.concat((FQN)parent, (String)name).normalize();
            RubyContainerSymbol.find(project, searchScope, candidateFqn).forEach(symbols::add);
            RubyConstantSymbol.find(project, searchScope, candidateFqn).ifPresent(symbols::add);
            return symbols.isEmpty();
        });
        SequencedSet sequencedSet = Collections.unmodifiableSequencedSet(symbols);
        if (sequencedSet == null) {
            RubyResolveUtil.$$$reportNull$$$0(40);
        }
        return sequencedSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 20, 21, 22, 27, 28, 29, 34, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 18: 
            case 24: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 19: 
            case 26: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 6: 
            case 11: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nesting";
                break;
            }
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/psi/RubyResolveUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/psi/RubyResolveUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnonymousName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedNameInAncestry";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleNameInAncestry";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleNameInNesting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 39: 
            case 40: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnonymousName";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedNameInAncestry";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleNameInAncestry";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleNameInNesting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 20, 21, 22, 27, 28, 29, 34, 39, 40 -> new IllegalStateException(string);
        };
    }
}

