/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.SearchScope;
import java.util.Collections;
import java.util.Comparator;
import java.util.SequencedSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyDeclarationHierarchyIndex;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolDataProvider;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubySingletonSymbol;
import org.jetbrains.plugins.ruby.ruby.model.util.RubySymbols;

public final class RubyNestingContainerConstantSymbolDataProvider
implements RubyContainerSymbolDataProvider {
    private static final Comparator<RubyQualifiedNameSymbol> COMPARATOR = Comparator.comparing(RubyQualifiedNameSymbol::getQualifiedName).thenComparing(it -> {
        if (it instanceof RubyClassSymbol) {
            return RubyDeclarationHierarchyIndex.Type.CLASS;
        }
        if (it instanceof RubyConstantSymbol) {
            return RubyDeclarationHierarchyIndex.Type.CONSTANT;
        }
        if (it instanceof RubyModuleSymbol) {
            return RubyDeclarationHierarchyIndex.Type.MODULE;
        }
        throw new IllegalStateException("Unexpected symbol type: " + it.getClass().getName());
    });

    @NotNull
    public SequencedSet<? extends RubyQualifiedNameSymbol> constants(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyContainerSymbol symbol) {
        boolean isObject;
        RubyModuleSymbol moduleSymbol;
        RubyClassSymbol classSymbol;
        if (project == null) {
            RubyNestingContainerConstantSymbolDataProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyNestingContainerConstantSymbolDataProvider.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RubyNestingContainerConstantSymbolDataProvider.$$$reportNull$$$0(2);
        }
        if (symbol instanceof RubyClassSymbol && (classSymbol = (RubyClassSymbol)symbol).isAnonymous()) {
            SortedSet sortedSet = Collections.emptySortedSet();
            if (sortedSet == null) {
                RubyNestingContainerConstantSymbolDataProvider.$$$reportNull$$$0(3);
            }
            return sortedSet;
        }
        if (symbol instanceof RubyModuleSymbol && (moduleSymbol = (RubyModuleSymbol)symbol).isAnonymous()) {
            SortedSet sortedSet = Collections.emptySortedSet();
            if (sortedSet == null) {
                RubyNestingContainerConstantSymbolDataProvider.$$$reportNull$$$0(4);
            }
            return sortedSet;
        }
        TreeSet<RubyQualifiedNameSymbol> constants = new TreeSet<RubyQualifiedNameSymbol>(COMPARATOR);
        FQN symbolFqn = symbol instanceof RubySingletonSymbol ? RObjectClass.makeSingletonClassFQN((FQN)symbol.getFqn()).normalize() : symbol.getFqn();
        if (symbolFqn.equals((Object)CoreFqns.BASIC_OBJECT)) {
            constants.add(RubySymbols.BASIC_OBJECT_SYMBOL);
        }
        FQN key = !(isObject = symbolFqn.equals((Object)CoreFqns.OBJECT)) ? symbolFqn : FQN.INVALID;
        RubyDeclarationHierarchyIndex.processAllValues((Project)project, (SearchScope)searchScope, (FQN)key, (___, values) -> {
            for (Pair pair : values) {
                FQN fqn = isObject ? FQN.of((String)((String)pair.getSecond())) : FQN.Builder.concat((FQN)symbolFqn, (String)((String)pair.getSecond()));
                switch ((RubyDeclarationHierarchyIndex.Type)pair.getFirst()) {
                    case CLASS: {
                        constants.add(new RubyClassSymbol(fqn));
                        break;
                    }
                    case CONSTANT: {
                        constants.add(new RubyConstantSymbol(fqn));
                        break;
                    }
                    case MODULE: {
                        constants.add(new RubyModuleSymbol(fqn));
                    }
                }
            }
            return true;
        });
        SequencedSet<RubyQualifiedNameSymbol> sequencedSet = Collections.unmodifiableSequencedSet(constants);
        if (sequencedSet == null) {
            RubyNestingContainerConstantSymbolDataProvider.$$$reportNull$$$0(5);
        }
        return sequencedSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/extensions/RubyNestingContainerConstantSymbolDataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/extensions/RubyNestingContainerConstantSymbolDataProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "constants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "constants";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

