/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.cache.RubySymbolsCache;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.UtilKt;
import org.jetbrains.plugins.ruby.ruby.model.util.AssertionsKt;
import org.jetbrains.plugins.ruby.ruby.model.util.RubySymbols;

public final class RubySingletonSymbol
implements RubyContainerSymbol {
    private final RubyContainerSymbol myOriginalSymbol;
    private final boolean myIsAnonymous;

    public RubySingletonSymbol(@NotNull RubyContainerSymbol originalSymbol) {
        if (originalSymbol == null) {
            RubySingletonSymbol.$$$reportNull$$$0(0);
        }
        this.myOriginalSymbol = originalSymbol;
        this.myIsAnonymous = AnonymousDefiningCallType.isAnonymousFQN((FQN)originalSymbol.getFqn());
    }

    @NotNull
    public Pointer<RubySingletonSymbol> createPointer() {
        Pointer pointer = Pointer.delegatingPointer(this.myOriginalSymbol.createPointer(), RubySingletonSymbol::new);
        if (pointer == null) {
            RubySingletonSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myOriginalSymbol.equals(((RubySingletonSymbol)obj).myOriginalSymbol);
    }

    @Override
    @NotNull
    public FQN getFqn() {
        FQN fQN = this.myOriginalSymbol.getFqn();
        if (fQN == null) {
            RubySingletonSymbol.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @Override
    @NotNull
    public String getName() {
        String string = RBundle.message((String)"ruby.model.singleton.name");
        if (string == null) {
            RubySingletonSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public RubyContainerSymbol getOriginalSymbol() {
        RubyContainerSymbol rubyContainerSymbol = this.myOriginalSymbol;
        if (rubyContainerSymbol == null) {
            RubySingletonSymbol.$$$reportNull$$$0(4);
        }
        return rubyContainerSymbol;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public SymbolPresentation getPresentation() {
        if (this.myIsAnonymous) {
            String name = RBundle.message((String)"ruby.model.singleton.name");
            @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.singleton.anonymous.shortDescription");
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.singleton.shortDescription", (Object[])new Object[]{name});
        FQN parentFqn = this.getFqn().getCallerFQN();
        if (parentFqn == FQN.INVALID) {
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.singleton.longDescription", (Object[])new Object[]{name, UtilKt.humanize(parentFqn)});
        return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = RBundle.message((String)"ruby.model.singleton.qualifiedName");
        if (string == null) {
            RubySingletonSymbol.$$$reportNull$$$0(5);
        }
        return string;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public RubyContainerSymbol getSuperclassSymbol(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubySingletonSymbol.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RubySingletonSymbol.$$$reportNull$$$0(7);
        }
        AssertionsKt.assertBackgroundThreadIfEnabled();
        Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> cache = RubySymbolsCache.getInstance(project, searchScope).getSuperclasses();
        List cachedSuperclasses = (List)cache.getIfPresent((Object)this);
        if (cachedSuperclasses != null) {
            return (RubyContainerSymbol)ContainerUtil.getOnlyItem((Collection)cachedSuperclasses);
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        List<RubyContainerSymbol> superclasses = this.getSuperclassSymbols(project, searchScope);
        if (stamp.mayCacheNow()) {
            cache.put((Object)this, superclasses);
        }
        return (RubyContainerSymbol)ContainerUtil.getOnlyItem(superclasses);
    }

    public int hashCode() {
        return this.myOriginalSymbol.hashCode();
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    @NotNull
    public String toString() {
        String string = "RubySingletonSymbol{myOriginalSymbol=%s}".formatted(this.myOriginalSymbol);
        if (string == null) {
            RubySingletonSymbol.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private List<RubyContainerSymbol> getSuperclassSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        RubyClassSymbol clazz;
        RubyClassSymbol originalSuperclassSymbol;
        if (project == null) {
            RubySingletonSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RubySingletonSymbol.$$$reportNull$$$0(10);
        }
        if (this.getFqn().equals((Object)CoreFqns.BASIC_OBJECT)) {
            List<RubyContainerSymbol> list = List.of(RubySymbols.CLASS_SYMBOL);
            if (list == null) {
                RubySingletonSymbol.$$$reportNull$$$0(11);
            }
            return list;
        }
        RubyContainerSymbol rubyContainerSymbol = this.myOriginalSymbol;
        if (rubyContainerSymbol instanceof RubyClassSymbol && (originalSuperclassSymbol = (clazz = (RubyClassSymbol)rubyContainerSymbol).getSuperclassSymbol(project, searchScope)) != null) {
            List<RubyContainerSymbol> list = List.of(new RubySingletonSymbol(originalSuperclassSymbol));
            if (list == null) {
                RubySingletonSymbol.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (this.myOriginalSymbol instanceof RubyModuleSymbol) {
            List<RubyContainerSymbol> list = List.of(RubySymbols.MODULE_SYMBOL);
            if (list == null) {
                RubySingletonSymbol.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<RubyContainerSymbol> list = Collections.emptyList();
        if (list == null) {
            RubySingletonSymbol.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSymbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubySingletonSymbol";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubySingletonSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbol";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

