/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyClassSymbolDataProvider;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyTopLevelSymbolProvider;
import org.jetbrains.plugins.ruby.ruby.model.cache.RubySymbolsCache;
import org.jetbrains.plugins.ruby.ruby.model.impl.UtilKt;
import org.jetbrains.plugins.ruby.ruby.model.util.AssertionsKt;
import org.jetbrains.plugins.ruby.ruby.model.util.RubySymbols;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public final class RubyClassSymbol
implements NavigatableSymbol,
RubyContainerSymbol {
    private final FQN myFqn;
    private final boolean myIsAnonymous;

    public RubyClassSymbol(@NotNull FQN fqn) {
        if (fqn == null) {
            RubyClassSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
        this.myIsAnonymous = AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn);
    }

    @NotNull
    public Stream<RubyClassSymbol> allSuperclasses(@NotNull Project project, @NotNull SearchScope searchScope) {
        RubyClassSymbol seed;
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(2);
        }
        if ((seed = this.getSuperclassSymbol(project, searchScope)) == null) {
            Stream<RubyClassSymbol> stream = Stream.empty();
            if (stream == null) {
                RubyClassSymbol.$$$reportNull$$$0(3);
            }
            return stream;
        }
        HashSet<RubyClassSymbol> visited = new HashSet<RubyClassSymbol>(List.of(this, seed));
        Stream<RubyClassSymbol> stream = Stream.iterate(seed, it -> {
            RubyClassSymbol superclass = it.getSuperclassSymbol(project, searchScope);
            return superclass != null && visited.add(superclass);
        }, it -> it.getSuperclassSymbol(project, searchScope));
        if (stream == null) {
            RubyClassSymbol.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    public Pointer<RubyClassSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RubyClassSymbol.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.equals((Object)((RubyClassSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public FQN getFqn() {
        FQN fQN = this.myFqn;
        if (fQN == null) {
            RubyClassSymbol.$$$reportNull$$$0(6);
        }
        return fQN;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.isAnonymous() ? RBundle.message((String)"ruby.model.class.anonymous.name") : RubyContainerSymbol.super.getName();
        if (string == null) {
            RubyClassSymbol.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.isAnonymous() ? RBundle.message((String)"ruby.model.class.anonymous.qualifiedName") : RubyContainerSymbol.super.getQualifiedName();
        if (string == null) {
            RubyClassSymbol.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public SymbolPresentation getPresentation() {
        if (this.myIsAnonymous) {
            String name = RBundle.message((String)"ruby.model.class.anonymous.name");
            @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.class.anonymous.shortDescription");
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.class.shortDescription", (Object[])new Object[]{name});
        FQN parentFqn = this.myFqn.getCallerFQN();
        if (parentFqn == FQN.INVALID) {
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.class.longDescription", (Object[])new Object[]{name, UtilKt.humanize(parentFqn)});
        return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public RubyClassSymbol getSuperclassSymbol(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(10);
        }
        AssertionsKt.assertBackgroundThreadIfEnabled();
        Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> cache = RubySymbolsCache.getInstance(project, searchScope).getSuperclasses();
        List cachedSuperclasses = (List)cache.getIfPresent((Object)this);
        if (cachedSuperclasses != null) {
            return (RubyClassSymbol)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem((Collection)cachedSuperclasses), RubyClassSymbol.class);
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        List<RubyClassSymbol> superclasses = List.copyOf(this.getSuperclassSymbols(project, searchScope));
        if (stamp.mayCacheNow()) {
            cache.put((Object)this, superclasses);
        }
        return (RubyClassSymbol)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(superclasses), RubyClassSymbol.class);
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    @NotNull
    public String toString() {
        String string = "RubyClassSymbol{myFqn=%s}".formatted(this.myFqn);
        if (string == null) {
            RubyClassSymbol.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private List<RubyClassSymbol> getSuperclassSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(13);
        }
        if (this.myFqn.equals((Object)CoreFqns.OBJECT)) {
            List<RubyClassSymbol> list = List.of(RubySymbols.BASIC_OBJECT_SYMBOL);
            if (list == null) {
                RubyClassSymbol.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (this.myFqn.equals((Object)CoreFqns.BASIC_OBJECT)) {
            List<RubyClassSymbol> list = Collections.emptyList();
            if (list == null) {
                RubyClassSymbol.$$$reportNull$$$0(15);
            }
            return list;
        }
        SmartHashSet superclasses = new SmartHashSet();
        for (RubyClassSymbolDataProvider provider : RubyClassSymbolDataProvider.EP.getExtensionList()) {
            superclasses.addAll(provider.getSuperclassSymbols(project, searchScope, this));
            if (superclasses.size() <= 1) continue;
            break;
        }
        if (superclasses.size() == 1) {
            List<RubyClassSymbol> list = List.copyOf(superclasses);
            if (list == null) {
                RubyClassSymbol.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<RubyClassSymbol> list = List.of(RubySymbols.OBJECT_SYMBOL);
        if (list == null) {
            RubyClassSymbol.$$$reportNull$$$0(17);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RubyClassSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull FQN fqn) {
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(19);
        }
        if (fqn == null) {
            RubyClassSymbol.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.softAssertReadAccess();
        AssertionsKt.assertBackgroundThreadIfEnabled();
        if (fqn == FQN.INVALID) {
            Optional<RubyClassSymbol> optional = Optional.empty();
            if (optional == null) {
                RubyClassSymbol.$$$reportNull$$$0(21);
            }
            return optional;
        }
        FQN normalizedFqn = fqn.normalize();
        for (RubyTopLevelSymbolProvider provider : RubyTopLevelSymbolProvider.EP.forKey(RubyClassSymbol.class)) {
            Object t = provider.find(project, searchScope, normalizedFqn);
            if (!(t instanceof RubyClassSymbol)) continue;
            RubyClassSymbol symbol = (RubyClassSymbol)t;
            Optional<RubyClassSymbol> optional = Optional.of(symbol);
            if (optional == null) {
                RubyClassSymbol.$$$reportNull$$$0(22);
            }
            return optional;
        }
        Optional<RubyClassSymbol> optional = Optional.empty();
        if (optional == null) {
            RubyClassSymbol.$$$reportNull$$$0(23);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public static Stream<RubyClassSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(24);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertBackgroundThread();
        SmartCancellationChecker checker = new SmartCancellationChecker(1000);
        Stream<RubyClassSymbol> stream = RubyTopLevelSymbolProvider.EP.forKey(RubyClassSymbol.class).stream().flatMap(it -> it.stream(project, searchScope)).mapMulti(StreamUtil.select(RubyClassSymbol.class, (Class[])new Class[0])).distinct().peek(__ -> checker.checkCancelled());
        if (stream == null) {
            RubyClassSymbol.$$$reportNull$$$0(26);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 11, 14, 15, 16, 17, 21, 22, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyClassSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyClassSymbol";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allSuperclasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassSymbols";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allSuperclasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbol";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbols";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 11, 14, 15, 16, 17, 21, 22, 23, 26 -> new IllegalStateException(string);
        };
    }
}

