/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.documentation;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.SymbolDocumentationTargetProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.navigation.TargetLocation;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationsSearch;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.model.api.RubySymbol;
import org.jetbrains.plugins.ruby.ruby.model.documentation.RubyDocumentationTargetBase;
import org.jetbrains.plugins.ruby.ruby.model.documentation.RubyGlobalVariableDocumentationTarget;
import org.jetbrains.plugins.ruby.ruby.model.documentation.RubyNumberedParameterDocumentationTarget;
import org.jetbrains.plugins.ruby.ruby.model.documentation.RubySymbolDocumentationTargetProviderKt;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyNumberedParameterSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/model/documentation/RubySymbolDocumentationTargetProvider;", "Lcom/intellij/platform/backend/documentation/SymbolDocumentationTargetProvider;", "<init>", "()V", "documentationTargets", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubySymbolDocumentationTargetProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubySymbolDocumentationTargetProvider.kt\norg/jetbrains/plugins/ruby/ruby/model/documentation/RubySymbolDocumentationTargetProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1869#2,2:52\n1869#2,2:54\n*S KotlinDebug\n*F\n+ 1 RubySymbolDocumentationTargetProvider.kt\norg/jetbrains/plugins/ruby/ruby/model/documentation/RubySymbolDocumentationTargetProvider\n*L\n30#1:52,2\n39#1:54,2\n*E\n"})
final class RubySymbolDocumentationTargetProvider
implements SymbolDocumentationTargetProvider {
    @NotNull
    public List<DocumentationTarget> documentationTargets(@NotNull Project project, @NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof RubySymbol)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<RubyDocumentationTargetBase> targets = new ArrayList<RubyDocumentationTargetBase>();
        RubySymbol rubySymbol = (RubySymbol)symbol;
        if (rubySymbol instanceof RubyGlobalVariableSymbol) {
            EnumMap<TargetLocation, List> targetsByLocation = new EnumMap<TargetLocation, List>(TargetLocation.class);
            Iterable $this$forEach$iv = PsiSymbolDeclarationsSearch.search(project, (SearchScope)GlobalSearchScope.allScope((Project)project), symbol).asIterable();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement element;
                PsiSymbolDeclaration declaration = (PsiSymbolDeclaration)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)declaration.getDeclaringElement(), (String)"getDeclaringElement(...)");
                if (RubyHelpUtil.getDocumentation(element, null) == null) continue;
                RubyGlobalVariableDocumentationTarget target = new RubyGlobalVariableDocumentationTarget(project, (RubyGlobalVariableSymbol)symbol, element);
                targetsByLocation.computeIfAbsent(TargetLocation.fromElement(element), arg_0 -> RubySymbolDocumentationTargetProvider.documentationTargets$lambda$0$1(RubySymbolDocumentationTargetProvider::documentationTargets$lambda$0$0, arg_0)).add(target);
            }
            Collection collection = targetsByLocation.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            $this$forEach$iv = collection;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable iterable = it;
                Comparator comparator = RubySymbolDocumentationTargetProviderKt.access$getDOCUMENTATION_TARGET_COMPARATOR$p();
                Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"access$getDOCUMENTATION_TARGET_COMPARATOR$p(...)");
                targets.addAll(CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
            }
            if (targets.isEmpty()) {
                targets.add(new RubyGlobalVariableDocumentationTarget(project, (RubyGlobalVariableSymbol)symbol));
            }
        } else if (rubySymbol instanceof RubyNumberedParameterSymbol) {
            targets.add(new RubyNumberedParameterDocumentationTarget(project, (RubyNumberedParameterSymbol)symbol));
        }
        return targets;
    }

    private static final List documentationTargets$lambda$0$0(TargetLocation it) {
        return new ArrayList();
    }

    private static final List documentationTargets$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

