/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.completion;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementKeys;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementLocation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;

final class RubyQualifiedNameLookupElement
extends LookupElement {
    private final FQN myFqn;
    private final int myNestingDepth;
    private final String myLookupString;
    private final Set<String> myAllLookupStrings;
    private final LookupElementPresentation myPresentation;
    @Nullable
    private final LookupElementRenderer<? extends LookupElement> myExpensiveRenderer;

    RubyQualifiedNameLookupElement(@NotNull RubyQualifiedNameSymbol symbol, @NotNull SymbolLookupElementLocation location, @Nullable LookupElementRenderer<? extends LookupElement> expensiveRenderer) {
        if (symbol == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(0);
        }
        if (location == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(1);
        }
        this.myPresentation = new LookupElementPresentation();
        this.myFqn = symbol.getFqn();
        this.myNestingDepth = this.myFqn.asList().size();
        this.myLookupString = "::" + symbol.getQualifiedName();
        this.myAllLookupStrings = Set.of(this.myLookupString, symbol.getName());
        this.myPresentation.setItemText(symbol.getName());
        this.myPresentation.setTypeText(StringUtil.defaultIfEmpty((String)this.myFqn.getCallerFQN().getFullPath(), (String)"::"));
        this.myPresentation.setTypeGrayed(true);
        this.myPresentation.setIcon(symbol.getPresentation().icon());
        this.myPresentation.setItemTextBold(location == SymbolLookupElementLocation.SAME_FILE);
        this.myExpensiveRenderer = expensiveRenderer;
        this.putUserData(SymbolLookupElementKeys.SYMBOL_POINTER, symbol.createPointer());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RubyQualifiedNameLookupElement other = (RubyQualifiedNameLookupElement)((Object)obj);
        return this.myFqn.equals((Object)other.myFqn) && this.myPresentation.isItemTextBold() == other.myPresentation.isItemTextBold() && Objects.equals(this.myExpensiveRenderer, other.myExpensiveRenderer);
    }

    public @Unmodifiable @NotNull Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        AutoCompletionPolicy autoCompletionPolicy = AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        if (autoCompletionPolicy == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(3);
        }
        return autoCompletionPolicy;
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return this.myExpensiveRenderer;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getNestingDepth() {
        return this.myNestingDepth;
    }

    @NotNull
    public Object getObject() {
        FQN fQN = this.myFqn;
        if (fQN == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(5);
        }
        return fQN;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    public int hashCode() {
        int result = this.myFqn.hashCode();
        result = 31 * result + this.myPresentation.hashCode();
        result = 31 * result + Objects.hashCode(this.myExpensiveRenderer);
        return result;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isWorthShowingInAutoPopup() {
        return false;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            RubyQualifiedNameLookupElement.$$$reportNull$$$0(6);
        }
        presentation.copyFrom(this.myPresentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/completion/RubyQualifiedNameLookupElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/completion/RubyQualifiedNameLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoCompletionPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

