/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.model.Pointer;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementKeys;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementLocation;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationsSearch;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.completion.RubyQualifiedNameLookupElement;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubySingletonSymbol;

@Service(value={Service.Level.PROJECT})
public final class RubyCompletableSymbolService {
    private static final InsertHandler<LookupElement> GLOBAL_VARIABLE_INSERT_HANDLER = (context, item) -> {
        String text = context.getFile().getText();
        int offset = context.getStartOffset();
        if (0 < offset && offset <= text.length() && String.valueOf(text.charAt(offset - 1)).equals("$")) {
            context.getDocument().deleteString(offset - 1, offset);
        }
    };
    private final LookupElementRenderer<LookupElement> myPresentableSymbolExpensiveRenderer;
    private final LookupElementRenderer<LookupElement> myGlobalVariableSymbolExpensiveRenderer;

    public RubyCompletableSymbolService(@NotNull Project project) {
        if (project == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(0);
        }
        this.myPresentableSymbolExpensiveRenderer = RubyCompletableSymbolService.createSymbolPresentationExpensiveRenderer(project);
        this.myGlobalVariableSymbolExpensiveRenderer = RubyCompletableSymbolService.createGlobalVariableSymbolExpensiveRenderer(project, this.myPresentableSymbolExpensiveRenderer);
    }

    @NotNull
    public LookupElement asLookupElement(@NotNull RubyGlobalVariableSymbol symbol, @NotNull SymbolLookupElementLocation location) {
        if (symbol == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(1);
        }
        if (location == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(2);
        }
        LookupElementBuilder lookupElement = LookupElementBuilder.create((String)symbol.getFullName()).withLookupString(symbol.getName()).withPresentableText(symbol.getName()).withIcon(symbol.getPresentation().icon()).withBoldness(location == SymbolLookupElementLocation.SAME_FILE).withInsertHandler(GLOBAL_VARIABLE_INSERT_HANDLER).withExpensiveRenderer(this.myGlobalVariableSymbolExpensiveRenderer);
        lookupElement.putUserData(SymbolLookupElementKeys.SYMBOL_POINTER, symbol.createPointer());
        lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.GLOBAL_VAR.getValue());
        LookupElementBuilder lookupElementBuilder = lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)lookupElement, (int)location.ordinal());
        if (lookupElementBuilder == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(3);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public LookupElement asLookupElement(@NotNull RubyQualifiedNameSymbol symbol, @NotNull SymbolLookupElementLocation location) {
        if (symbol == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(4);
        }
        if (location == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(5);
        }
        RubyQualifiedNameLookupElement lookupElement = new RubyQualifiedNameLookupElement(symbol, location, this.myPresentableSymbolExpensiveRenderer);
        if (symbol instanceof RubyClassSymbol || symbol instanceof RubyModuleSymbol || symbol instanceof RubySingletonSymbol) {
            lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.MODULE_OR_CLASS.getValue());
        } else if (symbol instanceof RubyConstantSymbol) {
            lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.CONSTS.getValue());
        }
        RubyQualifiedNameLookupElement rubyQualifiedNameLookupElement = lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)lookupElement, (int)location.ordinal());
        if (rubyQualifiedNameLookupElement == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(6);
        }
        return rubyQualifiedNameLookupElement;
    }

    @NotNull
    public static RubyCompletableSymbolService getInstance(@NotNull Project project) {
        if (project == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(7);
        }
        RubyCompletableSymbolService rubyCompletableSymbolService = (RubyCompletableSymbolService)project.getService(RubyCompletableSymbolService.class);
        if (rubyCompletableSymbolService == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(8);
        }
        return rubyCompletableSymbolService;
    }

    @NotNull
    private static LookupElementRenderer<LookupElement> createGlobalVariableSymbolExpensiveRenderer(final @NotNull Project project, final @NotNull LookupElementRenderer<LookupElement> delegate) {
        if (project == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(9);
        }
        if (delegate == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(10);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        return new LookupElementRenderer<LookupElement>((SearchScope)searchScope){
            final /* synthetic */ SearchScope val$searchScope;
            {
                this.val$searchScope = searchScope;
            }

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    1.$$$reportNull$$$0(1);
                }
                delegate.renderElement(element, presentation);
                RubyGlobalVariableSymbol symbol = (RubyGlobalVariableSymbol)ObjectUtils.tryCast((Object)((Pointer)SymbolLookupElementKeys.SYMBOL_POINTER.getRequired((UserDataHolder)element)).dereference(), RubyGlobalVariableSymbol.class);
                if (symbol == null) {
                    return;
                }
                TreeSet files = new TreeSet();
                PsiSymbolDeclarationsSearch.search(project, this.val$searchScope, symbol).forEach(declaration -> {
                    String name = (String)ObjectUtils.doIfNotNull((Object)declaration.getDeclaringElement().getContainingFile(), PsiFileSystemItem::getName);
                    if (name != null) {
                        files.add(name);
                    }
                    return files.size() < 2;
                });
                String typeText = files.size() > 1 ? "%s, %s".formatted(ContainerUtil.getFirstItem(files), "\u2026") : (String)ContainerUtil.getOnlyItem(files);
                presentation.setTypeText(typeText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/model/completion/RubyCompletableSymbolService$1";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static LookupElementRenderer<LookupElement> createSymbolPresentationExpensiveRenderer(final @NotNull Project project) {
        if (project == null) {
            RubyCompletableSymbolService.$$$reportNull$$$0(11);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        return new LookupElementRenderer<LookupElement>((SearchScope)searchScope){
            final /* synthetic */ SearchScope val$searchScope;
            {
                this.val$searchScope = searchScope;
            }

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    2.$$$reportNull$$$0(1);
                }
                element.renderElement(presentation);
                PresentableSymbol symbol = (PresentableSymbol)ObjectUtils.tryCast((Object)((Pointer)SymbolLookupElementKeys.SYMBOL_POINTER.getRequired((UserDataHolder)element)).dereference(), PresentableSymbol.class);
                if (symbol == null) {
                    return;
                }
                SymbolPresentation symbolPresentation = symbol.getPresentation(project, this.val$searchScope);
                presentation.setIcon(symbolPresentation.icon());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/model/completion/RubyCompletableSymbolService$2";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/completion/RubyCompletableSymbolService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/completion/RubyCompletableSymbolService";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asLookupElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asLookupElement";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createGlobalVariableSymbolExpensiveRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolPresentationExpensiveRenderer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8 -> new IllegalStateException(string);
        };
    }
}

